/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.module.db.internal.config.processor;

import org.mule.module.db.internal.domain.executor.UpdateExecutorFactory;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.metadata.UpdateMetadataProvider;
import org.mule.module.db.internal.processor.UpdateMessageProcessor;

import java.util.List;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class SingleUpdateProcessorDefinitionParser extends AbstractSingleQueryProcessorDefinitionParser
{

    private final List<QueryType> validQueryTypes;

    public SingleUpdateProcessorDefinitionParser(List<QueryType> validQueryTypes)
    {
        this.validQueryTypes = validQueryTypes;
    }

    @Override
    protected Class<?> getBeanClass(Element element)
    {
        return UpdateMessageProcessor.class;
    }

    @Override
    protected Object createExecutorFactory(Element element)
    {
        BeanDefinitionBuilder executorFactoryBean = BeanDefinitionBuilder.genericBeanDefinition(UpdateExecutorFactory.class);

        executorFactoryBean.addConstructorArgValue(parseStatementFactory(element));

        return executorFactoryBean.getBeanDefinition();
    }

    @Override
    protected void doParse(Element element, ParserContext context, BeanDefinitionBuilder builder)
    {
        parseAutoGeneratedKeys(element, builder);

        super.doParse(element, context, builder);

        builder.addConstructorArgValue(validQueryTypes);
    }

    @Override
    protected Object getMetadataProvider()
    {
        BeanDefinitionBuilder metadataProviderBuilder = BeanDefinitionBuilder.genericBeanDefinition(UpdateMetadataProvider.class);
        metadataProviderBuilder.addConstructorArgValue(dbConfigResolverFactoryBeanDefinition);
        metadataProviderBuilder.addConstructorArgValue(queryBean);
        metadataProviderBuilder.addConstructorArgValue(autoGeneratedKeyStrategy);

        return metadataProviderBuilder.getBeanDefinition();
    }

}
