/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.mule.api.security.tls.TlsConfiguration;
import org.mule.transport.tcp.TcpServerSocketFactory;

public class SslServerSocketFactory
extends TcpServerSocketFactory {
    private TlsConfiguration tls;

    public SslServerSocketFactory(TlsConfiguration tls) {
        this.tls = tls;
    }

    public ServerSocket createServerSocket(InetAddress address, int port, int backlog, Boolean reuse) throws IOException {
        try {
            SSLServerSocketFactory ssf = this.tls.getServerSocketFactory();
            return this.configure(ssf.createServerSocket(), reuse, new InetSocketAddress(address, port), backlog);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public ServerSocket createServerSocket(int port, int backlog, Boolean reuse) throws IOException {
        try {
            SSLServerSocketFactory ssf = this.tls.getServerSocketFactory();
            return this.configure(ssf.createServerSocket(), reuse, new InetSocketAddress(port), backlog);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }
}

