/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.internal.impl.commons.type.JsonSchemaExternalType;
import org.raml.v2.internal.impl.commons.type.XmlSchemaExternalType;
import org.raml.v2.internal.utils.xml.XsdResourceResolver;
import org.xml.sax.SAXException;

public class SchemaGenerator {
    public static Schema generateXmlSchema(ResourceLoader resourceLoader, XmlSchemaExternalType schemaNode) throws SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        factory.setResourceResolver(new XsdResourceResolver(resourceLoader, schemaNode.getSchemaPath()));
        return factory.newSchema(new StreamSource(new StringReader(schemaNode.getSchemaValue())));
    }

    public static JsonSchema generateJsonSchema(JsonSchemaExternalType jsonTypeDefinition) throws IOException, ProcessingException {
        JsonNode jsonSchema = JsonLoader.fromString((String)jsonTypeDefinition.getSchemaValue());
        JsonSchemaFactory factory = JsonSchemaFactory.newBuilder().freeze();
        if (jsonTypeDefinition.getInternalFragment() != null) {
            return factory.getJsonSchema(jsonSchema, "/definitions/" + jsonTypeDefinition.getInternalFragment());
        }
        return factory.getJsonSchema(jsonSchema);
    }

    public static boolean isJsonSchema(String schema) {
        return schema.trim().startsWith("{");
    }

    public static boolean isXmlSchema(String schema) {
        return schema.trim().startsWith("<");
    }
}

