/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jul;

import java.util.Collections;
import java.util.Enumeration;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.jul.AbstractLoggerAdapter;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.PropertiesUtil;

public class LogManager
extends java.util.logging.LogManager {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final AbstractLoggerAdapter loggerAdapter;

    public LogManager() {
        AbstractLoggerAdapter adapter = null;
        String overrideAdaptorClassName = PropertiesUtil.getProperties().getStringProperty("log4j.jul.LoggerAdapter");
        if (overrideAdaptorClassName != null) {
            try {
                LOGGER.info("Trying to use LoggerAdaptor [{}] specified by Log4j property.", new Object[]{overrideAdaptorClassName});
                adapter = (AbstractLoggerAdapter)((Object)LoaderUtil.newCheckedInstanceOf((String)overrideAdaptorClassName, AbstractLoggerAdapter.class));
            }
            catch (Exception e) {
                LOGGER.error("Specified LoggerAdapter [{}] is incompatible.", new Object[]{overrideAdaptorClassName, e});
            }
        }
        if (adapter == null) {
            String adapterClassName;
            try {
                LoaderUtil.loadClass((String)"org.apache.logging.log4j.core.Logger");
                adapterClassName = "org.apache.logging.log4j.jul.CoreLoggerAdapter";
            }
            catch (ClassNotFoundException ignored) {
                adapterClassName = "org.apache.logging.log4j.jul.ApiLoggerAdapter";
            }
            LOGGER.debug("Attempting to use {}", new Object[]{adapterClassName});
            try {
                adapter = (AbstractLoggerAdapter)((Object)LoaderUtil.newCheckedInstanceOf((String)adapterClassName, AbstractLoggerAdapter.class));
            }
            catch (Exception e) {
                throw (LoggingException)LOGGER.throwing((Throwable)new LoggingException((Throwable)e));
            }
        }
        this.loggerAdapter = adapter;
        LOGGER.info("Registered Log4j as the java.util.logging.LogManager.");
    }

    @Override
    public boolean addLogger(java.util.logging.Logger logger) {
        return false;
    }

    @Override
    public java.util.logging.Logger getLogger(String name) {
        LOGGER.trace("Call to LogManager.getLogger({})", new Object[]{name});
        return (java.util.logging.Logger)this.loggerAdapter.getLogger(name);
    }

    @Override
    public Enumeration<String> getLoggerNames() {
        return Collections.enumeration(this.loggerAdapter.getLoggersInContext(this.loggerAdapter.getContext()).keySet());
    }
}

