/*
 * Decompiled with CFR 0.152.
 */
package org.mule.construct.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChainBuilder;
import org.mule.api.processor.ProcessingStrategy;
import org.mule.api.source.MessageSource;
import org.mule.api.transport.ReplyToHandler;
import org.mule.config.ChainedThreadingProfile;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.construct.AbstractPipeline;
import org.mule.construct.Flow;
import org.mule.context.notification.AsyncMessageNotification;
import org.mule.context.notification.PipelineMessageNotification;
import org.mule.context.notification.ServerNotificationManager;
import org.mule.endpoint.AbstractMessageProcessorTestCase;
import org.mule.exception.DefaultMessagingExceptionStrategy;
import org.mule.management.stats.AllStatistics;
import org.mule.processor.ResponseMessageProcessorAdapter;
import org.mule.processor.strategy.AsynchronousProcessingStrategy;
import org.mule.processor.strategy.NonBlockingProcessingStrategy;
import org.mule.registry.DefaultRegistryBroker;
import org.mule.registry.MuleRegistryHelper;
import org.mule.tck.SensingNullMessageProcessor;
import org.mule.tck.SensingNullReplyToHandler;
import org.mule.tck.TriggerableMessageSource;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.transformer.simple.StringAppendTransformer;

@RunWith(value=MockitoJUnitRunner.class)
public class PipelineMessageNotificationTestCase
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleContext muleContext;
    private MuleEvent event;
    private ServerNotificationManager notificationManager;
    private TestPipeline pipeline;
    private final String pipelineName = "testPipeline";

    @Before
    public void createMocks() throws Exception {
        Mockito.when((Object)this.muleContext.getStatistics()).thenReturn((Object)new AllStatistics());
        Mockito.when((Object)this.muleContext.getConfiguration()).thenReturn((Object)new DefaultMuleConfiguration());
        Mockito.when((Object)this.muleContext.getRegistry()).thenReturn((Object)new MuleRegistryHelper(new DefaultRegistryBroker(this.muleContext), this.muleContext));
        Mockito.when((Object)this.muleContext.getDefaultThreadingProfile()).thenReturn((Object)new ChainedThreadingProfile());
        this.notificationManager = (ServerNotificationManager)Mockito.mock(ServerNotificationManager.class);
        Mockito.when((Object)this.muleContext.getNotificationManager()).thenReturn((Object)this.notificationManager);
        this.pipeline = new TestPipeline("testPipeline", this.muleContext);
    }

    @Test
    public void requestResponse() throws MuleException {
        TriggerableMessageSource source = new TriggerableMessageSource();
        this.pipeline.setMessageSource((MessageSource)source);
        this.pipeline.initialise();
        this.event = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"request", this.muleContext), MessageExchangePattern.REQUEST_RESPONSE, (FlowConstruct)this.pipeline);
        source.trigger(this.event);
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1801, false, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1802, false, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1804, false, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)3))).fireNotification((ServerNotification)Matchers.any(PipelineMessageNotification.class));
    }

    @Test
    public void requestResponseNonBlocking() throws Exception {
        this.assertRequestResponseNonBlockingWithMessageProcessor(new SensingNullMessageProcessor());
    }

    @Test
    public void requestResponseNonBlockingWithBlockingMessageProcessor() throws Exception {
        this.assertRequestResponseNonBlockingWithMessageProcessor((MessageProcessor)new StringAppendTransformer(""));
    }

    private void assertRequestResponseNonBlockingWithMessageProcessor(MessageProcessor messageProcessor) throws Exception {
        TriggerableMessageSource source = new TriggerableMessageSource();
        this.pipeline.setMessageSource((MessageSource)source);
        this.pipeline.setProcessingStrategy((ProcessingStrategy)new NonBlockingProcessingStrategy());
        this.pipeline.setMessageProcessors(Collections.singletonList(messageProcessor));
        this.pipeline.initialise();
        SensingNullReplyToHandler nullReplyToHandler = new SensingNullReplyToHandler();
        this.event = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"request", this.muleContext), MessageExchangePattern.REQUEST_RESPONSE, (ReplyToHandler)nullReplyToHandler, (FlowConstruct)this.pipeline);
        source.trigger(this.event);
        nullReplyToHandler.latch.await(5000L, TimeUnit.MILLISECONDS);
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1801, false, null)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1802, false, null)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1804, false, null)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)3))).fireNotification((ServerNotification)Matchers.any(PipelineMessageNotification.class));
    }

    @Test
    public void oneWay() throws MuleException, InterruptedException {
        TriggerableMessageSource source = new TriggerableMessageSource();
        this.pipeline.setMessageSource((MessageSource)source);
        this.pipeline.initialise();
        this.event = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"request", this.muleContext), MessageExchangePattern.ONE_WAY, (FlowConstruct)this.pipeline);
        source.trigger(this.event);
        this.pipeline.latch.await(5000L, TimeUnit.MILLISECONDS);
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1801, false, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1802, false, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1804, false, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)3))).fireNotification((ServerNotification)Matchers.any(PipelineMessageNotification.class));
    }

    @Test
    public void requestResponseRequestException() throws MuleException, InterruptedException {
        TriggerableMessageSource source = new TriggerableMessageSource();
        this.pipeline.setMessageSource((MessageSource)source);
        this.pipeline.setExceptionListener((MessagingExceptionHandler)new DefaultMessagingExceptionStrategy());
        ArrayList<AbstractMessageProcessorTestCase.ExceptionThrowingMessageProcessr> processors = new ArrayList<AbstractMessageProcessorTestCase.ExceptionThrowingMessageProcessr>();
        processors.add(new AbstractMessageProcessorTestCase.ExceptionThrowingMessageProcessr());
        this.pipeline.setMessageProcessors(processors);
        this.pipeline.initialise();
        this.event = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"request", this.muleContext), MessageExchangePattern.REQUEST_RESPONSE, (FlowConstruct)this.pipeline);
        try {
            source.trigger(this.event);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1801, false, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1804, true, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)2))).fireNotification((ServerNotification)Matchers.any(PipelineMessageNotification.class));
    }

    @Test
    public void requestResponseNonBlockingRequestException() throws MuleException, InterruptedException {
        TriggerableMessageSource source = new TriggerableMessageSource();
        this.pipeline.setMessageSource((MessageSource)source);
        this.pipeline.setExceptionListener((MessagingExceptionHandler)new DefaultMessagingExceptionStrategy());
        ArrayList<MessageProcessor> processors = new ArrayList<MessageProcessor>();
        processors.add(new AbstractMessageProcessorTestCase.ExceptionThrowingMessageProcessr());
        processors.add(new SensingNullMessageProcessor());
        this.pipeline.setMessageProcessors(processors);
        this.pipeline.setProcessingStrategy((ProcessingStrategy)new NonBlockingProcessingStrategy());
        this.pipeline.initialise();
        SensingNullReplyToHandler nullReplyToHandler = new SensingNullReplyToHandler();
        this.event = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"request", this.muleContext), MessageExchangePattern.REQUEST_RESPONSE, (ReplyToHandler)nullReplyToHandler, (FlowConstruct)this.pipeline);
        try {
            source.trigger(this.event);
        }
        catch (Exception exception) {
            // empty catch block
        }
        nullReplyToHandler.latch.await(5000L, TimeUnit.MILLISECONDS);
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1801, false, null)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1804, true, null)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)2))).fireNotification((ServerNotification)Matchers.any(PipelineMessageNotification.class));
    }

    @Test
    public void requestResponseNonBlockingResponseException() throws MuleException, InterruptedException {
        TriggerableMessageSource source = new TriggerableMessageSource();
        this.pipeline.setMessageSource((MessageSource)source);
        this.pipeline.setExceptionListener((MessagingExceptionHandler)new DefaultMessagingExceptionStrategy());
        ArrayList<Object> processors = new ArrayList<Object>();
        processors.add(new ResponseMessageProcessorAdapter((MessageProcessor)new AbstractMessageProcessorTestCase.ExceptionThrowingMessageProcessr()));
        processors.add((Object)new SensingNullMessageProcessor());
        this.pipeline.setMessageProcessors(processors);
        this.pipeline.setProcessingStrategy((ProcessingStrategy)new NonBlockingProcessingStrategy());
        this.pipeline.initialise();
        SensingNullReplyToHandler nullReplyToHandler = new SensingNullReplyToHandler();
        this.event = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"request", this.muleContext), MessageExchangePattern.REQUEST_RESPONSE, (ReplyToHandler)nullReplyToHandler, (FlowConstruct)this.pipeline);
        try {
            source.trigger(this.event);
        }
        catch (Exception exception) {
            // empty catch block
        }
        nullReplyToHandler.latch.await(5000L, TimeUnit.MILLISECONDS);
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1801, false, null)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1802, false, null)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1804, true, null)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)3))).fireNotification((ServerNotification)Matchers.any(PipelineMessageNotification.class));
    }

    @Test
    public void requestResponseResponseException() throws MuleException, InterruptedException {
        TriggerableMessageSource source = new TriggerableMessageSource();
        this.pipeline.setMessageSource((MessageSource)source);
        this.pipeline.setExceptionListener((MessagingExceptionHandler)new DefaultMessagingExceptionStrategy());
        ArrayList<ResponseMessageProcessorAdapter> processors = new ArrayList<ResponseMessageProcessorAdapter>();
        processors.add(new ResponseMessageProcessorAdapter((MessageProcessor)new AbstractMessageProcessorTestCase.ExceptionThrowingMessageProcessr()));
        this.pipeline.setMessageProcessors(processors);
        this.pipeline.initialise();
        this.event = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"request", this.muleContext), MessageExchangePattern.REQUEST_RESPONSE, (FlowConstruct)this.pipeline);
        try {
            source.trigger(this.event);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1801, false, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1802, false, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1804, true, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)3))).fireNotification((ServerNotification)Matchers.any(PipelineMessageNotification.class));
    }

    @Test
    public void oneWayRequestException() throws MuleException, InterruptedException {
        TriggerableMessageSource source = new TriggerableMessageSource();
        this.pipeline.setMessageSource((MessageSource)source);
        this.pipeline.setExceptionListener((MessagingExceptionHandler)new DefaultMessagingExceptionStrategy());
        ArrayList<AbstractMessageProcessorTestCase.ExceptionThrowingMessageProcessr> processors = new ArrayList<AbstractMessageProcessorTestCase.ExceptionThrowingMessageProcessr>();
        processors.add(new AbstractMessageProcessorTestCase.ExceptionThrowingMessageProcessr());
        this.pipeline.setMessageProcessors(processors);
        this.pipeline.initialise();
        this.event = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"request", this.muleContext), MessageExchangePattern.ONE_WAY, (FlowConstruct)this.pipeline);
        try {
            source.trigger(this.event);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1801, false, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1804, true, null)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)2))).fireNotification((ServerNotification)Matchers.any(PipelineMessageNotification.class));
    }

    @Test
    public void oneWayAsyncRequestException() throws MuleException, InterruptedException {
        TriggerableMessageSource source = new TriggerableMessageSource();
        Flow pipeline = new Flow("test", this.muleContext);
        pipeline.setProcessingStrategy((ProcessingStrategy)new AsynchronousProcessingStrategy());
        final CountDownLatch latch = new CountDownLatch(1);
        pipeline.setMessageSource((MessageSource)source);
        pipeline.setExceptionListener((MessagingExceptionHandler)new DefaultMessagingExceptionStrategy());
        ArrayList<1> processors = new ArrayList<1>();
        processors.add(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                latch.countDown();
                throw new RuntimeException("error");
            }
        });
        pipeline.setMessageProcessors(processors);
        pipeline.initialise();
        pipeline.start();
        this.event = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"request", this.muleContext), MessageExchangePattern.ONE_WAY, (FlowConstruct)pipeline);
        source.trigger(this.event);
        latch.await(5000L, TimeUnit.MILLISECONDS);
        Thread.sleep(2000L);
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1801, false, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1901, false, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1804, false, null)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1902, false, null)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(2001, false, null)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(2002, false, null)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)6))).fireNotification((ServerNotification)Matchers.any(PipelineMessageNotification.class));
    }

    private class PipelineMessageNotificiationArgumentMatcher
    extends ArgumentMatcher<PipelineMessageNotification> {
        private int expectedAction;
        private boolean exceptionExpected;
        private MuleEvent event;

        public PipelineMessageNotificiationArgumentMatcher(int expectedAction, boolean exceptionExpected, MuleEvent event) {
            this.expectedAction = expectedAction;
            this.exceptionExpected = exceptionExpected;
            this.event = event;
        }

        public boolean matches(Object argument) {
            ServerNotification notification = (ServerNotification)argument;
            if (this.exceptionExpected) {
                MessagingException exception = null;
                if (notification instanceof PipelineMessageNotification) {
                    exception = ((PipelineMessageNotification)notification).getException();
                } else if (notification instanceof AsyncMessageNotification) {
                    exception = ((AsyncMessageNotification)notification).getException();
                }
                return this.expectedAction == notification.getAction() && exception != null && notification.getSource() != null && (this.event == null || this.event == notification.getSource());
            }
            return this.expectedAction == notification.getAction() && notification.getSource() != null && (this.event == null || this.event == notification.getSource());
        }
    }

    private class TestPipeline
    extends AbstractPipeline {
        CountDownLatch latch;

        public TestPipeline(String name, MuleContext muleContext) {
            super(name, muleContext);
            this.latch = new CountDownLatch(2);
        }

        protected void configureMessageProcessors(MessageProcessorChainBuilder builder) throws MuleException {
            builder.chain(new MessageProcessor[]{new MessageProcessor(){

                public MuleEvent process(MuleEvent event) throws MuleException {
                    TestPipeline.this.latch.countDown();
                    return event;
                }
            }});
            super.configureMessageProcessors(builder);
        }

        protected void configurePostProcessors(MessageProcessorChainBuilder builder) throws MuleException {
            super.configurePostProcessors(builder);
            builder.chain(new MessageProcessor[]{new MessageProcessor(){

                public MuleEvent process(MuleEvent event) throws MuleException {
                    TestPipeline.this.latch.countDown();
                    return event;
                }
            }});
        }

        public String getConstructType() {
            return "test";
        }
    }
}

