/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.TransformerException;
import org.mule.processor.InvokerMessageProcessor;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;

public class InvokerMessageProcessorTestCase
extends AbstractMuleContextTestCase {
    private InvokerMessageProcessor invoker;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.invoker = new InvokerMessageProcessor();
        this.invoker.setObject((Object)new TestInvokeObject());
        this.invoker.setMuleContext(muleContext);
    }

    @Test
    public void testMethodWithNoArgs() throws MuleException, Exception {
        this.invoker.setMethodName("testNoArgs");
        this.invoker.initialise();
        this.invoker.process(InvokerMessageProcessorTestCase.getTestEvent(""));
    }

    @Test
    public void testMethodFound() throws MuleException, Exception {
        this.invoker.setMethodName("testMethod");
        this.invoker.setArgumentExpressionsString("#[string:1],#[string:2],#[string:3],#[string:4],#[string:5],#[string:6],#[string:7],#[string:8],#[string:true],#[string:true],#[string:11]");
        this.invoker.initialise();
        this.invoker.process(InvokerMessageProcessorTestCase.getTestEvent(""));
    }

    @Test
    public void testMethodFoundNestedExpression() throws MuleException, Exception {
        this.invoker.setMethodName("testMethod3");
        this.invoker.setArgumentExpressionsString("#[string:#[string:1]]");
        this.invoker.initialise();
        Assert.assertEquals((Object)"1 echo", (Object)this.invoker.process(InvokerMessageProcessorTestCase.getTestEvent("")).getMessageAsString());
    }

    @Test
    public void testMethodFoundParseStringWithExpressions() throws MuleException, Exception {
        this.invoker.setMethodName("testMethod3");
        this.invoker.setArgumentExpressionsString("1-#[string:#[string:2]]-3");
        this.invoker.initialise();
        Assert.assertEquals((Object)"1-2-3 echo", (Object)this.invoker.process(InvokerMessageProcessorTestCase.getTestEvent("")).getMessageAsString());
    }

    @Test
    public void testMethodFoundParseStringNoExpressions() throws MuleException, Exception {
        this.invoker.setMethodName("testMethod3");
        this.invoker.setArgumentExpressionsString("1");
        this.invoker.initialise();
        Assert.assertEquals((Object)"1 echo", (Object)this.invoker.process(InvokerMessageProcessorTestCase.getTestEvent("")).getMessageAsString());
    }

    @Test
    public void testMethodFoundNullArgument() throws MuleException, Exception {
        this.invoker.setMethodName("testMethod3");
        this.invoker.setArguments(Collections.singletonList(null));
        this.invoker.initialise();
        Assert.assertEquals((Object)"null echo", (Object)this.invoker.process(InvokerMessageProcessorTestCase.getTestEvent("")).getMessageAsString());
    }

    @Test
    public void testMethodNameNotFound() throws MuleException, Exception {
        this.invoker.setMethodName("testMethodNotHere");
        this.invoker.setArgumentExpressionsString("#[string:1]");
        try {
            this.invoker.initialise();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertEquals(InitialisationException.class, e.getClass());
        }
    }

    @Test
    public void testMethodWithArgsNotFound() throws MuleException, Exception {
        this.invoker.setMethodName("testMethod");
        this.invoker.setArgumentExpressionsString("#[string:1]");
        try {
            this.invoker.initialise();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertEquals(InitialisationException.class, e.getClass());
        }
    }

    @Test
    public void testMethodWithArgTypes() throws MuleException, Exception {
        this.invoker.setMethodName("testDuplicateNameMethod");
        this.invoker.setArgumentExpressionsString("#[string:1], #[string:2]");
        this.invoker.setArgumentTypes(new Class[]{String.class, Integer.TYPE});
        this.invoker.initialise();
        Assert.assertEquals((Object)"12(string and int)", (Object)this.invoker.process(InvokerMessageProcessorTestCase.getTestEvent("")).getMessageAsString());
    }

    @Test
    public void testMethodWithPrimitiveArgTypes() throws MuleException, Exception {
        this.invoker.setMethodName("testDuplicateNameMethod");
        this.invoker.setArgumentTypes(new Class[]{String.class, Integer.class});
        this.invoker.setArguments(Arrays.asList("some String", 42));
        this.invoker.initialise();
        Assert.assertEquals((Object)"some String42(string and int)", (Object)this.invoker.process(InvokerMessageProcessorTestCase.getTestEvent("")).getMessageAsString());
    }

    @Test
    public void testCantTransform() throws MuleException, Exception {
        this.invoker.setMethodName("testMethod2");
        this.invoker.setArgumentExpressionsString("#[string:1]");
        this.invoker.initialise();
        try {
            this.invoker.process(InvokerMessageProcessorTestCase.getTestEvent(""));
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertEquals(MessagingException.class, e.getClass());
            Assert.assertEquals(TransformerException.class, e.getCause().getClass());
        }
    }

    @Test
    public void testReplacePayload() throws MuleException, Exception {
        this.invoker.setMethodName("testMethod3");
        this.invoker.setArgumentExpressionsString("#[payload:]");
        this.invoker.initialise();
        Assert.assertEquals((Object)"hello echo", (Object)this.invoker.process(InvokerMessageProcessorTestCase.getTestEvent("hello")).getMessageAsString());
    }

    @Test
    public void testArrayArg() throws MuleException, Exception {
        this.invoker.setMethodName("testArrayArg");
        this.invoker.setArguments(Collections.singletonList(new String[]{"#[string:1]", "#[string:2]"}));
        this.invoker.initialise();
        MuleEvent result = this.invoker.process(InvokerMessageProcessorTestCase.getTestEvent(""));
        Assert.assertEquals(String[].class, result.getMessage().getPayload().getClass());
        Assert.assertEquals((Object)"1", (Object)((String[])result.getMessage().getPayload())[0]);
        Assert.assertEquals((Object)"2", (Object)((String[])result.getMessage().getPayload())[1]);
    }

    @Test
    public void testListArg() throws MuleException, Exception {
        this.invoker.setMethodName("testListArg");
        this.invoker.setArguments(Collections.singletonList(Collections.singletonList("#[string:1]")));
        this.invoker.initialise();
        MuleEvent result = this.invoker.process(InvokerMessageProcessorTestCase.getTestEvent(""));
        Assert.assertTrue((boolean)List.class.isAssignableFrom(result.getMessage().getPayload().getClass()));
        Assert.assertEquals((Object)"1", ((List)result.getMessage().getPayload()).get(0));
    }

    @Test
    public void testListNestedMapArg() throws MuleException, Exception {
        this.invoker.setMethodName("testListArg");
        this.invoker.setArguments(Collections.singletonList(Collections.singletonList(Collections.singletonMap("#[string:key]", "#[string:val]"))));
        this.invoker.initialise();
        MuleEvent result = this.invoker.process(InvokerMessageProcessorTestCase.getTestEvent(""));
        Assert.assertTrue((boolean)List.class.isAssignableFrom(result.getMessage().getPayload().getClass()));
        Assert.assertEquals((Object)"val", ((Map)((List)result.getMessage().getPayload()).get(0)).get("key"));
    }

    @Test
    public void testMapArg() throws MuleException, Exception {
        this.invoker.setMethodName("testMapArg");
        this.invoker.setArguments(Collections.singletonList(Collections.singletonMap("#[string:key]", "#[string:val]")));
        this.invoker.initialise();
        MuleEvent result = this.invoker.process(InvokerMessageProcessorTestCase.getTestEvent(""));
        Assert.assertTrue((boolean)Map.class.isAssignableFrom(result.getMessage().getPayload().getClass()));
        Assert.assertEquals((Object)"val", ((Map)result.getMessage().getPayload()).get("key"));
    }

    @Test
    public void testLookupClassInstance() throws MuleException, Exception {
        muleContext.getRegistry().registerObject("object", (Object)new TestInvokeObject());
        this.invoker = new InvokerMessageProcessor();
        this.invoker.setMuleContext(muleContext);
        this.invoker.setObjectType(TestInvokeObject.class);
        this.invoker.setMethodName("testMethod3");
        this.invoker.setArgumentExpressionsString("#[string:1]");
        this.invoker.initialise();
        Assert.assertEquals((Object)"1 echo", (Object)this.invoker.process(InvokerMessageProcessorTestCase.getTestEvent("")).getMessageAsString());
    }

    private class TestInvokeObject {
        private TestInvokeObject() {
        }

        public void testMethod(Integer arg1, int arg2, Long arg3, long arg4, Double arg5, double arg6, Float arg7, float arg8, Boolean arg9, boolean arg10, String arg11) {
        }

        public void testNoArgs() {
        }

        public void testMethod2(Apple apple) {
        }

        public String testMethod3(String text) {
            return text + " echo";
        }

        public String testDuplicateNameMethod(String text, String text2) {
            return text + text2 + " (two strings)";
        }

        public String testDuplicateNameMethod(String text, int i) {
            return text + i + "(string and int)";
        }

        public String[] testArrayArg(String[] array) {
            return array;
        }

        public List<String> testListArg(List<String> list) {
            return list;
        }

        public Map<String, String> testMapArg(Map<String, String> map) {
            return map;
        }
    }
}

