/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.util.MapUtils;
import org.mule.util.SystemUtils;

@SmallTest
public class MapUtilsTestCase
extends AbstractMuleTestCase {
    @Test
    public void testMapCreationNullClass() {
        try {
            MapUtils.mapWithKeysAndValues(null, (Object[])null, (Object[])null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMapCreationWithoutElements() {
        Map m = MapUtils.mapWithKeysAndValues(HashMap.class, (Collection)null, (Collection)null);
        Assert.assertTrue((boolean)m.isEmpty());
    }

    @Test
    public void testCaseInsensitiveMapCreation() {
        List<String> strings = Arrays.asList("foo");
        Map m = MapUtils.mapWithKeysAndValues(CaseInsensitiveMap.class, strings.iterator(), strings.iterator());
        Assert.assertEquals((Object)"foo", m.get("foo"));
        Assert.assertEquals((Object)"foo", m.get("Foo"));
        Assert.assertEquals((Object)"foo", m.get("FOO"));
    }

    @Test
    public void testToStringNull() throws Exception {
        Map props = null;
        Assert.assertEquals((Object)"{}", (Object)MapUtils.toString(props, (boolean)false));
        Assert.assertEquals((Object)"{}", (Object)MapUtils.toString(props, (boolean)true));
    }

    @Test
    public void testToStringEmpty() throws Exception {
        HashMap props = new HashMap();
        Assert.assertEquals((Object)"{}", (Object)MapUtils.toString(props, (boolean)false));
        Assert.assertEquals((Object)"{}", (Object)MapUtils.toString(props, (boolean)true));
    }

    @Test
    public void testToStringSingleElement() throws Exception {
        Map props = MapUtils.mapWithKeysAndValues(HashMap.class, (Object[])new Object[]{"foo"}, (Object[])new Object[]{"bar"});
        Assert.assertEquals((Object)"{foo=bar}", (Object)MapUtils.toString((Map)props, (boolean)false));
        Assert.assertEquals((Object)("{" + SystemUtils.LINE_SEPARATOR + "foo=bar" + SystemUtils.LINE_SEPARATOR + "}"), (Object)MapUtils.toString((Map)props, (boolean)true));
    }

    @Test
    public void testToStringMultipleElements() throws Exception {
        Map props = MapUtils.mapWithKeysAndValues(HashMap.class, (Object[])new Object[]{"foo", "foozle"}, (Object[])new Object[]{"bar", "doozle"});
        String result = MapUtils.toString((Map)props, (boolean)false);
        Assert.assertTrue((result.indexOf("foo=bar") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("foozle=doozle") != -1 ? 1 : 0) != 0);
        result = MapUtils.toString((Map)props, (boolean)true);
        Assert.assertTrue((boolean)result.startsWith("{" + SystemUtils.LINE_SEPARATOR));
        Assert.assertTrue((result.indexOf("foo=bar") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("foozle=doozle") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)result.endsWith(SystemUtils.LINE_SEPARATOR + "}"));
    }
}

