/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.apache.commons.lang.Validate;
import org.mule.module.pgp.StreamTransformer;
import org.mule.module.pgp.TransformPolicy;

public class LazyTransformedInputStream
extends InputStream {
    private PipedInputStream in;
    private PipedOutputStream out;
    private TransformPolicy transformPolicy;
    private StreamTransformer transformer;

    public LazyTransformedInputStream(TransformPolicy transformPolicy, StreamTransformer transformer) throws IOException {
        Validate.notNull((Object)transformPolicy, (String)"The transformPolicy should not be null");
        Validate.notNull((Object)transformer, (String)"The transformer should not be null");
        this.in = new PipedInputStream();
        this.out = new PipedOutputStream(this.in);
        this.transformPolicy = transformPolicy;
        this.transformer = transformer;
        this.transformPolicy.initialize(this);
    }

    @Override
    public int available() throws IOException {
        this.transformPolicy.readRequest(100L);
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.transformPolicy.release();
    }

    protected void finalize() throws Throwable {
        this.transformPolicy.release();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int read() throws IOException {
        this.transformPolicy.readRequest(1L);
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.transformPolicy.readRequest(len);
        return this.in.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.transformPolicy.readRequest(b.length);
        return this.in.read(b);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        this.transformPolicy.readRequest(n);
        return this.in.skip(n);
    }

    PipedOutputStream getOut() {
        return this.out;
    }

    StreamTransformer getTransformer() {
        return this.transformer;
    }
}

