/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import java.math.BigInteger;
import org.jcodings.Encoding;
import org.jruby.RubyBoolean;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ast.NodeType;
import org.jruby.ast.executable.AbstractScript;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.impl.BaseBodyCompiler;
import org.jruby.compiler.impl.InheritedCacheCompiler;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.InvokeDynamicSupport;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.cli.Options;

public class InvokeDynamicCacheCompiler
extends InheritedCacheCompiler {
    public InvokeDynamicCacheCompiler(StandardASMCompiler scriptCompiler) {
        super(scriptCompiler);
    }

    @Override
    public void cacheConstant(BaseBodyCompiler method2, String constantName) {
        if (!((Boolean)Options.INVOKEDYNAMIC_CACHE_CONSTANTS.load()).booleanValue()) {
            super.cacheConstant(method2, constantName);
            return;
        }
        method2.loadThis();
        method2.loadThreadContext();
        method2.method.invokedynamic(constantName, CodegenUtils.sig(IRubyObject.class, AbstractScript.class, ThreadContext.class), InvokeDynamicSupport.getConstantHandle(), method2.getScopeIndex());
    }

    @Override
    public void cacheConstantBoolean(BaseBodyCompiler method2, String constantName) {
        if (!((Boolean)Options.INVOKEDYNAMIC_CACHE_CONSTANTS.load()).booleanValue()) {
            super.cacheConstantBoolean(method2, constantName);
            return;
        }
        method2.loadThis();
        method2.loadThreadContext();
        method2.method.invokedynamic(constantName, CodegenUtils.sig(Boolean.TYPE, AbstractScript.class, ThreadContext.class), InvokeDynamicSupport.getConstantBooleanHandle(), method2.getScopeIndex());
    }

    @Override
    public void cacheByteList(BaseBodyCompiler method2, ByteList contents) {
        if (!((Boolean)Options.INVOKEDYNAMIC_CACHE_LITERALS.load()).booleanValue()) {
            super.cacheByteList(method2, contents);
            return;
        }
        String asString = Helpers.rawBytesToString(contents.bytes());
        String encodingName = new String(contents.getEncoding().getName());
        method2.method.invokedynamic("getByteList", CodegenUtils.sig(ByteList.class, new Class[0]), InvokeDynamicSupport.getByteListHandle(), asString, encodingName);
    }

    @Override
    public void cacheRubyEncoding(BaseBodyCompiler method2, Encoding encoding2) {
        if (!((Boolean)Options.INVOKEDYNAMIC_CACHE_LITERALS.load()).booleanValue()) {
            super.cacheRubyEncoding(method2, encoding2);
            return;
        }
        String encodingName = new String(encoding2.getName());
        method2.loadThreadContext();
        method2.method.invokedynamic("getEncoding", CodegenUtils.sig(RubyEncoding.class, ThreadContext.class), InvokeDynamicSupport.getEncodingHandle(), encodingName);
    }

    @Override
    public int cacheClosure(BaseBodyCompiler method2, String closureMethod, int arity2, StaticScope scope, String file2, int line, boolean hasMultipleArgsHead, NodeType argsNodeId, ASTInspector inspector) {
        String descriptor = Helpers.buildBlockDescriptor(closureMethod, arity2, file2, line, hasMultipleArgsHead, argsNodeId, inspector);
        method2.loadThis();
        method2.loadThreadContext();
        int scopeIndex = this.cacheStaticScope(method2, scope);
        method2.method.invokedynamic("getBlockBody", CodegenUtils.sig(BlockBody.class, Object.class, ThreadContext.class, StaticScope.class), InvokeDynamicSupport.getBlockBodyHandle(), descriptor);
        return scopeIndex;
    }

    @Override
    public int cacheClosure19(BaseBodyCompiler method2, String closureMethod, int arity2, StaticScope scope, String file2, int line, boolean hasMultipleArgsHead, NodeType argsNodeId, String parameterList, ASTInspector inspector) {
        String descriptor = Helpers.buildBlockDescriptor19(closureMethod, arity2, file2, line, hasMultipleArgsHead, argsNodeId, parameterList, inspector);
        method2.loadThis();
        method2.loadThreadContext();
        int scopeIndex = this.cacheStaticScope(method2, scope);
        method2.method.invokedynamic("getBlockBody19", CodegenUtils.sig(BlockBody.class, Object.class, ThreadContext.class, StaticScope.class), InvokeDynamicSupport.getBlockBody19Handle(), descriptor);
        return scopeIndex;
    }

    @Override
    public void cacheRegexp(BaseBodyCompiler method2, ByteList pattern, int options2) {
        if (!((Boolean)Options.INVOKEDYNAMIC_CACHE_LITERALS.load()).booleanValue()) {
            super.cacheRegexp(method2, pattern, options2);
            return;
        }
        String asString = Helpers.rawBytesToString(pattern.bytes());
        String encodingName = new String(pattern.getEncoding().getName());
        method2.loadThreadContext();
        method2.method.invokedynamic("getRegexp", CodegenUtils.sig(RubyRegexp.class, ThreadContext.class), InvokeDynamicSupport.getRegexpHandle(), asString, encodingName, options2);
    }

    @Override
    public void cacheFixnum(BaseBodyCompiler method2, long value2) {
        if (!((Boolean)Options.INVOKEDYNAMIC_CACHE_LITERALS.load()).booleanValue()) {
            super.cacheFixnum(method2, value2);
            return;
        }
        method2.loadThreadContext();
        method2.method.invokedynamic("getFixnum", CodegenUtils.sig(RubyFixnum.class, ThreadContext.class), InvokeDynamicSupport.getFixnumHandle(), value2);
    }

    @Override
    public void cacheFloat(BaseBodyCompiler method2, double value2) {
        if (!((Boolean)Options.INVOKEDYNAMIC_CACHE_LITERALS.load()).booleanValue()) {
            super.cacheFloat(method2, value2);
            return;
        }
        method2.loadThreadContext();
        method2.method.invokedynamic("getFloat", CodegenUtils.sig(RubyFloat.class, ThreadContext.class), InvokeDynamicSupport.getFloatHandle(), value2);
    }

    @Override
    public int cacheStaticScope(BaseBodyCompiler method2, StaticScope scope) {
        String scopeString = Helpers.encodeScope(scope);
        int index2 = this.scopeCount++;
        method2.loadThis();
        method2.loadThreadContext();
        method2.loadStaticScope();
        method2.method.invokedynamic("getStaticScope", CodegenUtils.sig(StaticScope.class, AbstractScript.class, ThreadContext.class, StaticScope.class), InvokeDynamicSupport.getStaticScopeHandle(), scopeString, index2);
        return index2;
    }

    @Override
    public void loadStaticScope(BaseBodyCompiler method2, int index2) {
        method2.loadThis();
        method2.method.invokedynamic("getStaticScope", CodegenUtils.sig(StaticScope.class, AbstractScript.class), InvokeDynamicSupport.getLoadStaticScopeHandle(), index2);
    }

    @Override
    public void cacheCallSite(BaseBodyCompiler method2, String name2, CallType callType) {
        char callTypeChar = '\u0000';
        switch (callType) {
            case NORMAL: {
                callTypeChar = 'N';
                break;
            }
            case FUNCTIONAL: {
                callTypeChar = 'F';
                break;
            }
            case VARIABLE: {
                callTypeChar = 'V';
                break;
            }
            case SUPER: {
                callTypeChar = 'S';
            }
        }
        if (name2 == null) {
            name2 = "super";
        }
        method2.method.invokedynamic("getCallSite", CodegenUtils.sig(CallSite.class, new Class[0]), InvokeDynamicSupport.getCallSiteHandle(), name2, Character.valueOf(callTypeChar));
    }

    @Override
    public void cacheString(BaseBodyCompiler method2, ByteList contents, int codeRange) {
        if (!((Boolean)Options.INVOKEDYNAMIC_CACHE_LITERALS.load()).booleanValue()) {
            super.cacheString(method2, contents, codeRange);
            return;
        }
        String asString = Helpers.rawBytesToString(contents.bytes());
        String encodingName = new String(contents.getEncoding().getName());
        method2.loadThreadContext();
        method2.method.invokedynamic("getString", CodegenUtils.sig(RubyString.class, ThreadContext.class), InvokeDynamicSupport.getStringHandle(), asString, encodingName, codeRange);
    }

    @Override
    public void cacheBigInteger(BaseBodyCompiler method2, BigInteger bigint) {
        if (!((Boolean)Options.INVOKEDYNAMIC_CACHE_LITERALS.load()).booleanValue()) {
            super.cacheBigInteger(method2, bigint);
            return;
        }
        String asString = bigint.toString(16);
        method2.method.invokedynamic("getBigInteger", CodegenUtils.sig(BigInteger.class, new Class[0]), InvokeDynamicSupport.getBigIntegerHandle(), asString);
    }

    @Override
    public void cacheSymbol(BaseBodyCompiler method2, String symbol, Encoding encoding2) {
        if (!((Boolean)Options.INVOKEDYNAMIC_CACHE_LITERALS.load()).booleanValue()) {
            super.cacheSymbol(method2, symbol, encoding2);
            return;
        }
        method2.loadThreadContext();
        method2.method.invokedynamic("getSymbol", CodegenUtils.sig(RubySymbol.class, ThreadContext.class), InvokeDynamicSupport.getSymbolHandle(), symbol, encoding2.toString());
    }

    @Override
    public void cachedGetVariable(BaseBodyCompiler method2, String name2) {
        if (!((Boolean)Options.INVOKEDYNAMIC_CACHE_IVARS.load()).booleanValue()) {
            super.cachedGetVariable(method2, name2);
            return;
        }
        method2.loadSelf();
        method2.method.invokedynamic("get:" + name2, CodegenUtils.sig(IRubyObject.class, IRubyObject.class), InvokeDynamicSupport.getVariableHandle(), method2.getScriptCompiler().getSourcename(), method2.getLastLine() + 1);
    }

    @Override
    public void cachedSetVariable(BaseBodyCompiler method2, String name2, CompilerCallback valueCallback) {
        if (!((Boolean)Options.INVOKEDYNAMIC_CACHE_IVARS.load()).booleanValue()) {
            super.cachedSetVariable(method2, name2, valueCallback);
            return;
        }
        method2.loadSelf();
        valueCallback.call(method2);
        method2.method.invokedynamic("set:" + name2, CodegenUtils.sig(IRubyObject.class, IRubyObject.class, IRubyObject.class), InvokeDynamicSupport.getVariableHandle(), method2.getScriptCompiler().getSourcename(), method2.getLastLine() + 1);
    }

    @Override
    public void cacheGlobal(BaseBodyCompiler method2, String globalName) {
        method2.loadThreadContext();
        method2.method.invokedynamic("get:" + JavaNameMangler.mangleMethodName(globalName), CodegenUtils.sig(IRubyObject.class, ThreadContext.class), InvokeDynamicSupport.getGlobalHandle(), method2.getScriptCompiler().getSourcename(), method2.getLastLine() + 1);
    }

    @Override
    public void cacheGlobalBoolean(BaseBodyCompiler method2, String globalName) {
        method2.loadThreadContext();
        method2.method.invokedynamic("getBoolean:" + JavaNameMangler.mangleMethodName(globalName), CodegenUtils.sig(Boolean.TYPE, ThreadContext.class), InvokeDynamicSupport.getGlobalBooleanHandle(), method2.getScriptCompiler().getSourcename(), method2.getLastLine() + 1);
    }

    @Override
    public void cacheBoolean(BaseBodyCompiler method2, boolean tru) {
        method2.loadThreadContext();
        method2.method.invokedynamic("loadBoolean:" + tru, CodegenUtils.sig(RubyBoolean.class, ThreadContext.class), InvokeDynamicSupport.getLoadBooleanHandle(), new Object[0]);
    }
}

