/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.ArrayList;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.StandardFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SystemFunctionCall
extends FunctionCall
implements Callable {
    private int originalArity = -1;
    private StandardFunction.Entry details;
    protected int operation;

    public void setOriginalArity(int arity) {
        this.originalArity = arity;
    }

    public int getOriginalArity() {
        return this.originalArity == -1 ? this.getNumberOfArguments() : this.originalArity;
    }

    public Callable getConvertingCallable() {
        final SystemFunctionCall raw = this;
        return new Callable(){

            public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
                Sequence[] convertedArgs = new Sequence[arguments.length];
                for (int i = 0; i < arguments.length; ++i) {
                    RoleLocator role = new RoleLocator(0, SystemFunctionCall.this.getFunctionName(), i);
                    SequenceType requiredType = SystemFunctionCall.this.getRequiredType(i);
                    TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
                    convertedArgs[i] = th.applyFunctionConversionRules(arguments[i], requiredType, role, SystemFunctionCall.this.getContainer());
                }
                return raw.call(context, convertedArgs);
            }
        };
    }

    public static FunctionCall makeSystemFunction(String name, Expression[] arguments) {
        StandardFunction.Entry entry = StandardFunction.getFunction(name, arguments.length);
        if (entry == null) {
            return null;
        }
        if ((entry.properties & 0x40) != 0 && arguments.length == 0) {
            Expression[] newArgs = new Expression[]{new ContextItemExpression()};
            return SystemFunctionCall.makeSystemFunction(name, newArgs);
        }
        if ((entry.properties & 0x80) != 0) {
            int arity = arguments.length;
            Expression[] newArgs = new Expression[arity + 1];
            System.arraycopy(arguments, 0, newArgs, 0, arity);
            newArgs[arity] = new RootExpression();
            return SystemFunctionCall.makeSystemFunction(name, newArgs);
        }
        Class functionClass = entry.implementationClass;
        try {
            SystemFunctionCall f = (SystemFunctionCall)functionClass.newInstance();
            f.setDetails(entry);
            f.setFunctionName(new StructuredQName("", "http://www.w3.org/2005/xpath-functions", name));
            f.setArguments(arguments);
            return f;
        }
        catch (IllegalAccessException err) {
            return null;
        }
        catch (InstantiationException err) {
            return null;
        }
    }

    public void setDetails(StandardFunction.Entry entry) {
        this.details = entry;
        this.operation = this.details.opcode;
    }

    public StandardFunction.Entry getDetails() {
        return this.details;
    }

    public int getOperation() {
        return this.operation;
    }

    @Override
    public int getImplementationMethod() {
        boolean feedable = this.getNumberOfArguments() > 0 && !Cardinality.allowsMany(this.getRequiredType(0).getCardinality());
        int methods = super.getImplementationMethod();
        if (feedable) {
            methods |= 0x10;
        }
        return methods;
    }

    public NodeInfo getDefaultArgumentNode(XPathContext context, Sequence[] arguments, String funcName) throws XPathException {
        if (arguments.length == 0) {
            Item item = context.getContextItem();
            if (item == null) {
                throw new XPathException("Context item for " + funcName + " is absent", "XPDY0002");
            }
            if (!(item instanceof NodeInfo)) {
                throw new XPathException("Context item for " + funcName + " must be a node", "XPTY0004");
            }
            return (NodeInfo)item;
        }
        return (NodeInfo)arguments[0].head();
    }

    public void bindStaticContext(StaticContext env) throws XPathException {
    }

    @Override
    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        this.checkArgumentCount(this.details.minArguments, this.details.maxArguments);
        for (int i = 0; i < this.argument.length; ++i) {
            this.checkArgument(i, visitor);
        }
    }

    private void checkArgument(int arg, ExpressionVisitor visitor) throws XPathException {
        RoleLocator role = new RoleLocator(0, this.getFunctionName(), arg);
        role.setErrorCode(this.getErrorCodeForTypeErrors());
        this.argument[arg] = TypeChecker.staticTypeCheck(this.argument[arg], this.getRequiredType(arg), visitor.getStaticContext().isInBackwardsCompatibleMode(), role, visitor);
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        Expression sf = super.optimize(visitor, contextItemType);
        if (sf == this && this.argument.length <= this.details.resultIfEmpty.length) {
            for (int i = 0; i < this.argument.length; ++i) {
                if (!Literal.isEmptySequence(this.argument[i]) || this.details.resultIfEmpty[i] == null) continue;
                return Literal.makeLiteral(SequenceTool.toGroundedValue(this.details.resultIfEmpty[i]), this.getContainer());
            }
        }
        return sf;
    }

    @Override
    public Expression copy() {
        Expression[] a2 = new Expression[this.argument.length];
        for (int i = 0; i < this.argument.length; ++i) {
            a2[i] = this.argument[i].copy();
        }
        FunctionCall e2 = SystemFunctionCall.makeSystemFunction(this.details.name, a2);
        if (e2 == null) {
            throw new UnsupportedOperationException("SystemFunction.copy()");
        }
        ExpressionTool.copyLocationInfo(this, e2);
        return e2;
    }

    @Override
    public Iterable<Operand> operands() {
        try {
            ArrayList<Operand> list = new ArrayList<Operand>(this.argument.length);
            for (int i = 0; i < this.argument.length; ++i) {
                list.add(new Operand(this.argument[i], new OperandRole(0, this.details.usage[i], this.details.argumentTypes[i])));
            }
            return list;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public boolean equals(Object o) {
        return o != null && o instanceof SystemFunctionCall && super.equals(o) && this.operation == ((SystemFunctionCall)o).operation;
    }

    public static boolean equalOrNull(Object x, Object y) {
        if (x == null) {
            return y == null;
        }
        return y != null && x.equals(y);
    }

    public String getErrorCodeForTypeErrors() {
        return "XPTY0004";
    }

    protected SequenceType getRequiredType(int arg) {
        if (this.details == null) {
            return SequenceType.ANY_SEQUENCE;
        }
        return this.details.argumentTypes[arg];
    }

    @Override
    public ItemType getItemType() {
        if (this.details == null) {
            return AnyItemType.getInstance();
        }
        ItemType type = this.details.itemType;
        if ((this.details.properties & 1) != 0) {
            if (this.argument.length > 0) {
                return this.argument[0].getItemType();
            }
            return AnyItemType.getInstance();
        }
        if ((this.details.properties & 2) != 0) {
            if (this.argument.length > 0) {
                ItemType t0 = this.argument[0].getItemType().getPrimitiveItemType();
                return t0 instanceof AtomicType ? t0 : type;
            }
            return AnyItemType.getInstance();
        }
        return type;
    }

    @Override
    public int computeCardinality() {
        if (this.details == null) {
            return 57344;
        }
        return this.details.cardinality;
    }

    @Override
    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        if (this.details == null) {
            return p;
        }
        if (this.details.itemType.isPlainType() || (this.details.properties & 1) != 0 || (this.details.properties & 2) != 0) {
            return p | 0x400000;
        }
        for (Expression anArgument : this.argument) {
            if ((anArgument.getSpecialProperties() & 0x400000) != 0) continue;
            return p;
        }
        return p | 0x400000;
    }

    protected final void useContextItemAsDefault(ExpressionVisitor visitor) {
    }

    protected final void addContextDocumentArgument(int pos, String augmentedName) throws XPathException {
    }

    public PathMap.PathMapNodeSet addDocToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodes) {
        this.argument[0].addToPathMap(pathMap, pathMapNodes);
        return new PathMap.PathMapNodeSet(pathMap.makeNewRoot(this));
    }

    protected NodeInfo getContextNode(XPathContext context) throws XPathException {
        Item item = context.getContextItem();
        if (item == null) {
            XPathException err = new XPathException("Context item for " + this.getFunctionName() + "() is absent", "XPDY0002");
            err.maybeSetContext(context);
            err.setLocator(this);
            throw err;
        }
        if (!(item instanceof NodeInfo)) {
            XPathException err = new XPathException("Context item for " + this.getFunctionName() + "() is not a node", "XPTY0004");
            err.maybeSetContext(context);
            err.setLocator(this);
            throw err;
        }
        return (NodeInfo)item;
    }

    @Override
    public String toShortString() {
        return this.getDisplayName() + "(" + (this.getNumberOfArguments() == 0 ? "" : "...") + ")";
    }
}

