<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:ixsl="http://saxonica.com/ns/interactiveXSLT"
  xmlns:prop="http://saxonica.com/ns/html-property" xmlns:style="http://saxonica.com/ns/html-style-property" xmlns:H="http://www.w3.org/1999/xhtml"
  extension-element-prefixes="ixsl" exclude-result-prefixes="xs" version="2.0">

  <xsl:include href="sortable-tables.xsl"/>

  <xsl:variable name="svg-path" select="'../svg/index/modes'"/>
  <xsl:template name="go">
    <xsl:result-document href="#loading" method="ixsl:replace-content"/>

    <!---->
    <!--<xsl:call-template name="showCase">
      <xsl:with-param name="case" select="1"/>
    </xsl:call-template>
    <xsl:apply-templates select="ixsl:page()//div[@class='tabset']" mode="init"/>-->
  </xsl:template>

  <xsl:template match="td[tokenize(@class,'\s+') = 'hasTip']" mode="ixsl:onmouseover">
    <xsl:for-each select="//div[@id = concat(current()/@tip,'ToolTip')]">
      <ixsl:set-attribute name="style:left"
        select="concat(ixsl:get(ixsl:event(), 'clientX') + 30, 'px')"/>
      <ixsl:set-attribute name="style:top"
        select="concat(ixsl:get(ixsl:event(), 'clientY') - 15, 'px')"/>
      <ixsl:set-attribute name="style:visibility" select="'visible'"/>
    </xsl:for-each>
  </xsl:template>
  <xsl:template match="td[tokenize(@class,'\s+') = 'hasTip']" mode="ixsl:onmouseout">
    <xsl:for-each select="//div[@id = concat(current()/@tip,'ToolTip')]">
      <ixsl:set-attribute name="style:visibility" select="'hidden'"/>
    </xsl:for-each>
  </xsl:template>



  <xsl:template match="td[tokenize(@class, '\s+') = 'link'][ends-with(@ref,'.svg')]" priority="2" mode="ixsl:onclick">
    <xsl:result-document href="#picture" method="ixsl:replace-content">
      <img src="{@ref}"/>
    </xsl:result-document>
  </xsl:template>
  <xsl:template match="td[tokenize(@class, '\s+') = 'link']" mode="ixsl:onclick">    
    <xsl:variable name="ref" select="@ref"/>
    <xsl:result-document href="#picture" method="ixsl:replace-content">
      <xsl:sequence select="ixsl:page()//div[@id = $ref]"/>
    </xsl:result-document>
  </xsl:template>
  
  
  <xsl:template name="showCase">
    <xsl:param name="case" as="xs:double"/>
    <xsl:for-each select="ixsl:page()//div[@class = 'Case']">
      <ixsl:set-attribute name="style" select="
          if (position() eq $case) then
            'display:inline'
          else
            'display:none'"
      />
    </xsl:for-each>
  </xsl:template>
  <xsl:template match="input[@id = 'unused']" mode="ixsl:onchange">
    <xsl:variable name="on" select="@prop:checked = 'true'"/>
    <xsl:for-each select="ixsl:page()//tr[@class = 'mode-unused']">
      <ixsl:set-attribute name="style" select="
          if ($on) then
            'display:none'
          else
            'display:visible'"/>
    </xsl:for-each>

  </xsl:template>

  <xsl:template match="select[@class = 'genSelector']" mode="ixsl:onchange">
    <xsl:variable name="chosen" select="@prop:value"/>
    <xsl:result-document href="#contain" method="ixsl:replace-content" xpath-default-namespace="">
      <!--<xsl:value-of select="resolve-uri($chosen)"/>-->
      <xsl:copy-of select="doc($chosen)//pre"/>
    </xsl:result-document>
    <xsl:for-each select="ixsl:page()//input[@class = 'showType']">
      <xsl:if test="@prop:checked = 'true'">
        <ixsl:set-attribute name="prop:checked" select="false()"/>
      </xsl:if>

    </xsl:for-each>
  </xsl:template>

  <!--<xsl:template match="select[@class='genSelector']" mode="ixsl:onchange" use-when="false()">
    <xsl:variable name="chosen" select="number(@prop:value)"/>
    <xsl:for-each select="following-sibling::div">
      <ixsl:set-attribute name="style"
        select="if(position() eq $chosen) then 'display:inline' else 'display:none'"/>
    </xsl:for-each>
  </xsl:template>-->

  <xsl:template match="input[@id = 'show.raw']" mode="ixsl:onclick">
    <xsl:variable name="checked" select="@prop:checked = 'true'"/>
    <xsl:if test="not(@prop:checked = 'true')">
      <xsl:result-document href="#raw" method="ixsl:replace-content"/>
    </xsl:if>
  </xsl:template>


  <xsl:template match="input[@class = 'showType']" mode="ixsl:onclick">
    <xsl:variable name="checked" select="@prop:checked = 'true'"/>
    <xsl:variable name="type" select="@value"/>
    <xsl:for-each select="ixsl:page()//pre//span[@type = $type]">
      <ixsl:set-attribute name="style" select="
          if ($checked) then
            'display:inline'
          else
            'display:none'"/>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="div[@class = 'tabset']/input" mode="ixsl:onclick">
    <xsl:variable name="name" select="@prop:value"/>
    <xsl:for-each select="../following-sibling::table/tbody/tr/td">
      <ixsl:set-attribute name="style" select="
          if (@name = $name) then
            'display:inline'
          else
            'display:none'"/>
    </xsl:for-each>
  </xsl:template>
  <xsl:template match="div[@class = 'tabset']" mode="init">
    <xsl:for-each select="following-sibling::table/tbody/tr/td">
      <ixsl:set-attribute name="style" select="
          if (position() eq 1) then
            'display:inline'
          else
            'display:none'"/>
    </xsl:for-each>
  </xsl:template>


  <xsl:template match="
      span[@class = 'folder']/span[@class = ('collapse',
      'expand')]" mode="ixsl:onclick">
    <xsl:variable name="action" select="@class"/>
    <xsl:for-each select="../span">
      <ixsl:set-attribute name="style" select="
          if ($action = @class) then
            'display:none'
          else
            'display:inline'"/>
    </xsl:for-each>
    <xsl:for-each select="
        (following::span[@class = ('XSLbody',
        'XMLbody')])[1]">
      <ixsl:set-attribute name="style" select="
          if ($action = 'collapse') then
            'display:none'
          else
            'display:inline'"
      />
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="
      span[@type = ('general',
      'generalOperand')]" mode="ixsl:onclick">
    <xsl:variable name="index" select="tokenize(text()[matches(., '\S+')], ',')"/>
    <xsl:for-each select="id('gsr', ixsl:page())//(li | td)">
      <ixsl:set-attribute name="style"
        select="
          if (@index = $index) then
            'background-color:tomato'
          else
            'background-color:transparent'"/>
    </xsl:for-each>
    <xsl:result-document href="#loading" method="ixsl:replace-content">
      <xsl:value-of select="$index"/>
    </xsl:result-document>
  </xsl:template>

</xsl:stylesheet>
