/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.mule.common.metadata.DefaultListMetaDataModel;
import org.mule.common.metadata.DefaultMetaDataField;
import org.mule.common.metadata.DefaultMetaDataFieldFactory;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.DefaultStructuredMetadataModel;
import org.mule.common.metadata.ListMetaDataModel;
import org.mule.common.metadata.MetaDataField;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.builder.CSVMetaDataBuilder;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.field.property.MetaDataFieldProperty;
import org.mule.common.metadata.property.CSVHasHeadersMetaDataProperty;
import org.mule.common.metadata.property.TextBasedExampleMetaDataModelProperty;

public class DefaultCSVMetaDataBuilder
implements CSVMetaDataBuilder {
    private List<MetaDataField> fields = new ArrayList<MetaDataField>();
    private boolean hasHeaders = true;
    private String example;

    @Override
    public CSVMetaDataBuilder addField(String fieldName, DataType type) {
        return this.addField(fieldName, type, Collections.emptyList());
    }

    @Override
    public CSVMetaDataBuilder addField(String fieldName, DataType type, List<MetaDataFieldProperty> fieldProperties) {
        Objects.requireNonNull(fieldProperties, "fieldProperties must not be null");
        this.fields.add(new DefaultMetaDataField(fieldName, (MetaDataModel)new DefaultSimpleMetaDataModel(type), MetaDataField.FieldAccessType.READ, fieldProperties));
        return this;
    }

    @Override
    public CSVMetaDataBuilder setHasHeaders(boolean hasHeaders) {
        this.hasHeaders = hasHeaders;
        return this;
    }

    @Override
    public CSVMetaDataBuilder setExample(String example) {
        this.example = example;
        return this;
    }

    @Override
    public ListMetaDataModel build() {
        if (this.fields.isEmpty()) {
            throw new IllegalStateException("At least one field should be declared");
        }
        DefaultStructuredMetadataModel metadataModel = new DefaultStructuredMetadataModel(DataType.CSV, new DefaultMetaDataFieldFactory(this.fields));
        metadataModel.addProperty(new CSVHasHeadersMetaDataProperty(this.hasHeaders));
        if (StringUtils.isNotBlank((String)this.example)) {
            metadataModel.addProperty(new TextBasedExampleMetaDataModelProperty(this.example));
        }
        return new DefaultListMetaDataModel(metadataModel);
    }
}

