/*
 * Decompiled with CFR 0.152.
 */
package org.yecht.ruby;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerable;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.TypeConverter;
import org.yecht.Data;
import org.yecht.ImplicitScanner2;
import org.yecht.Node;
import org.yecht.Pointer;
import org.yecht.ScalarStyle;
import org.yecht.ruby.ArrayStorageLink;
import org.yecht.ruby.HashStorageLink;
import org.yecht.ruby.PossibleLinkNode;
import org.yecht.ruby.YAMLExtra;

public class DefaultResolver {
    private static Map<String, ObjectCreator> scalarTypes = new HashMap<String, ObjectCreator>();

    private static int extractInt(byte[] buff, int p, int pend) {
        int len = 0;
        while (p + len < pend && Character.isDigit((char)buff[p + len])) {
            ++len;
        }
        try {
            return Integer.parseInt(new String(buff, p, len, "ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            return -1;
        }
    }

    public static IRubyObject makeTime(Ruby runtime, Pointer str, int len) {
        int ptr = str.start;
        int pend = ptr + len;
        RubyFixnum year = runtime.newFixnum(0);
        RubyFixnum mon = runtime.newFixnum(0);
        RubyFixnum day = runtime.newFixnum(0);
        RubyFixnum hour = runtime.newFixnum(0);
        RubyFixnum min = runtime.newFixnum(0);
        RubyFixnum sec = runtime.newFixnum(0);
        RubyFixnum addSec = runtime.newFixnum(0);
        long usec = 0L;
        if (str.buffer[ptr] != 0 && ptr < pend) {
            year = runtime.newFixnum(DefaultResolver.extractInt(str.buffer, ptr, pend));
        }
        if (str.buffer[ptr += 4] != 0 && ptr < pend) {
            while (!Character.isDigit((char)str.buffer[ptr]) && ptr < pend) {
                ++ptr;
            }
            mon = runtime.newFixnum(DefaultResolver.extractInt(str.buffer, ptr, pend));
        }
        if (str.buffer[ptr += 2] != 0 && ptr < pend) {
            while (!Character.isDigit((char)str.buffer[ptr]) && ptr < pend) {
                ++ptr;
            }
            day = runtime.newFixnum(DefaultResolver.extractInt(str.buffer, ptr, pend));
        }
        if (str.buffer[ptr += 2] != 0 && ptr < pend) {
            while (!Character.isDigit((char)str.buffer[ptr]) && ptr < pend) {
                ++ptr;
            }
            hour = runtime.newFixnum(DefaultResolver.extractInt(str.buffer, ptr, pend));
        }
        if (str.buffer[ptr += 2] != 0 && ptr < pend) {
            while (!Character.isDigit((char)str.buffer[ptr]) && ptr < pend) {
                ++ptr;
            }
            min = runtime.newFixnum(DefaultResolver.extractInt(str.buffer, ptr, pend));
        }
        if (str.buffer[ptr += 2] != 0 && ptr < pend) {
            while (!Character.isDigit((char)str.buffer[ptr]) && ptr < pend) {
                ++ptr;
            }
            sec = runtime.newFixnum(DefaultResolver.extractInt(str.buffer, ptr, pend));
        }
        if ((ptr += 2) < pend && str.buffer[ptr] == 46) {
            int end;
            for (end = ptr + 1; Character.isDigit((char)str.buffer[end]) && end < pend; ++end) {
            }
            byte[] padded = new byte[]{48, 48, 48, 48, 48, 48};
            int begin = ptr + 1;
            int extraSeconds = 0;
            if (end - begin > 6) {
                extraSeconds = end - begin - 6;
                addSec = runtime.newFixnum(DefaultResolver.extractInt(str.buffer, (begin += extraSeconds) - extraSeconds, begin));
            }
            System.arraycopy(str.buffer, begin, padded, 0, end - begin);
            try {
                usec = Long.parseLong(new String(padded, 0, 6, "ISO-8859-1"));
            }
            catch (UnsupportedEncodingException e) {}
        } else {
            usec = 0L;
        }
        while (ptr < pend && str.buffer[ptr] != 90 && str.buffer[ptr] != 43 && str.buffer[ptr] != 45 && str.buffer[ptr] != 0) {
            ++ptr;
        }
        if (ptr < pend && (str.buffer[ptr] == 45 || str.buffer[ptr] == 43)) {
            int lenx = 1;
            while (ptr + lenx < pend && Character.isDigit((char)str.buffer[ptr + lenx])) {
                ++lenx;
            }
            if (str.buffer[ptr] == 43) {
                ++ptr;
                --lenx;
            }
            try {
                long tz_offset = Long.parseLong(new String(str.buffer, ptr, lenx, "ISO-8859-1")) * 3600L;
                ptr += lenx;
                while (ptr < pend && str.buffer[ptr] != 58 && str.buffer[ptr] != 0) {
                    ++ptr;
                }
                if (ptr < pend && str.buffer[ptr] == 58) {
                    tz_offset = tz_offset < 0L ? (tz_offset -= (long)(DefaultResolver.extractInt(str.buffer, ptr, pend) * 60)) : (tz_offset += (long)(DefaultResolver.extractInt(str.buffer, ++ptr, pend) * 60));
                }
                IRubyObject time = runtime.getClass("Time").callMethod(runtime.getCurrentContext(), "utc", new IRubyObject[]{year, mon, day, hour, min, sec});
                long tmp = RubyNumeric.num2long((IRubyObject)time.callMethod(runtime.getCurrentContext(), "to_i")) - tz_offset;
                return ((RubyTime)runtime.getClass("Time").callMethod(runtime.getCurrentContext(), "at", new IRubyObject[]{runtime.newFixnum(tmp), runtime.newFixnum(usec)})).op_plus((IRubyObject)addSec);
            }
            catch (UnsupportedEncodingException e) {}
        } else {
            return ((RubyTime)runtime.getClass("Time").callMethod(runtime.getCurrentContext(), "utc", new IRubyObject[]{year, mon, day, hour, min, sec, runtime.newFixnum(usec)})).op_plus((IRubyObject)addSec);
        }
        System.err.println("oopsie, returning null");
        return null;
    }

    private static boolean handleScalar(Ruby runtime, Node n, String type_id, IRubyObject[] ref, YAMLExtra x) throws UnsupportedEncodingException {
        Data.Str ds = (Data.Str)n.data;
        ThreadContext ctx = runtime.getCurrentContext();
        boolean transferred = true;
        RubyString obj = null;
        if (type_id == null) {
            obj = RubyString.newStringShared((Ruby)runtime, (byte[])ds.ptr.buffer, (int)ds.ptr.start, (int)ds.len);
        } else if (ds.style == ScalarStyle.Plain && ds.len > 1 && ds.ptr.buffer[ds.ptr.start] == 58) {
            obj = x.DefaultResolver.callMethod(ctx, "transfer", new IRubyObject[]{runtime.newString("tag:ruby.yaml.org,2002:sym"), RubyString.newStringShared((Ruby)runtime, (byte[])ds.ptr.buffer, (int)(ds.ptr.start + 1), (int)(ds.len - 1))});
        } else {
            ObjectCreator oc = scalarTypes.get(type_id);
            if (oc != null) {
                obj = oc.create(runtime, n, ds);
            } else if (type_id.startsWith("int")) {
                n.strBlowAwayCommas();
                obj = RubyNumeric.str2inum((Ruby)runtime, (RubyString)RubyString.newStringShared((Ruby)runtime, (byte[])ds.ptr.buffer, (int)ds.ptr.start, (int)ds.len), (int)10, (boolean)true);
            } else if (type_id.startsWith("float")) {
                n.strBlowAwayCommas();
                obj = RubyString.newStringShared((Ruby)runtime, (byte[])ds.ptr.buffer, (int)ds.ptr.start, (int)ds.len);
                obj = obj.callMethod(ctx, "to_f");
            } else if (type_id.startsWith("timestamp")) {
                obj = DefaultResolver.makeTime(runtime, ds.ptr, ds.len);
            } else if (type_id.startsWith("merge")) {
                obj = x.MergeKey.callMethod(ctx, "new");
            } else if (type_id.startsWith("default")) {
                obj = x.DefaultKey.callMethod(ctx, "new");
            } else {
                transferred = false;
                obj = RubyString.newStringShared((Ruby)runtime, (byte[])ds.ptr.buffer, (int)ds.ptr.start, (int)ds.len);
            }
        }
        ref[0] = obj;
        return transferred;
    }

    public static boolean handleSeq(Ruby runtime, Node n, String type_id, IRubyObject[] ref) {
        boolean transferred = type_id == null || "seq".equals(type_id);
        Data.Seq dl = (Data.Seq)n.data;
        Object[] items = dl.items;
        RubyArray obj = RubyArray.newArray((Ruby)runtime, (int)dl.idx);
        for (int i = 0; i < dl.idx; ++i) {
            IRubyObject _obj = (IRubyObject)items[i];
            if (_obj instanceof PossibleLinkNode) {
                ((PossibleLinkNode)_obj).addLink(new ArrayStorageLink((IRubyObject)obj, i, _obj));
            }
            obj.store((long)i, _obj);
        }
        ref[0] = obj;
        return transferred;
    }

    public static boolean handleMap(final Ruby runtime, Node n, String type_id, IRubyObject[] ref, YAMLExtra x) {
        boolean transferred = type_id == null || "map".equals(type_id);
        ThreadContext ctx = runtime.getCurrentContext();
        Data.Map dm = (Data.Map)n.data;
        Object[] keys = dm.keys;
        Object[] vals = dm.values;
        RubyHash obj = RubyHash.newHash((Ruby)runtime);
        RubyClass cMergeKey = x.MergeKey;
        RubyClass cDefaultKey = x.DefaultKey;
        for (int i = 0; i < dm.idx; ++i) {
            IRubyObject k = (IRubyObject)keys[i];
            IRubyObject v = (IRubyObject)vals[i];
            if (null == v) {
                v = runtime.getNil();
            }
            boolean skip_aset = false;
            if (cMergeKey.isInstance(k)) {
                IRubyObject tmp = null;
                tmp = TypeConverter.convertToTypeWithCheck((IRubyObject)v, (RubyClass)runtime.getHash(), (String)"to_hash");
                if (!tmp.isNil()) {
                    RubyHash dup = (RubyHash)v.callMethod(ctx, "dup");
                    dup.callMethod(ctx, "update", (IRubyObject)obj);
                    obj = dup;
                    skip_aset = true;
                } else {
                    IRubyObject end;
                    IRubyObject tmph;
                    tmp = v.checkArrayType();
                    if (!tmp.isNil() && !(tmph = TypeConverter.convertToTypeWithCheck((IRubyObject)(end = ((RubyArray)tmp).pop(ctx)), (RubyClass)runtime.getHash(), (String)"to_hash")).isNil()) {
                        final RubyHash dup = (RubyHash)tmph.callMethod(ctx, "dup");
                        tmp = ((RubyArray)tmp).reverse();
                        ((RubyArray)tmp).append((IRubyObject)obj);
                        RubyEnumerable.callEach((Ruby)runtime, (ThreadContext)ctx, (IRubyObject)tmp, (BlockCallback)new BlockCallback(){

                            public IRubyObject call(ThreadContext _ctx, IRubyObject[] largs, Block blk) {
                                IRubyObject entry = largs[0];
                                IRubyObject tmp = null;
                                tmp = TypeConverter.convertToTypeWithCheck((IRubyObject)entry, (RubyClass)runtime.getHash(), (String)"to_hash");
                                if (!tmp.isNil()) {
                                    dup.callMethod(_ctx, "update", tmp);
                                }
                                return runtime.getNil();
                            }
                        });
                        obj = dup;
                        skip_aset = true;
                    }
                }
            } else if (cDefaultKey.isInstance(k)) {
                obj.callMethod(ctx, "default=", v);
                skip_aset = true;
            }
            if (skip_aset) continue;
            if (v instanceof PossibleLinkNode) {
                ((PossibleLinkNode)v).addLink(new HashStorageLink((IRubyObject)obj, k, v));
            }
            obj.fastASet(k, v);
        }
        ref[0] = obj;
        return transferred;
    }

    public static boolean orgHandler(IRubyObject self, Node n, IRubyObject[] ref, YAMLExtra x) {
        Ruby runtime = self.getRuntime();
        String type_id = n.type_id;
        boolean transferred = false;
        if (type_id != null && type_id.startsWith("tag:yaml.org,2002:")) {
            type_id = type_id.substring(18);
        }
        try {
            switch (n.kind) {
                case Str: {
                    transferred = DefaultResolver.handleScalar(runtime, n, type_id, ref, x);
                    break;
                }
                case Seq: {
                    transferred = DefaultResolver.handleSeq(runtime, n, type_id, ref);
                    break;
                }
                case Map: {
                    transferred = DefaultResolver.handleMap(runtime, n, type_id, ref, x);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return transferred;
    }

    @JRubyMethod
    public static IRubyObject node_import(IRubyObject self, IRubyObject node) {
        Node n = (Node)node.dataGetStructChecked();
        IRubyObject[] _obj = new IRubyObject[]{null};
        if (!DefaultResolver.orgHandler(self, n, _obj, ((org.yecht.ruby.Node)node).x)) {
            _obj[0] = self.callMethod(self.getRuntime().getCurrentContext(), "transfer", new IRubyObject[]{self.getRuntime().newString(n.type_id), _obj[0]});
        }
        return _obj[0];
    }

    @JRubyMethod
    public static IRubyObject detect_implicit(IRubyObject self, IRubyObject val) {
        IRubyObject tmp = TypeConverter.convertToTypeWithCheck((IRubyObject)val, (RubyClass)self.getRuntime().getString(), (String)"to_str");
        if (!tmp.isNil()) {
            ByteList bl = ((RubyString)tmp).getByteList();
            String type_id = ImplicitScanner2.matchImplicit(Pointer.create(bl.bytes, bl.begin), bl.realSize);
            return self.getRuntime().newString(type_id);
        }
        return RubyString.newEmptyString((Ruby)self.getRuntime());
    }

    static {
        scalarTypes.put("null", new ObjectCreator(){

            public IRubyObject create(Ruby runtime, Node n, Data.Str ds) {
                return runtime.getNil();
            }
        });
        scalarTypes.put("binary", new ObjectCreator(){

            public IRubyObject create(Ruby runtime, Node n, Data.Str ds) {
                ThreadContext ctx = runtime.getCurrentContext();
                RubyString obj = RubyString.newStringShared((Ruby)runtime, (byte[])ds.ptr.buffer, (int)ds.ptr.start, (int)ds.len);
                obj.callMethod(ctx, "tr!", new IRubyObject[]{runtime.newString("\n\t "), runtime.newString("")});
                IRubyObject arr = obj.callMethod(ctx, "unpack", (IRubyObject)runtime.newString("m"));
                return ((RubyArray)arr).shift(ctx);
            }
        });
        scalarTypes.put("bool#yes", new ObjectCreator(){

            public IRubyObject create(Ruby runtime, Node n, Data.Str ds) {
                return runtime.getTrue();
            }
        });
        scalarTypes.put("bool#no", new ObjectCreator(){

            public IRubyObject create(Ruby runtime, Node n, Data.Str ds) {
                return runtime.getFalse();
            }
        });
        scalarTypes.put("int#hex", new ObjectCreator(){

            public IRubyObject create(Ruby runtime, Node n, Data.Str ds) {
                n.strBlowAwayCommas();
                return RubyNumeric.str2inum((Ruby)runtime, (RubyString)RubyString.newStringShared((Ruby)runtime, (byte[])ds.ptr.buffer, (int)ds.ptr.start, (int)ds.len), (int)16, (boolean)true);
            }
        });
        scalarTypes.put("int#oct", new ObjectCreator(){

            public IRubyObject create(Ruby runtime, Node n, Data.Str ds) {
                n.strBlowAwayCommas();
                return RubyNumeric.str2inum((Ruby)runtime, (RubyString)RubyString.newStringShared((Ruby)runtime, (byte[])ds.ptr.buffer, (int)ds.ptr.start, (int)ds.len), (int)8, (boolean)true);
            }
        });
        scalarTypes.put("int#base60", new ObjectCreator(){

            public IRubyObject create(Ruby runtime, Node n, Data.Str ds) throws UnsupportedEncodingException {
                long sixty = 1L;
                long total = 0L;
                n.strBlowAwayCommas();
                int ptr = ds.ptr.start;
                int end = ptr + ds.len;
                while (end > ptr) {
                    int colon;
                    long bnum = 0L;
                    for (colon = end - 1; colon >= ptr && ds.ptr.buffer[colon] != 58; --colon) {
                    }
                    bnum = Integer.parseInt(new String(ds.ptr.buffer, colon + 1, end - (colon + 1), "ISO-8859-1"));
                    total += bnum * sixty;
                    sixty *= 60L;
                    end = colon;
                }
                return runtime.newFixnum(total);
            }
        });
        scalarTypes.put("float#base60", new ObjectCreator(){

            public IRubyObject create(Ruby runtime, Node n, Data.Str ds) throws UnsupportedEncodingException {
                long sixty = 1L;
                double total = 0.0;
                n.strBlowAwayCommas();
                int ptr = ds.ptr.start;
                int end = ptr + ds.len;
                while (end > ptr) {
                    int colon;
                    double bnum = 0.0;
                    for (colon = end - 1; colon >= ptr && ds.ptr.buffer[colon] != 58; --colon) {
                    }
                    bnum = Double.parseDouble(new String(ds.ptr.buffer, colon + 1, end - (colon + 1), "ISO-8859-1"));
                    total += bnum * (double)sixty;
                    sixty *= 60L;
                    end = colon;
                }
                return runtime.newFloat(total);
            }
        });
        scalarTypes.put("float#nan", new ObjectCreator(){

            public IRubyObject create(Ruby runtime, Node n, Data.Str ds) {
                return runtime.newFloat(Double.NaN);
            }
        });
        scalarTypes.put("float#inf", new ObjectCreator(){

            public IRubyObject create(Ruby runtime, Node n, Data.Str ds) {
                return runtime.newFloat(Double.POSITIVE_INFINITY);
            }
        });
        scalarTypes.put("float#neginf", new ObjectCreator(){

            public IRubyObject create(Ruby runtime, Node n, Data.Str ds) {
                return runtime.newFloat(Double.NEGATIVE_INFINITY);
            }
        });
        scalarTypes.put("timestamp#iso8601", new ObjectCreator(){

            public IRubyObject create(Ruby runtime, Node n, Data.Str ds) {
                return DefaultResolver.makeTime(runtime, ds.ptr, ds.len);
            }
        });
        scalarTypes.put("timestamp#spaced", new ObjectCreator(){

            public IRubyObject create(Ruby runtime, Node n, Data.Str ds) {
                return DefaultResolver.makeTime(runtime, ds.ptr, ds.len);
            }
        });
        scalarTypes.put("timestamp#ymd", new ObjectCreator(){

            public IRubyObject create(Ruby runtime, Node n, Data.Str ds) throws UnsupportedEncodingException {
                RubyFixnum year = runtime.newFixnum(Integer.parseInt(new String(ds.ptr.buffer, 0, 4, "ISO-8859-1")));
                RubyFixnum mon = runtime.newFixnum(Integer.parseInt(new String(ds.ptr.buffer, 5, 2, "ISO-8859-1")));
                RubyFixnum day = runtime.newFixnum(Integer.parseInt(new String(ds.ptr.buffer, 8, 2, "ISO-8859-1")));
                RubyKernel.require((IRubyObject)runtime.getTopSelf(), (IRubyObject)runtime.newString("date"), (Block)Block.NULL_BLOCK);
                return runtime.getClass("Date").callMethod(runtime.getCurrentContext(), "new", new IRubyObject[]{year, mon, day});
            }
        });
        scalarTypes.put("str", new ObjectCreator(){

            public IRubyObject create(Ruby runtime, Node n, Data.Str ds) {
                return RubyString.newStringShared((Ruby)runtime, (byte[])ds.ptr.buffer, (int)ds.ptr.start, (int)ds.len);
            }
        });
    }

    private static interface ObjectCreator {
        public IRubyObject create(Ruby var1, Node var2, Data.Str var3) throws UnsupportedEncodingException;
    }
}

