/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ComponentInvocation;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;

public class GlobalVariableReference
extends VariableReference
implements ComponentInvocation {
    int bindingSlot = -1;

    public GlobalVariableReference() {
    }

    public GlobalVariableReference(GlobalVariable var) {
        super(var);
    }

    public Expression copy() {
        if (this.binding == null) {
            throw new UnsupportedOperationException("Cannot copy a variable reference whose binding is unknown");
        }
        GlobalVariableReference ref = new GlobalVariableReference();
        ref.copyFrom(this);
        return ref;
    }

    public void setBindingSlot(int slot) {
        this.bindingSlot = slot;
    }

    public int getBindingSlot() {
        return this.bindingSlot;
    }

    public SymbolicName getSymbolicName() {
        return new SymbolicName(206, this.binding.getVariableQName());
    }

    public Component getTarget() {
        return ((GlobalVariable)this.binding).getDeclaringComponent();
    }

    public Sequence evaluateVariable(XPathContext c) throws XPathException {
        if (this.bindingSlot >= 0 && c.getCurrentComponent() != null) {
            Component target = c.getTargetComponent(this.bindingSlot);
            if (target.getVisibility() == Visibility.ABSTRACT) {
                XPathException err = new XPathException("Cannot evaluate an abstract variable", "XTSE3080");
                err.setLocator(this);
                throw err;
            }
            GlobalVariable p = (GlobalVariable)target.getProcedure();
            return p.evaluateVariable(c, target);
        }
        GlobalVariable b = (GlobalVariable)this.binding;
        return b.evaluateVariable(c, b.getDeclaringComponent());
    }
}

