/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.expr.AndExpression;
import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.CastToList;
import net.sf.saxon.expr.CastToUnion;
import net.sf.saxon.expr.CastableExpression;
import net.sf.saxon.expr.CastableToList;
import net.sf.saxon.expr.CastableToUnion;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.IdentityComparison;
import net.sf.saxon.expr.InstanceOfExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.OrExpression;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.QuantifiedExpression;
import net.sf.saxon.expr.RangeExpression;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.TreatExpression;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.VennExpression;
import net.sf.saxon.expr.flwor.Clause;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.instruct.ForEach;
import net.sf.saxon.expr.instruct.LocationMap;
import net.sf.saxon.expr.instruct.SavedNamespaceContext;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.CodeInjector;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.parser.Tokenizer;
import net.sf.saxon.functions.CurrentGroup;
import net.sf.saxon.functions.CurrentGroupingKey;
import net.sf.saxon.functions.RegexGroup;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.functions.VendorFunctionLibrary;
import net.sf.saxon.lib.NamespaceConstant;
import net.sf.saxon.om.AxisInfo;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyChildNodeTest;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.LocalNameTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NamespaceTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.query.Annotation;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.UnionType;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.z.IntArraySet;
import net.sf.saxon.z.IntPredicate;
import net.sf.saxon.z.IntSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathParser {
    protected Tokenizer t;
    protected StaticContext env;
    protected Stack<LocalBinding> rangeVariables = new Stack();
    protected Container defaultContainer;
    protected IntPredicate charChecker;
    protected boolean allowXPath30Syntax = false;
    protected boolean scanOnly = false;
    protected CodeInjector codeInjector = null;
    protected int language = 0;
    public static final int XPATH = 0;
    public static final int XSLT_PATTERN = 1;
    public static final int SEQUENCE_TYPE = 2;
    public static final int XQUERY = 3;
    protected DecimalValue languageVersion = DecimalValue.TWO;
    protected int catchDepth = 0;

    public void setCodeInjector(CodeInjector injector) {
        this.codeInjector = injector;
    }

    public CodeInjector getCodeInjector() {
        return this.codeInjector;
    }

    public Tokenizer getTokenizer() {
        return this.t;
    }

    public StaticContext getStaticContext() {
        return this.env;
    }

    public void setDefaultContainer(Container container) {
        this.defaultContainer = container;
    }

    public Container getDefaultContainer() {
        return this.defaultContainer;
    }

    public void setCatchDepth(int depth) {
        this.catchDepth = depth;
    }

    public void nextToken() throws XPathException {
        block3: {
            try {
                this.t.next();
                if (this.t.currentToken != 201 && this.t.currentToken != 35 || !this.t.currentTokenValue.startsWith("{")) break block3;
                if (this.allowXPath30Syntax) {
                    this.t.currentTokenValue = this.normalizeEQName(this.t.currentTokenValue);
                    break block3;
                }
                throw new XPathException("The expanded QName syntax Q{uri}local is not allowed in this version of XPath/XQuery");
            }
            catch (XPathException e) {
                this.grumble(e.getMessage());
            }
        }
    }

    public void expect(int token) throws XPathException {
        if (this.t.currentToken != token) {
            this.grumble("expected \"" + Token.tokens[token] + "\", found " + this.currentTokenDisplay());
        }
    }

    public void grumble(String message) throws XPathException {
        this.grumble(message, this.language == 1 ? "XTSE0340" : "XPST0003");
    }

    public void grumble(String message, String errorCode) throws XPathException {
        this.grumble(message, new StructuredQName("", "http://www.w3.org/2005/xqt-errors", errorCode), -1);
    }

    public void grumble(String message, String errorCode, int offset) throws XPathException {
        this.grumble(message, new StructuredQName("", "http://www.w3.org/2005/xqt-errors", errorCode), offset);
    }

    protected void grumble(String message, StructuredQName errorCode, int offset) throws XPathException {
        int column;
        int line;
        if (errorCode == null) {
            errorCode = new StructuredQName("err", "http://www.w3.org/2005/xqt-errors", "XPST0003");
        }
        String s = this.t.recentText(-1);
        if (offset == -1) {
            line = this.t.getLineNumber();
            column = this.t.getColumnNumber();
        } else {
            line = this.t.getLineNumber(offset);
            column = this.t.getColumnNumber(offset);
        }
        String lineInfo = line == 1 ? "" : "on line " + line + ' ';
        String columnInfo = "at char " + column + ' ';
        String prefix = this.getLanguage() + " syntax error " + columnInfo + lineInfo + (s.startsWith("...") ? "near" : "in") + ' ' + Err.wrap(s) + ":\n    ";
        XPathException err = new XPathException(message);
        err.setAdditionalLocationText(prefix);
        err.setIsStaticError(true);
        err.setErrorCodeQName(errorCode);
        throw err;
    }

    protected void warning(String message) throws XPathException {
        String s = this.t.recentText(-1);
        String prefix = (message.startsWith("...") ? "near" : "in") + ' ' + Err.wrap(s) + ":\n    ";
        this.env.issueWarning(prefix + message, null);
    }

    public void setLanguage(int language, DecimalValue version) {
        switch (language) {
            case 0: 
            case 1: 
            case 2: {
                if (DecimalValue.TWO.equals(version) || DecimalValue.THREE.equals(version)) break;
                throw new IllegalArgumentException("Unsupported language version " + version);
            }
            case 3: {
                if (DecimalValue.ONE.equals(version) || DecimalValue.THREE.equals(version)) break;
                throw new IllegalArgumentException("Unsupported language version " + version);
            }
            default: {
                throw new IllegalArgumentException("Unknown language " + language);
            }
        }
        this.language = language;
        this.languageVersion = version;
        this.allowXPath30Syntax = DecimalValue.THREE.equals(this.languageVersion);
    }

    protected String getLanguage() {
        switch (this.language) {
            case 0: {
                return "XPath";
            }
            case 1: {
                return "XSLT Pattern";
            }
            case 2: {
                return "SequenceType";
            }
            case 3: {
                return "XQuery";
            }
        }
        return "XPath";
    }

    protected String currentTokenDisplay() {
        if (this.t.currentToken == 201) {
            return "name \"" + this.t.currentTokenValue + '\"';
        }
        if (this.t.currentToken == -1) {
            return "(unknown token)";
        }
        return '\"' + Token.tokens[this.t.currentToken] + '\"';
    }

    public Expression parse(String expression, int start, int terminator, int lineNumber, StaticContext env) throws XPathException {
        this.env = env;
        this.charChecker = env.getConfiguration().getValidCharacterChecker();
        this.t = new Tokenizer();
        this.t.languageLevel = env.getXPathLanguageLevel();
        this.customizeTokenizer(this.t);
        try {
            this.t.tokenize(expression, start, -1, lineNumber);
        }
        catch (XPathException err) {
            this.grumble(err.getMessage());
        }
        Expression exp = this.parseExpression();
        if (this.t.currentToken != terminator) {
            if (this.t.currentToken == 0 && terminator == 215) {
                this.grumble("Missing curly brace after expression in attribute value template", "XTSE0350");
            } else {
                this.grumble("Unexpected token " + this.currentTokenDisplay() + " beyond end of expression");
            }
        }
        return exp;
    }

    protected void customizeTokenizer(Tokenizer t) {
    }

    public SequenceType parseSequenceType(String input, StaticContext env) throws XPathException {
        this.env = env;
        this.language = 2;
        this.t = new Tokenizer();
        this.t.languageLevel = env.getXPathLanguageLevel();
        try {
            this.t.tokenize(input, 0, -1, 1);
        }
        catch (XPathException err) {
            this.grumble(err.getMessage());
        }
        SequenceType req = this.parseSequenceType();
        if (this.t.currentToken != 0) {
            this.grumble("Unexpected token " + this.currentTokenDisplay() + " beyond end of SequenceType");
        }
        return req;
    }

    public Expression parseExpression() throws XPathException {
        Expression exp = this.parseExprSingle();
        ArrayList<Expression> list = null;
        while (this.t.currentToken == 7) {
            if (list == null) {
                list = new ArrayList<Expression>(10);
                list.add(exp);
            }
            this.nextToken();
            Expression next = this.parseExprSingle();
            this.setLocation(next);
            list.add(next);
        }
        if (list != null) {
            exp = Block.makeBlock(list, this.getDefaultContainer());
            this.setLocation(exp);
        }
        return exp;
    }

    public Expression parseExprSingle() throws XPathException {
        switch (this.t.currentToken) {
            case 73: 
            case 74: 
            case 211: 
            case 216: {
                return this.parseFLWORExpression();
            }
            case 32: 
            case 33: {
                return this.parseQuantifiedExpression();
            }
            case 37: {
                return this.parseIfExpression();
            }
            case 66: {
                return this.parseSwitchExpression();
            }
            case 65: {
                return this.parseTypeswitchExpression();
            }
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                return this.parseValidateExpression();
            }
            case 218: {
                return this.parseExtensionExpression();
            }
            case 60: {
                if (!this.t.currentTokenValue.equals("try")) break;
                return this.parseTryCatchExpression();
            }
        }
        return this.parseBinaryExpression(this.parseUnaryExpression(), 4);
    }

    public Expression parseBinaryExpression(Expression lhs, int minPrecedence) throws XPathException {
        block4: while (this.getCurrentOperatorPrecedence() >= minPrecedence) {
            int operator = this.t.currentToken;
            int prec = this.getCurrentOperatorPrecedence();
            switch (operator) {
                case 45: 
                case 47: {
                    this.nextToken();
                    SequenceType seq = this.parseSequenceType();
                    lhs = this.makeSequenceTypeExpression(lhs, operator, seq);
                    this.setLocation(lhs);
                    if (this.getCurrentOperatorPrecedence() < prec) continue block4;
                    this.grumble("Left operand of '" + Token.tokens[this.t.currentToken] + "' needs parentheses");
                    continue block4;
                }
                case 46: 
                case 57: {
                    boolean allowEmpty;
                    this.nextToken();
                    this.expect(201);
                    SimpleType at = this.getSimpleType(this.t.currentTokenValue);
                    if (at == BuiltInAtomicType.ANY_ATOMIC) {
                        this.grumble("No value is castable to xs:anyAtomicType", "XPST0080");
                    }
                    if (at == BuiltInAtomicType.NOTATION) {
                        this.grumble("No value is castable to xs:NOTATION", "XPST0080");
                    }
                    this.nextToken();
                    boolean bl = allowEmpty = this.t.currentToken == 213;
                    if (allowEmpty) {
                        this.nextToken();
                    }
                    lhs = this.makeSingleTypeExpression(lhs, operator, at, allowEmpty);
                    this.setLocation(lhs);
                    if (this.getCurrentOperatorPrecedence() < prec) continue block4;
                    this.grumble("Left operand of '" + Token.tokens[this.t.currentToken] + "' needs parentheses");
                    continue block4;
                }
            }
            this.nextToken();
            Expression rhs = this.parseUnaryExpression();
            while (this.getCurrentOperatorPrecedence() > prec) {
                rhs = this.parseBinaryExpression(rhs, this.getCurrentOperatorPrecedence());
            }
            if (this.getCurrentOperatorPrecedence() == prec && !this.allowMultipleOperators()) {
                this.grumble("Left operand of '" + Token.tokens[this.t.currentToken] + "' needs parentheses");
            }
            lhs = this.makeBinaryExpression(lhs, operator, rhs);
            this.setLocation(lhs);
        }
        return lhs;
    }

    private boolean allowMultipleOperators() {
        switch (this.t.currentToken) {
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 22: 
            case 29: 
            case 38: 
            case 39: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                return false;
            }
        }
        return true;
    }

    private int getCurrentOperatorPrecedence() {
        switch (this.t.currentToken) {
            case 9: {
                return 4;
            }
            case 10: {
                return 5;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 22: 
            case 38: 
            case 39: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                return 6;
            }
            case 30: {
                return 7;
            }
            case 29: {
                return 8;
            }
            case 15: 
            case 16: {
                return 9;
            }
            case 17: 
            case 18: 
            case 19: 
            case 56: {
                return 10;
            }
            case 1: {
                return 11;
            }
            case 23: 
            case 24: {
                return 12;
            }
            case 45: {
                return 13;
            }
            case 47: {
                return 14;
            }
            case 57: {
                return 15;
            }
            case 46: {
                return 16;
            }
        }
        return -1;
    }

    private Expression makeBinaryExpression(Expression lhs, int operator, Expression rhs) throws XPathException {
        switch (operator) {
            case 9: {
                return new OrExpression(lhs, rhs);
            }
            case 10: {
                return new AndExpression(lhs, rhs);
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                return new ValueComparison(lhs, operator, rhs);
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 22: {
                return new GeneralComparison(lhs, operator, rhs);
            }
            case 20: 
            case 38: 
            case 39: {
                return new IdentityComparison(lhs, operator, rhs);
            }
            case 29: {
                return new RangeExpression(lhs, operator, rhs);
            }
            case 30: {
                if (!this.env.getXPathLanguageLevel().equals(DecimalValue.THREE)) {
                    this.grumble("Concatenation operator ('||') requires XPath 3.0 to be enabled");
                }
                FunctionCall cc = SystemFunctionCall.makeSystemFunction("concat", new Expression[]{lhs, rhs});
                assert (cc != null);
                return cc;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 56: {
                return new ArithmeticExpression(lhs, operator, rhs);
            }
            case 1: 
            case 23: 
            case 24: {
                return new VennExpression(lhs, operator, rhs);
            }
        }
        throw new IllegalArgumentException();
    }

    private Expression makeSequenceTypeExpression(Expression lhs, int operator, SequenceType type) {
        switch (operator) {
            case 45: {
                return new InstanceOfExpression(lhs, type);
            }
            case 47: {
                return TreatExpression.make(lhs, type);
            }
        }
        throw new IllegalArgumentException();
    }

    private Expression makeSingleTypeExpression(Expression lhs, int operator, SimpleType type, boolean allowEmpty) throws XPathException {
        if (type instanceof AtomicType && type != ErrorType.getInstance()) {
            switch (operator) {
                case 57: {
                    CastableExpression castable = new CastableExpression(lhs, (AtomicType)type, allowEmpty);
                    if (lhs instanceof StringLiteral) {
                        castable.setOperandIsStringLiteral(true);
                    }
                    if (type.isNamespaceSensitive()) {
                        castable.setNamespaceResolver(new SavedNamespaceContext(this.env.getNamespaceResolver()));
                    }
                    return castable;
                }
                case 46: {
                    CastExpression cast = new CastExpression(lhs, (AtomicType)type, allowEmpty);
                    if (lhs instanceof StringLiteral) {
                        cast.setOperandIsStringLiteral(true);
                    }
                    if (type.isNamespaceSensitive()) {
                        cast.setNamespaceResolver(new SavedNamespaceContext(this.env.getNamespaceResolver()));
                    }
                    return cast;
                }
            }
            throw new IllegalArgumentException();
        }
        if (this.env.getXPathLanguageLevel().equals(DecimalValue.THREE)) {
            switch (operator) {
                case 57: {
                    if (type.isUnionType()) {
                        return new CastableToUnion(lhs, (UnionType)type, allowEmpty);
                    }
                    if (!type.isListType()) break;
                    return new CastableToList(lhs, (ListType)type, allowEmpty);
                }
                case 46: {
                    if (type.isUnionType()) {
                        return new CastToUnion(lhs, (UnionType)type, allowEmpty);
                    }
                    if (!type.isListType()) break;
                    return new CastToList(lhs, (ListType)type, allowEmpty);
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            if (type == AnySimpleType.getInstance()) {
                throw new XPathException("Cannot cast to xs:anySimpleType", "XPST0051");
            }
            throw new XPathException("Cannot cast to " + type.getDescription(), "XPST0051");
        }
        throw new XPathException("Casting to list or union types requires XPath 3.0 to be enabled", "XPST0051");
    }

    protected Expression parseTypeswitchExpression() throws XPathException {
        this.grumble("typeswitch is not allowed in XPath");
        return new ErrorExpression();
    }

    protected Expression parseSwitchExpression() throws XPathException {
        this.grumble("switch is not allowed in XPath");
        return new ErrorExpression();
    }

    protected Expression parseValidateExpression() throws XPathException {
        this.grumble("validate{} expressions are not allowed in XPath");
        return new ErrorExpression();
    }

    protected Expression parseExtensionExpression() throws XPathException {
        this.grumble("extension expressions (#...#) are not allowed in XPath");
        return new ErrorExpression();
    }

    protected Expression parseTryCatchExpression() throws XPathException {
        this.grumble("try/catch expressions are not allowed in XPath");
        return new ErrorExpression();
    }

    protected Expression parseFLWORExpression() throws XPathException {
        int offset;
        if (this.t.currentToken == 216 && !this.allowXPath30Syntax) {
            this.grumble("'let' is not permitted in XPath 2.0");
        }
        if (this.t.currentToken == 74 || this.t.currentToken == 73) {
            this.grumble("sliding/tumbling windows can only be used in XQuery");
        }
        int clauses = 0;
        int operator = this.t.currentToken;
        Assignation first = null;
        Assignation previous = null;
        do {
            Assignation v;
            offset = this.t.currentTokenStartOffset;
            this.nextToken();
            this.expect(21);
            this.nextToken();
            this.expect(201);
            String var = this.t.currentTokenValue;
            if (operator == 211) {
                v = new ForExpression();
                v.setRequiredType(SequenceType.SINGLE_ITEM);
            } else {
                v = new LetExpression();
                v.setRequiredType(SequenceType.ANY_SEQUENCE);
            }
            ++clauses;
            this.setLocation(v, offset);
            v.setVariableQName(this.makeStructuredQName(var, ""));
            this.nextToken();
            this.expect(operator == 216 ? 58 : 31);
            this.nextToken();
            v.setSequence(this.parseExprSingle());
            this.declareRangeVariable(v);
            if (previous == null) {
                first = v;
            } else {
                previous.setAction(v);
            }
            previous = v;
        } while (this.t.currentToken == 7);
        this.expect(25);
        this.nextToken();
        previous.setAction(this.parseExprSingle());
        for (int i = 0; i < clauses; ++i) {
            this.undeclareRangeVariable();
        }
        return this.makeTracer(offset, first, 2012, first.getVariableQName());
    }

    private Expression parseQuantifiedExpression() throws XPathException {
        int clauses = 0;
        int operator = this.t.currentToken;
        QuantifiedExpression first = null;
        Assignation previous = null;
        int initialOffset = this.t.currentTokenStartOffset;
        do {
            int offset = this.t.currentTokenStartOffset;
            this.nextToken();
            this.expect(21);
            this.nextToken();
            this.expect(201);
            String var = this.t.currentTokenValue;
            ++clauses;
            QuantifiedExpression v = new QuantifiedExpression();
            v.setRequiredType(SequenceType.SINGLE_ITEM);
            v.setOperator(operator);
            this.setLocation(v, offset);
            v.setVariableQName(this.makeStructuredQName(var, ""));
            this.nextToken();
            if (this.t.currentToken == 71 && this.language == 3) {
                this.nextToken();
                SequenceType type = this.parseSequenceType();
                if (type.getCardinality() != 16384) {
                    this.warning("Occurrence indicator on singleton range variable has no effect");
                    type = SequenceType.makeSequenceType(type.getPrimaryType(), 16384);
                }
                v.setRequiredType(type);
            }
            this.expect(31);
            this.nextToken();
            v.setSequence(this.parseExprSingle());
            this.declareRangeVariable(v);
            if (previous != null) {
                previous.setAction(v);
            } else {
                first = v;
            }
            previous = v;
        } while (this.t.currentToken == 7);
        this.expect(34);
        this.nextToken();
        previous.setAction(this.parseExprSingle());
        for (int i = 0; i < clauses; ++i) {
            this.undeclareRangeVariable();
        }
        return this.makeTracer(initialOffset, first, 2012, first.getVariableQName());
    }

    private Expression parseIfExpression() throws XPathException {
        int ifoffset = this.t.currentTokenStartOffset;
        this.nextToken();
        Expression condition = this.parseExpression();
        this.expect(204);
        this.nextToken();
        int thenoffset = this.t.currentTokenStartOffset;
        this.expect(26);
        this.nextToken();
        Expression thenExp = this.makeTracer(thenoffset, this.parseExprSingle(), 2016, null);
        int elseoffset = this.t.currentTokenStartOffset;
        this.expect(27);
        this.nextToken();
        Expression elseExp = this.makeTracer(elseoffset, this.parseExprSingle(), 2017, null);
        Expression ifExp = Choose.makeConditional(condition, thenExp, elseExp);
        this.setLocation(ifExp, ifoffset);
        return this.makeTracer(ifoffset, ifExp, 2015, null);
    }

    private ItemType getPlainType(String qname) throws XPathException {
        String local;
        String uri;
        if (this.scanOnly) {
            return BuiltInAtomicType.STRING;
        }
        if (qname.startsWith("{")) {
            StructuredQName sq = StructuredQName.fromClarkName(qname);
            uri = sq.getURI();
            local = sq.getLocalPart();
        } else {
            try {
                String[] parts = NameChecker.getQNameParts(qname);
                if (parts[0].length() == 0) {
                    uri = this.env.getDefaultElementNamespace();
                } else {
                    try {
                        uri = this.env.getURIForPrefix(parts[0]);
                    }
                    catch (XPathException err) {
                        this.grumble(err.getMessage(), err.getErrorCodeQName(), -1);
                        uri = "";
                    }
                }
                local = parts[1];
            }
            catch (QNameException err) {
                this.grumble(err.getMessage());
                return BuiltInAtomicType.ANY_ATOMIC;
            }
        }
        boolean builtInNamespace = uri.equals("http://www.w3.org/2001/XMLSchema");
        if (builtInNamespace) {
            ItemType t = Type.getBuiltInItemType(uri, local);
            if (t == null) {
                this.grumble("Unknown atomic type " + qname, "XPST0051");
            }
            if (t instanceof BuiltInAtomicType) {
                if (!this.env.isAllowedBuiltInType((BuiltInAtomicType)t)) {
                    this.grumble("The type " + qname + " is not recognized by a Basic XSLT Processor. ", "XPST0080");
                }
                return t;
            }
            if (t.isPlainType()) {
                return t;
            }
            this.grumble("The type " + qname + " is not atomic", "XPST0051");
        } else {
            SchemaType st;
            if (uri.equals("http://saxon.sf.net/java-type")) {
                Class theClass;
                try {
                    String className = JavaExternalObjectType.localNameToClassName(local);
                    theClass = this.env.getConfiguration().getClass(className, false, null);
                }
                catch (XPathException err) {
                    this.grumble("Unknown Java class " + local, "XPST0051");
                    return JavaExternalObjectType.EXTERNAL_OBJECT_TYPE;
                }
                return new JavaExternalObjectType(theClass, this.env.getConfiguration());
            }
            if (uri.equals("http://saxon.sf.net/clitype")) {
                return (AtomicType)((Object)Configuration.getPlatform().getExternalObjectType(this.env.getConfiguration(), uri, local));
            }
            int fp = this.env.getNamePool().getFingerprint(uri, local);
            if (fp == -1) {
                this.grumble("Unknown type " + qname, "XPST0051");
            }
            if ((st = this.env.getConfiguration().getSchemaType(fp)) == null) {
                this.grumble("Unknown atomic type " + qname, "XPST0051");
            } else {
                if (st.isAtomicType()) {
                    if (!this.env.isImportedSchema(uri)) {
                        this.grumble("Atomic type " + qname + " exists, but its schema definition has not been imported", "XPST0051");
                    }
                    return (AtomicType)st;
                }
                if (st instanceof ItemType && ((ItemType)((Object)st)).isPlainType() && DecimalValue.THREE.equals(this.env.getXPathLanguageLevel())) {
                    if (!this.env.isImportedSchema(uri)) {
                        this.grumble("Type " + qname + " exists, but its schema definition has not been imported", "XPST0051");
                    }
                    return (ItemType)((Object)st);
                }
                if (st.isComplexType()) {
                    this.grumble("Type (" + qname + ") is a complex type", "XPST0051");
                    return BuiltInAtomicType.ANY_ATOMIC;
                }
                if (((SimpleType)st).isListType()) {
                    this.grumble("Type (" + qname + ") is a list type", "XPST0051");
                    return BuiltInAtomicType.ANY_ATOMIC;
                }
                if (DecimalValue.THREE.equals(this.env.getXPathLanguageLevel())) {
                    this.grumble("Type (" + qname + ") is a union type that cannot be used as an item type", "XPST0051");
                    return BuiltInAtomicType.ANY_ATOMIC;
                }
                this.grumble("The union type (" + qname + ") cannot be used as an item type unless XPath 3.0 is enabled", "XPST0051");
                return BuiltInAtomicType.ANY_ATOMIC;
            }
        }
        this.grumble("Unknown atomic type " + qname, "XPST0051");
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    private SimpleType getSimpleType(String qname) throws XPathException {
        SchemaType st;
        String local;
        String uri;
        if (this.scanOnly) {
            return BuiltInAtomicType.STRING;
        }
        if (qname.startsWith("{")) {
            StructuredQName sq = StructuredQName.fromClarkName(qname);
            uri = sq.getURI();
            local = sq.getLocalPart();
        } else {
            try {
                String[] parts = NameChecker.getQNameParts(qname);
                if (parts[0].length() == 0) {
                    uri = this.env.getDefaultElementNamespace();
                } else {
                    try {
                        uri = this.env.getURIForPrefix(parts[0]);
                    }
                    catch (XPathException err) {
                        this.grumble(err.getMessage(), err.getErrorCodeQName(), -1);
                        uri = "";
                    }
                }
                local = parts[1];
            }
            catch (QNameException err) {
                this.grumble(err.getMessage());
                return BuiltInAtomicType.ANY_ATOMIC;
            }
        }
        boolean builtInNamespace = uri.equals("http://www.w3.org/2001/XMLSchema");
        if (builtInNamespace) {
            SimpleType t = Type.getBuiltInSimpleType(uri, local);
            if (t == null) {
                this.grumble("Unknown simple type " + qname, "XPST0051");
            }
            if (t instanceof BuiltInAtomicType && !this.env.isAllowedBuiltInType((BuiltInAtomicType)t)) {
                this.grumble("The type " + qname + " is not recognized by a Basic XSLT Processor. ", "XPST0080");
            }
            return t;
        }
        if (uri.equals("http://saxon.sf.net/clitype")) {
            return (AtomicType)((Object)Configuration.getPlatform().getExternalObjectType(this.env.getConfiguration(), uri, local));
        }
        int fp = this.env.getNamePool().getFingerprint(uri, local);
        if (fp == -1) {
            this.grumble("Unknown type " + qname, "XPST0051");
        }
        if ((st = this.env.getConfiguration().getSchemaType(fp)) == null) {
            this.grumble("Unknown simple type " + qname, "XPST0051");
            return BuiltInAtomicType.ANY_ATOMIC;
        }
        if (DecimalValue.THREE.equals(this.env.getXPathLanguageLevel())) {
            if (!this.env.isImportedSchema(uri)) {
                this.grumble("Simple type " + qname + " exists, but its target namespace has not been imported in the static context");
            }
            return (SimpleType)st;
        }
        if (st.isAtomicType()) {
            if (!this.env.isImportedSchema(uri)) {
                this.grumble("Atomic type " + qname + " exists, but its target namespace has not been imported in the static context");
            }
            return (AtomicType)st;
        }
        if (st.isComplexType()) {
            this.grumble("Cannot cast to a complex type (" + qname + ")", "XPST0051");
            return BuiltInAtomicType.ANY_ATOMIC;
        }
        if (((SimpleType)st).isListType()) {
            this.grumble("Casting to a list type (" + qname + ") requires XPath 3.0", "XPST0051");
            return BuiltInAtomicType.ANY_ATOMIC;
        }
        this.grumble("casting to a union type (" + qname + ") requires XPath 3.0", "XPST0051");
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    public SequenceType parseSequenceType() throws XPathException {
        int occurrenceFlag;
        boolean disallowIndicator = this.t.currentTokenValue.equals("empty-sequence");
        ItemType primaryType = this.parseItemType();
        if (disallowIndicator) {
            return SequenceType.makeSequenceType(primaryType, 8192);
        }
        switch (this.t.currentToken) {
            case 17: 
            case 207: {
                occurrenceFlag = 57344;
                this.t.currentToken = 204;
                this.nextToken();
                break;
            }
            case 15: {
                occurrenceFlag = 49152;
                this.t.currentToken = 204;
                this.nextToken();
                break;
            }
            case 213: {
                occurrenceFlag = 24576;
                this.t.currentToken = 204;
                this.nextToken();
                break;
            }
            default: {
                occurrenceFlag = 16384;
            }
        }
        return SequenceType.makeSequenceType(primaryType, occurrenceFlag);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemType parseItemType() throws XPathException {
        if (this.t.currentToken == 5) {
            return this.parseParenthesizedItemType();
        }
        if (this.t.currentToken != 201) {
            if (this.t.currentToken == 69) {
                if (this.t.currentTokenValue.equals("item")) {
                    this.nextToken();
                    this.expect(204);
                    this.nextToken();
                    return AnyItemType.getInstance();
                }
                if (this.t.currentTokenValue.equals("function")) {
                    return this.parseFunctionItemType();
                }
                if (this.t.currentTokenValue.equals("map")) {
                    return this.parseMapItemType();
                }
                if (!this.t.currentTokenValue.equals("empty-sequence")) return this.parseKindTest();
                this.nextToken();
                this.expect(204);
                this.nextToken();
                return ErrorType.getInstance();
            }
            if (this.t.currentToken == 98) {
                this.parseAnnotations();
                if (this.t.currentTokenValue.equals("function")) {
                    return this.parseFunctionItemType();
                }
                this.grumble("Expected 'function' to follow annotation assertions, found " + Token.tokens[this.t.currentToken]);
                return null;
            }
            this.grumble("Expected type name in SequenceType, found " + Token.tokens[this.t.currentToken]);
            return BuiltInAtomicType.ANY_ATOMIC;
        }
        ItemType primaryType = this.getPlainType(this.t.currentTokenValue);
        this.nextToken();
        return primaryType;
    }

    protected ItemType parseFunctionItemType() throws XPathException {
        this.grumble("The item type function() is available only when XPath 3.0 is enabled");
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    protected ItemType parseMapItemType() throws XPathException {
        this.grumble("The item type map() is available only when XPath 3.0 is enabled");
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    private ItemType parseParenthesizedItemType() throws XPathException {
        if (!this.allowXPath30Syntax) {
            this.grumble("Parenthesized item types require 3.0 to be enabled");
        }
        this.nextToken();
        ItemType primaryType = this.parseItemType();
        this.expect(204);
        this.nextToken();
        return primaryType;
    }

    private Expression parseUnaryExpression() throws XPathException {
        Expression exp;
        switch (this.t.currentToken) {
            case 16: {
                this.nextToken();
                exp = new ArithmeticExpression(Literal.makeLiteral(Int64Value.ZERO, this.defaultContainer), 299, this.parseUnaryExpression());
                break;
            }
            case 15: {
                this.nextToken();
                exp = new ArithmeticExpression(Literal.makeLiteral(Int64Value.ZERO, this.defaultContainer), 15, this.parseUnaryExpression());
                break;
            }
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                exp = this.parseValidateExpression();
                break;
            }
            case 218: {
                exp = this.parseExtensionExpression();
                break;
            }
            case 60: {
                if (this.t.currentTokenValue.equals("validate")) {
                    exp = this.parseValidateExpression();
                    break;
                }
            }
            default: {
                exp = this.parseSimpleMappingExpression();
            }
        }
        this.setLocation(exp);
        return exp;
    }

    protected boolean atStartOfRelativePath() {
        switch (this.t.currentToken) {
            case 3: 
            case 5: 
            case 21: 
            case 35: 
            case 36: 
            case 43: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 69: 
            case 70: 
            case 201: 
            case 202: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 218: {
                return true;
            }
            case 60: {
                return this.t.currentTokenValue.equals("ordered") || this.t.currentTokenValue.equals("unordered");
            }
        }
        return false;
    }

    protected boolean disallowedAtStartOfRelativePath() {
        switch (this.t.currentToken) {
            case 45: 
            case 46: 
            case 47: 
            case 57: {
                return true;
            }
        }
        return false;
    }

    protected Expression parsePathExpression() throws XPathException {
        switch (this.t.currentToken) {
            case 2: {
                this.nextToken();
                RootExpression start = new RootExpression();
                this.setLocation(start);
                if (this.disallowedAtStartOfRelativePath()) {
                    this.grumble("Operator '" + Token.tokens[this.t.currentToken] + "' is not allowed after '/'");
                }
                if (this.atStartOfRelativePath()) {
                    Expression path = this.parseRemainingPath(start);
                    this.setLocation(path);
                    return path;
                }
                return start;
            }
            case 8: {
                this.nextToken();
                RootExpression start2 = new RootExpression();
                this.setLocation(start2);
                AxisExpression axisExp = new AxisExpression(5, null);
                this.setLocation(axisExp);
                Expression slashExp = ExpressionTool.makePathExpression(start2, axisExp, false);
                this.setLocation(slashExp);
                Expression exp = this.parseRemainingPath(slashExp);
                this.setLocation(exp);
                return exp;
            }
        }
        if (this.t.currentToken == 201 && (this.t.currentTokenValue.equals("true") || this.t.currentTokenValue.equals("false"))) {
            this.warning("The expression is looking for a child element named '" + this.t.currentTokenValue + "' - perhaps " + this.t.currentTokenValue + "() was intended? To avoid this warning, use child::" + this.t.currentTokenValue + " or ./" + this.t.currentTokenValue);
        }
        return this.parseRelativePath();
    }

    protected Expression parseSimpleMappingExpression() throws XPathException {
        Expression exp = this.parsePathExpression();
        while (this.t.currentToken == 40) {
            if (!this.env.getXPathLanguageLevel().equals(DecimalValue.THREE)) {
                this.grumble("XPath '!' operator requires XPath 3.0 to be enabled");
            }
            this.nextToken();
            Expression next = this.parsePathExpression();
            exp = new ForEach(exp, next);
        }
        return exp;
    }

    protected Expression parseRelativePath() throws XPathException {
        Expression exp = this.parseStepExpression(this.language == 1);
        while (this.t.currentToken == 2 || this.t.currentToken == 8) {
            int op = this.t.currentToken;
            this.nextToken();
            Expression next = this.parseStepExpression(false);
            if (op == 2) {
                exp = ExpressionTool.makePathExpression(exp, next, true);
            } else if (op == 8) {
                AxisExpression ae = new AxisExpression(5, null);
                this.setLocation(ae);
                Expression one = ExpressionTool.makePathExpression(exp, ae, false);
                this.setLocation(one);
                exp = ExpressionTool.makePathExpression(one, next, true);
            }
            this.setLocation(exp);
        }
        return exp;
    }

    protected Expression parseRemainingPath(Expression start) throws XPathException {
        Expression exp = start;
        int op = 2;
        while (true) {
            Expression next = this.parseStepExpression(false);
            if (op == 2) {
                exp = ExpressionTool.makePathExpression(exp, next, true);
            } else if (op == 8) {
                AxisExpression descOrSelf = new AxisExpression(5, null);
                this.setLocation(descOrSelf);
                Expression step = ExpressionTool.makePathExpression(descOrSelf, next, false);
                this.setLocation(step);
                exp = ExpressionTool.makePathExpression(exp, step, true);
            } else {
                if (!this.env.getXPathLanguageLevel().equals(DecimalValue.THREE)) {
                    this.grumble("XPath '!' operator requires XPath 3.0 to be enabled");
                }
                exp = new ForEach(exp, next);
            }
            this.setLocation(exp);
            op = this.t.currentToken;
            if (op != 2 && op != 8 && op != 40) break;
            this.nextToken();
        }
        return exp;
    }

    protected Expression parseStepExpression(boolean firstInPattern) throws XPathException {
        boolean reverse;
        Expression step = this.parseBasicStep(firstInPattern);
        boolean bl = reverse = step instanceof AxisExpression && !AxisInfo.isForwards[((AxisExpression)step).getAxis()];
        while (true) {
            if (this.t.currentToken == 4) {
                this.nextToken();
                Expression predicate = this.parsePredicate();
                this.expect(203);
                this.nextToken();
                step = new FilterExpression(step, predicate);
                this.setLocation(step);
                continue;
            }
            if (this.t.currentToken != 5) break;
            step = this.parseDynamicFunctionCall(step);
            this.setLocation(step);
        }
        if (reverse) {
            step = SystemFunctionCall.makeSystemFunction("reverse", new Expression[]{step});
            assert (step != null);
            return step;
        }
        return step;
    }

    protected Expression parsePredicate() throws XPathException {
        return this.parseExpression();
    }

    protected boolean isReservedInQuery(String uri) {
        if (this.allowXPath30Syntax) {
            return NamespaceConstant.isReservedInQuery30(uri);
        }
        return NamespaceConstant.isReservedInQuery(uri);
    }

    protected Expression parseBasicStep(boolean firstInPattern) throws XPathException {
        switch (this.t.currentToken) {
            case 21: {
                return this.parseVariableReference();
            }
            case 5: {
                this.nextToken();
                if (this.t.currentToken == 204) {
                    this.nextToken();
                    return Literal.makeEmptySequence(this.defaultContainer);
                }
                Expression seq = this.parseExpression();
                this.expect(204);
                this.nextToken();
                return seq;
            }
            case 202: {
                return this.parseStringLiteral();
            }
            case 209: {
                return this.parseNumericLiteral();
            }
            case 35: {
                return this.parseFunctionCall();
            }
            case 205: {
                this.nextToken();
                ContextItemExpression cie = new ContextItemExpression();
                this.setLocation(cie);
                return cie;
            }
            case 206: {
                this.nextToken();
                AxisExpression pne = new AxisExpression(9, null);
                this.setLocation(pne);
                return pne;
            }
            case 98: {
                Map<StructuredQName, Annotation> annotations = this.parseAnnotations();
                if (!this.t.currentTokenValue.equals("function")) {
                    this.grumble("Expected 'function' to follow the annotation assertion");
                }
                if (annotations.containsKey(Annotation.PRIVATE) || annotations.containsKey(Annotation.PUBLIC)) {
                    this.grumble("Inline functions must not be annotated %private or %public", "XQST0125");
                }
                return this.parseInlineFunction(annotations);
            }
            case 69: {
                if (this.t.currentTokenValue.equals("function")) {
                    HashMap<StructuredQName, Annotation> annotations = new HashMap<StructuredQName, Annotation>();
                    return this.parseInlineFunction(annotations);
                }
                if (this.t.currentTokenValue.equals("map")) {
                    return this.parseFunctionCall();
                }
            }
            case 70: 
            case 201: 
            case 207: 
            case 208: {
                int defaultAxis = 3;
                if (this.t.currentToken == 69 && (this.t.currentTokenValue.equals("attribute") || this.t.currentTokenValue.equals("schema-attribute"))) {
                    defaultAxis = 2;
                } else if (this.t.currentToken == 69 && this.t.currentTokenValue.equals("namespace-node")) {
                    defaultAxis = 8;
                    this.testPermittedAxis((byte)8);
                } else if (firstInPattern && this.t.currentToken == 69 && this.t.currentTokenValue.equals("document-node")) {
                    defaultAxis = 12;
                }
                NodeTest test = this.parseNodeTest((short)1);
                if (test instanceof AnyNodeTest) {
                    test = defaultAxis == 3 ? AnyChildNodeTest.getInstance() : NodeKindTest.ATTRIBUTE;
                }
                AxisExpression ae = new AxisExpression((byte)defaultAxis, test);
                this.setLocation(ae);
                return ae;
            }
            case 3: {
                this.nextToken();
                switch (this.t.currentToken) {
                    case 69: 
                    case 70: 
                    case 201: 
                    case 207: 
                    case 208: {
                        AxisExpression ae2 = new AxisExpression(2, this.parseNodeTest((short)2));
                        this.setLocation(ae2);
                        return ae2;
                    }
                }
                this.grumble("@ must be followed by a NodeTest");
                break;
            }
            case 36: {
                byte axis;
                try {
                    axis = AxisInfo.getAxisNumber(this.t.currentTokenValue);
                }
                catch (XPathException err) {
                    this.grumble(err.getMessage());
                    axis = 3;
                }
                this.testPermittedAxis(axis);
                short principalNodeType = AxisInfo.principalNodeType[axis];
                this.nextToken();
                switch (this.t.currentToken) {
                    case 69: 
                    case 70: 
                    case 201: 
                    case 207: 
                    case 208: {
                        AxisExpression ax = new AxisExpression(axis, this.parseNodeTest(principalNodeType));
                        this.setLocation(ax);
                        return ax;
                    }
                }
                this.grumble("Unexpected token " + this.currentTokenDisplay() + " after axis name");
                break;
            }
            case 60: {
                if (this.t.currentTokenValue.equals("map")) {
                    return this.parseMapExpression();
                }
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 217: {
                return this.parseConstructor();
            }
            case 43: {
                return this.parseLiteralFunctionItem();
            }
            default: {
                this.grumble("Unexpected token " + this.currentTokenDisplay() + " in path expression");
            }
        }
        return new ErrorExpression();
    }

    protected void testPermittedAxis(byte axis) throws XPathException {
    }

    protected Expression parseNumericLiteral() throws XPathException {
        int offset = this.t.currentTokenStartOffset;
        NumericValue number = NumericValue.parseNumber(this.t.currentTokenValue);
        if (number.isNaN()) {
            this.grumble("Invalid numeric literal " + Err.wrap(this.t.currentTokenValue, 4));
        }
        this.nextToken();
        Literal lit = Literal.makeLiteral(number, this.defaultContainer);
        this.setLocation(lit);
        return this.makeTracer(offset, lit, 0, null);
    }

    protected Expression parseStringLiteral() throws XPathException {
        int offset = this.t.currentTokenStartOffset;
        Literal literal = this.makeStringLiteral(this.t.currentTokenValue);
        this.nextToken();
        return this.makeTracer(offset, literal, 0, null);
    }

    protected Expression parseVariableReference() throws XPathException {
        Expression ref;
        this.nextToken();
        this.expect(201);
        String var = this.t.currentTokenValue;
        this.nextToken();
        if (this.scanOnly) {
            return new ContextItemExpression();
        }
        StructuredQName vtest = this.makeStructuredQName(var, "");
        LocalBinding b = this.findRangeVariable(vtest);
        if (b != null) {
            ref = new LocalVariableReference(b);
        } else {
            if (this.catchDepth > 0) {
                for (StructuredQName errorVariable : StandardNames.errorVariables) {
                    if (!errorVariable.getLocalPart().equals(vtest.getLocalPart())) continue;
                    VendorFunctionLibrary lib = this.env.getConfiguration().getVendorFunctionLibrary();
                    StructuredQName functionName = new StructuredQName("saxon", "http://saxon.sf.net/", "dynamic-error-info");
                    SymbolicName sn = new SymbolicName(155, functionName, 1);
                    Expression[] args = new Expression[]{new StringLiteral(vtest.getLocalPart(), this.defaultContainer)};
                    return lib.bind(sn, args, this.env, null);
                }
            }
            try {
                ref = this.env.bindVariable(vtest);
            }
            catch (XPathException err) {
                ContextItemExpression dummy = new ContextItemExpression();
                this.setLocation(dummy);
                err.maybeSetLocation(dummy);
                throw err;
            }
        }
        this.setLocation(ref);
        return ref;
    }

    protected Literal makeStringLiteral(String currentTokenValue) throws XPathException {
        StringLiteral literal = new StringLiteral(currentTokenValue, this.defaultContainer);
        this.setLocation(literal);
        return literal;
    }

    protected CharSequence unescape(String token) throws XPathException {
        return token;
    }

    protected Expression parseConstructor() throws XPathException {
        this.grumble("Node constructor expressions are allowed only in XQuery, not in XPath");
        return new ErrorExpression();
    }

    protected Expression parseDynamicFunctionCall(Expression functionItem) throws XPathException {
        this.grumble("Unexpected '(' after primary expression. (Dynamic function calls require XPath 3.0)");
        return new ErrorExpression();
    }

    protected NodeTest parseNodeTest(short nodeType) throws XPathException {
        int tok = this.t.currentToken;
        String tokv = this.t.currentTokenValue;
        switch (tok) {
            case 201: {
                this.nextToken();
                return this.makeNameTest(nodeType, tokv, nodeType == 1);
            }
            case 208: {
                this.nextToken();
                return this.makeNamespaceTest(nodeType, tokv);
            }
            case 70: {
                this.nextToken();
                tokv = this.t.currentTokenValue;
                this.expect(201);
                this.nextToken();
                return this.makeLocalNameTest(nodeType, tokv);
            }
            case 207: {
                this.nextToken();
                return NodeKindTest.makeNodeKindTest(nodeType);
            }
            case 69: {
                return this.parseKindTest();
            }
        }
        this.grumble("Unrecognized node test");
        throw new XPathException("");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private NodeTest parseKindTest() throws XPathException {
        typeName = this.t.currentTokenValue;
        schemaDeclaration = typeName.startsWith("schema-");
        primaryType = this.getSystemType(typeName);
        nameCode = -1;
        empty = false;
        this.nextToken();
        if (this.t.currentToken == 204) {
            if (schemaDeclaration) {
                this.grumble("schema-element() and schema-attribute() require a name to be supplied");
                return null;
            }
            empty = true;
            this.nextToken();
        }
        switch (primaryType) {
            case 88: {
                this.grumble("item() is not allowed in a path expression");
                return null;
            }
            case 0: {
                if (empty) {
                    return AnyNodeTest.getInstance();
                }
                this.grumble("No arguments are allowed in node()");
                return null;
            }
            case 3: {
                if (empty) {
                    return NodeKindTest.TEXT;
                }
                this.grumble("No arguments are allowed in text()");
                return null;
            }
            case 8: {
                if (empty) {
                    return NodeKindTest.COMMENT;
                }
                this.grumble("No arguments are allowed in comment()");
                return null;
            }
            case 13: {
                if (empty) {
                    if (!this.isNamespaceTestAllowed()) {
                        this.grumble("namespace-node() test is not allowed in XPath 2.0/XQuery 1.0");
                    }
                    return NodeKindTest.NAMESPACE;
                }
                this.grumble("No arguments are allowed in namespace-node()");
                return null;
            }
            case 9: {
                if (empty) {
                    return NodeKindTest.DOCUMENT;
                }
                try {
                    innerType = this.getSystemType(this.t.currentTokenValue);
                }
                catch (XPathException err) {
                    innerType = 88;
                }
                if (innerType != 1) {
                    this.grumble("Argument to document-node() must be an element type descriptor");
                    return null;
                }
                inner = this.parseKindTest();
                this.expect(204);
                this.nextToken();
                return new DocumentNodeTest(inner);
            }
            case 7: {
                if (empty) {
                    return NodeKindTest.PROCESSING_INSTRUCTION;
                }
                if (this.t.currentToken != 202) ** GOTO lbl64
                piName = Whitespace.trim(this.unescape(this.t.currentTokenValue));
                if (!NameChecker.isValidNCName(piName)) {
                    this.grumble("Processing instruction name must be a valid NCName", "XPTY0004");
                } else {
                    nameCode = this.env.getNamePool().allocate("", "", piName);
                }
                ** GOTO lbl76
lbl64:
                // 1 sources

                if (this.t.currentToken != 201) ** GOTO lbl75
                try {
                    parts = NameChecker.getQNameParts(this.t.currentTokenValue);
                    if (parts[0].length() != 0) ** GOTO lbl70
                    nameCode = this.makeNameCode(parts[1], false);
                    ** GOTO lbl76
lbl70:
                    // 1 sources

                    this.grumble("Processing instruction name must not contain a colon");
                }
                catch (QNameException e) {
                    this.grumble("Invalid processing instruction name. " + e.getMessage());
                }
                ** GOTO lbl76
lbl75:
                // 1 sources

                this.grumble("Processing instruction name must be a QName or a string literal");
lbl76:
                // 6 sources

                this.nextToken();
                this.expect(204);
                this.nextToken();
                return new NameTest(7, nameCode, this.env.getNamePool());
            }
            case 1: 
            case 2: {
                nodeName = "";
                if (empty) {
                    return NodeKindTest.makeNodeKindTest(primaryType);
                }
                if (this.t.currentToken == 207 || this.t.currentToken == 17) {
                    if (schemaDeclaration) {
                        this.grumble("schema-element() and schema-attribute() must specify an actual name, not '*'");
                        return null;
                    }
                    nameCode = -1;
                } else if (this.t.currentToken == 201) {
                    nodeName = this.t.currentTokenValue;
                    nameCode = this.makeNameCode(this.t.currentTokenValue, primaryType == 1);
                } else {
                    this.grumble("Unexpected " + Token.tokens[this.t.currentToken] + " after '(' in SequenceType");
                }
                suri = null;
                if (nameCode != -1) {
                    suri = this.env.getNamePool().getURI(nameCode);
                }
                this.nextToken();
                if (this.t.currentToken == 204) {
                    this.nextToken();
                    if (nameCode == -1) {
                        return NodeKindTest.makeNodeKindTest(primaryType);
                    }
                    if (primaryType == 2) {
                        if (schemaDeclaration) {
                            attributeDecl = this.env.getConfiguration().getAttributeDeclaration(nameCode & 1048575);
                            if (!this.env.isImportedSchema(suri)) {
                                this.grumble("No schema has been imported for namespace '" + suri + '\'', "XPST0008");
                            }
                            if (attributeDecl == null) {
                                this.grumble("There is no declaration for attribute @" + nodeName + " in an imported schema", "XPST0008");
                                return null;
                            }
                            return attributeDecl.makeSchemaNodeTest();
                        }
                        nameTest = new NameTest(2, nameCode, this.env.getNamePool());
                        return nameTest;
                    }
                    if (schemaDeclaration) {
                        if (!this.env.isImportedSchema(suri)) {
                            this.grumble("No schema has been imported for namespace '" + suri + '\'', "XPST0008");
                        }
                        if ((elementDecl = this.env.getConfiguration().getElementDeclaration(nameCode & 1048575)) == null) {
                            this.grumble("There is no declaration for element <" + nodeName + "> in an imported schema", "XPST0008");
                            return null;
                        }
                        return elementDecl.makeSchemaNodeTest();
                    }
                    nameTest = new NameTest(1, nameCode, this.env.getNamePool());
                    return nameTest;
                }
                if (this.t.currentToken == 7) {
                    if (schemaDeclaration) {
                        this.grumble("schema-element() and schema-attribute() must have one argument only");
                        return null;
                    }
                    this.nextToken();
                    if (this.t.currentToken == 207) {
                        this.grumble("'*' is no longer permitted as the second argument of element() and attribute()");
                        return null;
                    }
                    if (this.t.currentToken == 201) {
                        contentType = this.makeNameCode(this.t.currentTokenValue, true) & 1048575;
                        uri = this.env.getNamePool().getURI(contentType);
                        lname = this.env.getNamePool().getLocalName(contentType);
                        if (uri.equals("http://www.w3.org/2001/XMLSchema")) {
                            schemaType = this.env.getConfiguration().getSchemaType(contentType);
                        } else {
                            if (!this.env.isImportedSchema(uri)) {
                                this.grumble("No schema has been imported for namespace '" + uri + '\'', "XPST0008");
                            }
                            schemaType = this.env.getConfiguration().getSchemaType(contentType);
                        }
                        if (schemaType == null) {
                            this.grumble("Unknown type name " + lname, "XPST0008");
                            return null;
                        }
                        if (primaryType == 2 && schemaType.isComplexType()) {
                            this.warning("An attribute cannot have a complex type");
                        }
                        typeTest = new ContentTypeTest(primaryType, schemaType, this.env.getConfiguration(), false);
                        if (nameCode == -1) {
                            result /* !! */  = typeTest;
                            if (primaryType == 2) {
                                this.nextToken();
                            } else {
                                this.nextToken();
                                if (this.t.currentToken == 213) {
                                    typeTest.setNillable(true);
                                    this.nextToken();
                                }
                            }
                        } else if (primaryType == 2) {
                            nameTest = new NameTest(2, nameCode, this.env.getNamePool());
                            result /* !! */  = new CombinedNodeTest(nameTest, 23, typeTest);
                            this.nextToken();
                        } else {
                            nameTest = new NameTest(1, nameCode, this.env.getNamePool());
                            result /* !! */  = new CombinedNodeTest(nameTest, 23, typeTest);
                            this.nextToken();
                            if (this.t.currentToken == 213) {
                                typeTest.setNillable(true);
                                this.nextToken();
                            }
                        }
                    } else {
                        this.grumble("Unexpected " + Token.tokens[this.t.currentToken] + " after ',' in SequenceType");
                        return null;
                    }
                    this.expect(204);
                    this.nextToken();
                    return result /* !! */ ;
                }
                this.grumble("Expected ')' or ',' in SequenceType");
                return null;
            }
        }
        this.grumble("Unknown node kind");
        return null;
    }

    protected boolean isNamespaceTestAllowed() {
        return this.allowXPath30Syntax;
    }

    private int getSystemType(String name) throws XPathException {
        if ("item".equals(name)) {
            return 88;
        }
        if ("document-node".equals(name)) {
            return 9;
        }
        if ("element".equals(name)) {
            return 1;
        }
        if ("schema-element".equals(name)) {
            return 1;
        }
        if ("attribute".equals(name)) {
            return 2;
        }
        if ("schema-attribute".equals(name)) {
            return 2;
        }
        if ("text".equals(name)) {
            return 3;
        }
        if ("comment".equals(name)) {
            return 8;
        }
        if ("processing-instruction".equals(name)) {
            return 7;
        }
        if ("namespace-node".equals(name)) {
            return 13;
        }
        if ("node".equals(name)) {
            return 0;
        }
        this.grumble("Unknown type " + name);
        return -1;
    }

    protected Expression parseMapExpression() throws XPathException {
        this.grumble("map expressions require XPath 3.0/XQuery 3.0 to be enabled");
        return new ErrorExpression();
    }

    protected Expression parseFunctionCall() throws XPathException {
        Expression fcall;
        String fname = this.t.currentTokenValue;
        int offset = this.t.currentTokenStartOffset;
        ArrayList<Expression> args = new ArrayList<Expression>(10);
        StructuredQName functionName = this.resolveFunctionName(fname);
        IntArraySet placeMarkers = null;
        this.nextToken();
        if (this.t.currentToken != 204) {
            while (true) {
                Expression arg;
                if ((arg = this.parseFunctionArgument()) == null) {
                    if (placeMarkers == null) {
                        placeMarkers = new IntArraySet();
                    }
                    placeMarkers.add(args.size());
                    arg = Literal.makeEmptySequence(this.defaultContainer);
                }
                args.add(arg);
                if (this.t.currentToken != 7) break;
                this.nextToken();
            }
            this.expect(204);
        }
        this.nextToken();
        if (this.scanOnly) {
            return new StringLiteral(StringValue.EMPTY_STRING, this.defaultContainer);
        }
        Expression[] arguments = new Expression[args.size()];
        args.toArray(arguments);
        if (placeMarkers != null) {
            return this.makeCurriedFunction(offset, functionName, arguments, placeMarkers);
        }
        try {
            SymbolicName sn = new SymbolicName(155, functionName, args.size());
            fcall = this.env.getFunctionLibrary().bind(sn, arguments, this.env, this.defaultContainer);
            if (fcall instanceof UserFunctionCall && this.env instanceof ExpressionContext) {
                final UserFunctionCall ufCall = (UserFunctionCall)fcall;
                final StylesheetPackage pack = ((ExpressionContext)this.env).getStyleElement().getCompilation().getStylesheetPackage();
                final ExpressionVisitor visitor = ExpressionVisitor.make(this.env);
                pack.addFixupAction(new StylesheetPackage.Action(){

                    public void doAction() throws XPathException {
                        if (ufCall.getFunction() == null) {
                            Component target = pack.getComponent(ufCall.getSymbolicName());
                            UserFunction fn = (UserFunction)target.getProcedure();
                            if (fn != null) {
                                ufCall.setFunction(fn);
                                ufCall.checkFunctionCall(fn, visitor);
                                ufCall.computeArgumentEvaluationModes();
                                ufCall.setStaticType(fn.getResultType());
                            } else {
                                XPathException err = new XPathException("There is no available function named " + ufCall.getDisplayName() + " with " + ufCall.getNumberOfArguments() + " arguments", "XPST0017");
                                err.setLocator(ufCall);
                                throw err;
                            }
                        }
                    }
                });
            }
        }
        catch (XPathException err) {
            if (err.getErrorCodeQName() == null) {
                err.setErrorCode("XPST0017");
                err.setIsStaticError(true);
            }
            if (functionName.hasURI("http://www.w3.org/2011/xpath-functions/map")) {
                this.grumble("Saxon currently implements the XSLT 3.0 map functions in namespace http://www.w3.org/2005/xpath-functions/map");
            } else {
                this.grumble(err.getMessage(), err.getErrorCodeQName(), offset);
            }
            return new ErrorExpression();
        }
        if (fcall == null) {
            if (functionName.hasURI("http://exslt.org/common") && functionName.getLocalPart().equals("node-set") && arguments.length == 1) {
                return arguments[0];
            }
            return this.reportMissingFunction(offset, functionName, arguments);
        }
        if (fcall instanceof CastExpression && ((AtomicType)fcall.getItemType()).isNamespaceSensitive()) {
            ((CastExpression)fcall).setNamespaceResolver(new SavedNamespaceContext(this.env.getNamespaceResolver()));
        }
        if (this.language == 1 && fcall instanceof SystemFunctionCall) {
            if (fcall instanceof RegexGroup) {
                return Literal.makeEmptySequence(this.defaultContainer);
            }
            if (fcall instanceof CurrentGroup) {
                this.grumble("The current-group() function cannot be used in a pattern", "XTSE1060", offset);
                return new ErrorExpression();
            }
            if (fcall instanceof CurrentGroupingKey) {
                this.grumble("The current-grouping-key() function cannot be used in a pattern", "XTSE1070", offset);
                return new ErrorExpression();
            }
            if (((SystemFunctionCall)fcall).getFunctionName().getLocalPart().equals("current-merge-group")) {
                this.grumble("The current-merge-group() function cannot be used in a pattern", "XTSE3470", offset);
                return new ErrorExpression();
            }
            if (((SystemFunctionCall)fcall).getFunctionName().getLocalPart().equals("current-merge-key")) {
                this.grumble("The current-merge-key() function cannot be used in a pattern", "XTSE3500", offset);
                return new ErrorExpression();
            }
        }
        this.setLocation(fcall, offset);
        for (Expression argument : arguments) {
            fcall.adoptChildExpression(argument);
        }
        return this.makeTracer(offset, fcall, 2009, functionName);
    }

    public Expression reportMissingFunction(int offset, StructuredQName functionName, Expression[] arguments) throws XPathException {
        String msg = "Cannot find a matching " + arguments.length + "-argument function named " + functionName.getClarkName() + "()";
        Configuration config = this.env.getConfiguration();
        if (config.getBooleanProperty("http://saxon.sf.net/feature/allow-external-functions")) {
            boolean existsWithDifferentArity = false;
            for (int i = 0; i < arguments.length + 5; ++i) {
                if (i == arguments.length) continue;
                SymbolicName sn = new SymbolicName(155, functionName, i);
                if (!this.env.getFunctionLibrary().isAvailable(sn)) continue;
                existsWithDifferentArity = true;
                break;
            }
            if (existsWithDifferentArity) {
                msg = msg + ". The namespace URI and local name are recognized, but the number of arguments is wrong";
            } else {
                String supplementary = XPathParser.getMissingFunctionExplanation(functionName, config);
                if (supplementary != null) {
                    msg = msg + ". " + supplementary;
                }
            }
        } else {
            msg = msg + ". External function calls have been disabled";
        }
        if (this.env.isInBackwardsCompatibleMode()) {
            XPathException err = new XPathException(msg, "XTDE1425");
            return new ErrorExpression(err);
        }
        this.grumble(msg, "XPST0017", offset);
        return null;
    }

    public static String getMissingFunctionExplanation(StructuredQName functionName, Configuration config) {
        String actualURI = functionName.getURI();
        String similarNamespace = NamespaceConstant.findSimilarNamespace(actualURI);
        if (similarNamespace != null) {
            if (similarNamespace.equals(actualURI)) {
                if (similarNamespace.equals("http://saxon.sf.net/") && config.getEditionCode().equals("HE")) {
                    return "Saxon extension functions are not available under Saxon-HE";
                }
                if (similarNamespace.equals("http://saxon.sf.net/") && !config.isLicensedFeature(8)) {
                    return "Saxon extension functions require a Saxon-PE or Saxon-EE license";
                }
                return "There is no Saxon extension function with the local name " + functionName.getLocalPart();
            }
            return "Perhaps the intended namespace was '" + similarNamespace + "'";
        }
        if (actualURI.contains("java")) {
            if (config.getEditionCode().equals("HE")) {
                return "Reflexive calls to Java methods are not available under Saxon-HE";
            }
            if (!config.isLicensedFeature(8)) {
                return "Reflexive calls to Java methods require a Saxon-PE or Saxon-EE license, and none was found";
            }
            return "For diagnostics on calls to Java methods, use the -TJ command line option or set the Configuration property FeatureKeys.TRACE_EXTERNAL_FUNCTIONS";
        }
        if (actualURI.startsWith("clitype:")) {
            if (config.getEditionCode().equals("HE")) {
                return "Reflexive calls to external .NET methods are not available under Saxon-HE";
            }
            if (!config.isLicensedFeature(8)) {
                return "Reflexive calls to external .NET methods require a Saxon-PE or Saxon-EE license, and none was found";
            }
            return "For diagnostics on calls to .NET methods, use the -TJ command line option or call processor.SetProperty(\"http://saxon.sf.net/feature/trace-external-functions\", \"true\")";
        }
        return null;
    }

    protected StructuredQName resolveFunctionName(String fname) throws XPathException {
        ItemType t;
        String local;
        String uri;
        StructuredQName functionName;
        if (this.scanOnly) {
            return new StructuredQName("", "http://saxon.sf.net/", "dummy");
        }
        int offset = this.t.currentTokenStartOffset;
        if (fname.startsWith("{")) {
            if (!this.allowXPath30Syntax) {
                this.grumble("Expanded QName syntax requires XPath 3.0/XQuery 3.0");
            }
            functionName = StructuredQName.fromClarkName(fname);
            uri = functionName.getURI();
            local = functionName.getLocalPart();
        } else {
            String[] parts;
            try {
                parts = NameChecker.getQNameParts(fname);
            }
            catch (QNameException e) {
                this.grumble("Function name is not a valid QName: " + fname + "()", "XPST0003", offset);
                throw new XPathException("");
            }
            local = parts[1];
            if (parts[0].length() == 0) {
                uri = this.env.getDefaultFunctionNamespace();
            } else {
                try {
                    uri = this.env.getURIForPrefix(parts[0]);
                }
                catch (XPathException err) {
                    this.grumble(err.getMessage(), "XPST0081", offset);
                    throw err;
                }
            }
            functionName = new StructuredQName(parts[0], uri, local);
        }
        if (uri.equals("http://www.w3.org/2001/XMLSchema") && (t = Type.getBuiltInItemType(uri, local)) instanceof BuiltInAtomicType && !this.env.isAllowedBuiltInType((BuiltInAtomicType)t)) {
            this.grumble("The type " + fname + " is not recognized by a Basic XSLT Processor. ", "XPST0080", offset);
            throw new XPathException("");
        }
        return functionName;
    }

    public Expression parseFunctionArgument() throws XPathException {
        return this.parseExprSingle();
    }

    protected Expression parseLiteralFunctionItem() throws XPathException {
        this.grumble("Literal function items are not allowed in Saxon-HE");
        return new ErrorExpression();
    }

    protected Map<StructuredQName, Annotation> parseAnnotations() throws XPathException {
        this.grumble("Inline functions are not allowed in Saxon-HE");
        return null;
    }

    protected Expression parseInlineFunction(Map<StructuredQName, Annotation> annotations) throws XPathException {
        this.grumble("Inline functions are not allowed in Saxon-HE");
        return new ErrorExpression();
    }

    protected Expression makeCurriedFunction(int offset, StructuredQName name, Expression[] args, IntSet placeMarkers) throws XPathException {
        this.grumble("Partial function application is not allowed in Saxon-HE");
        return new ErrorExpression();
    }

    public Stack<LocalBinding> getRangeVariables() {
        return this.rangeVariables;
    }

    public void setRangeVariables(Stack<LocalBinding> variables) {
        this.rangeVariables = variables;
    }

    public void declareRangeVariable(LocalBinding declaration) throws XPathException {
        this.rangeVariables.push(declaration);
    }

    public void undeclareRangeVariable() {
        this.rangeVariables.pop();
    }

    protected LocalBinding findRangeVariable(StructuredQName qName) {
        for (int v = this.rangeVariables.size() - 1; v >= 0; --v) {
            LocalBinding b = (LocalBinding)this.rangeVariables.elementAt(v);
            if (!b.getVariableQName().equals(qName)) continue;
            return b;
        }
        return null;
    }

    public void setRangeVariableStack(Stack<LocalBinding> stack) {
        this.rangeVariables = stack;
    }

    public final int makeNameCode(String qname, boolean useDefault) throws XPathException {
        if (this.scanOnly) {
            return 386;
        }
        if (qname.startsWith("{")) {
            return this.env.getNamePool().allocateClarkName(qname);
        }
        try {
            String[] parts = NameChecker.getQNameParts(qname);
            String prefix = parts[0];
            if (prefix.length() == 0) {
                if (useDefault) {
                    String uri = this.env.getDefaultElementNamespace();
                    return this.env.getNamePool().allocate("", uri, qname);
                }
                return this.env.getNamePool().allocate("", "", qname);
            }
            try {
                String uri = this.env.getURIForPrefix(prefix);
                return this.env.getNamePool().allocate(prefix, uri, parts[1]);
            }
            catch (XPathException err) {
                this.grumble(err.getMessage(), err.getErrorCodeQName(), -1);
                return -1;
            }
        }
        catch (QNameException e) {
            this.grumble(e.getMessage());
            return -1;
        }
    }

    public final StructuredQName makeStructuredQNameSilently(String qname, String defaultUri) throws XPathException, QNameException {
        if (this.scanOnly) {
            return new StructuredQName("", "http://saxon.sf.net/", "dummy");
        }
        String[] parts = NameChecker.getQNameParts(qname);
        String prefix = parts[0];
        if (prefix.length() == 0) {
            return new StructuredQName("", defaultUri, qname);
        }
        String uri = this.env.getURIForPrefix(prefix);
        return new StructuredQName(prefix, uri, parts[1]);
    }

    public final StructuredQName makeStructuredQName(String qname, String defaultUri) throws XPathException {
        if (this.scanOnly) {
            return new StructuredQName("", "http://saxon.sf.net/", "dummy");
        }
        if (qname.startsWith("{")) {
            return StructuredQName.fromClarkName(qname);
        }
        try {
            String[] parts = NameChecker.getQNameParts(qname);
            String prefix = parts[0];
            if (prefix.length() == 0) {
                return new StructuredQName("", defaultUri, qname);
            }
            try {
                String uri = this.env.getURIForPrefix(prefix);
                return new StructuredQName(prefix, uri, parts[1]);
            }
            catch (XPathException err) {
                this.grumble(err.getMessage(), err.getErrorCodeQName(), -1);
                throw err;
            }
        }
        catch (QNameException e) {
            this.grumble(e.getMessage());
            throw new XPathException(e);
        }
    }

    public final NodeName makeNodeName(String qname, boolean useDefault) throws XPathException, QNameException {
        if (this.scanOnly) {
            return new NoNamespaceName("dummy");
        }
        if (qname.startsWith("{")) {
            return FingerprintedQName.fromClarkName(qname);
        }
        String[] parts = NameChecker.getQNameParts(qname);
        String prefix = parts[0];
        if (prefix.length() == 0) {
            if (useDefault) {
                String uri = this.env.getDefaultElementNamespace();
                int nc = this.env.getNamePool().allocate("", uri, qname);
                return new FingerprintedQName("", uri, qname, nc);
            }
            int nc = this.env.getNamePool().allocate("", "", qname);
            return new NoNamespaceName(qname, nc);
        }
        String uri = this.env.getURIForPrefix(prefix);
        int nc = this.env.getNamePool().allocate(prefix, uri, parts[1]);
        return new FingerprintedQName(prefix, uri, parts[1], nc);
    }

    public NameTest makeNameTest(short nodeType, String qname, boolean useDefault) throws XPathException {
        int nameCode = this.makeNameCode(qname, useDefault);
        return new NameTest((int)nodeType, nameCode, this.env.getNamePool());
    }

    public NamespaceTest makeNamespaceTest(short nodeType, String prefix) throws XPathException {
        if (this.scanOnly) {
            return new NamespaceTest(this.env.getNamePool(), nodeType, "http://saxon.sf.net/");
        }
        String uri = "";
        if (prefix.charAt(0) == '{') {
            int closeBrace = prefix.indexOf(125);
            uri = prefix.substring(1, closeBrace);
        } else {
            try {
                uri = this.env.getURIForPrefix(prefix);
            }
            catch (XPathException e) {
                this.grumble(e.getMessage(), "XPST0081");
            }
        }
        return new NamespaceTest(this.env.getNamePool(), nodeType, uri);
    }

    public LocalNameTest makeLocalNameTest(short nodeType, String localName) throws XPathException {
        if (!NameChecker.isValidNCName(localName)) {
            this.grumble("Local name [" + localName + "] contains invalid characters");
        }
        return new LocalNameTest(this.env.getNamePool(), nodeType, localName);
    }

    protected void setLocation(Expression exp) {
        this.setLocation(exp, this.t.currentTokenStartOffset);
    }

    public void setLocation(Expression exp, int offset) {
        if (exp != null) {
            int line = this.t.getLineNumber(offset);
            if (exp.getLocationId() == -1) {
                int loc = this.env.getLocationMap().allocateLocationId(this.env.getSystemId(), line);
                exp.setLocationId(loc);
            }
            if (exp.getContainer() == null) {
                exp.setContainer(this.defaultContainer);
            }
        }
    }

    public void setLocation(Clause clause, int offset) {
        int line = this.t.getLineNumber(offset);
        int loc = this.env.getLocationMap().allocateLocationId(this.env.getSystemId(), line);
        clause.setLocationId(loc);
    }

    public Expression makeTracer(int startOffset, Expression exp, int construct, StructuredQName qName) {
        if (this.codeInjector != null) {
            return this.codeInjector.inject(exp, this.env, construct, qName);
        }
        return exp;
    }

    protected boolean isKeyword(String s) {
        return this.t.currentToken == 201 && this.t.currentTokenValue.equals(s);
    }

    protected String normalizeEQName(String s) throws XPathException {
        StructuredQName sq;
        if (!Whitespace.containsWhitespace(s)) {
            return s;
        }
        try {
            sq = StructuredQName.fromClarkName(s);
        }
        catch (IllegalArgumentException e) {
            throw new XPathException(e);
        }
        CharSequence uri = Whitespace.collapseWhitespace(sq.getURI());
        return "{" + uri + "}" + sq.getLocalPart();
    }

    public void setScanOnly(boolean scanOnly) {
        this.scanOnly = scanOnly;
    }

    protected class TemporaryContainer
    extends PackageData
    implements Container,
    LocationProvider {
        int locationId;

        public TemporaryContainer(Configuration config, LocationMap map, int locationId) {
            super(config);
            this.setLocationMap(map);
            this.locationId = locationId;
        }

        public int getContainerGranularity() {
            return 0;
        }

        public PackageData getPackageData() {
            return this;
        }

        public Configuration getConfiguration() {
            return XPathParser.this.getStaticContext().getConfiguration();
        }

        public LocationProvider getLocationProvider() {
            return this.getLocationMap();
        }

        public String getPublicId() {
            return null;
        }

        public String getSystemId() {
            return this.getLocationMap().getSystemId(this.locationId);
        }

        public int getLineNumber() {
            return this.getLocationMap().getLineNumber(this.locationId);
        }

        public int getColumnNumber() {
            return -1;
        }

        public String getSystemId(int locationId) {
            return this.getSystemId();
        }

        public int getLineNumber(int locationId) {
            return this.getLineNumber();
        }

        public int getColumnNumber(int locationId) {
            return this.getColumnNumber();
        }

        public int getHostLanguage() {
            return 54;
        }
    }
}

