/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.config.i18n.CoreMessages;
import org.mule.endpoint.AbstractEndpointBuilder;
import org.mule.expression.AbstractExpressionEvaluator;

public class EndpointInfoExpressionEvaluator
extends AbstractExpressionEvaluator
implements MuleContextAware {
    public static final String NAME = "endpoint";
    protected final transient Log logger = LogFactory.getLog(EndpointInfoExpressionEvaluator.class);
    protected MuleContext muleContext;

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public Object evaluate(String expression, MuleMessage message) {
        int i = expression.indexOf(".");
        if (i <= 0) {
            throw new IllegalArgumentException(CoreMessages.expressionMalformed(expression, this.getName()).getMessage());
        }
        String endpointName = expression.substring(0, i);
        String property = expression.substring(i + 1);
        AbstractEndpointBuilder eb = (AbstractEndpointBuilder)this.muleContext.getRegistry().lookupEndpointBuilder(endpointName);
        if (eb != null) {
            if (property.equalsIgnoreCase("address")) {
                return eb.getEndpointBuilder().getEndpoint().getAddress();
            }
            throw new IllegalArgumentException(CoreMessages.expressionInvalidForProperty(property, expression).getMessage());
        }
        this.logger.warn((Object)("There is no endpoint registered with name: " + endpointName));
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

