/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import org.mule.DefaultMuleEvent;
import org.mule.NonBlockingVoidMuleEvent;
import org.mule.OptimizedRequestContext;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.NonBlockingSupported;
import org.mule.api.transport.NonBlockingReplyToHandler;
import org.mule.api.transport.ReplyToHandler;
import org.mule.processor.AbstractInterceptingMessageProcessor;

public abstract class AbstractRequestResponseMessageProcessor
extends AbstractInterceptingMessageProcessor
implements NonBlockingSupported {
    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        if (this.isNonBlocking(event)) {
            return this.processNonBlocking(event);
        }
        return this.processBlocking(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MuleEvent processBlocking(MuleEvent event) throws MuleException {
        MessagingException exception = null;
        try {
            MuleEvent muleEvent = this.processResponse(this.processNext(this.processRequest(event)), event);
            return muleEvent;
        }
        catch (MessagingException e) {
            exception = e;
            MuleEvent muleEvent = this.processCatch(event, e);
            return muleEvent;
        }
        finally {
            this.processFinally(event, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MuleEvent processNonBlocking(MuleEvent event) throws MuleException {
        MessagingException exception = null;
        MuleEvent eventToProcess = new DefaultMuleEvent(event, this.createReplyToHandler(event));
        eventToProcess = OptimizedRequestContext.unsafeSetEvent(eventToProcess);
        try {
            MuleEvent result = this.processNext(this.processRequest(eventToProcess));
            if (!(result instanceof NonBlockingVoidMuleEvent)) {
                MuleEvent muleEvent = this.processResponse(this.recreateEventWithOriginalReplyToHandler(result, event.getReplyToHandler()), event);
                return muleEvent;
            }
            MuleEvent muleEvent = result;
            return muleEvent;
        }
        catch (MessagingException e) {
            exception = e;
            MuleEvent muleEvent = this.processCatch(event, e);
            return muleEvent;
        }
        finally {
            this.processFinally(event, exception);
        }
    }

    protected ReplyToHandler createReplyToHandler(final MuleEvent request) {
        final ReplyToHandler originalReplyToHandler = request.getReplyToHandler();
        return new NonBlockingReplyToHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processReplyTo(MuleEvent event, MuleMessage returnMessage, Object replyTo) throws MuleException {
                try {
                    MuleEvent response = AbstractRequestResponseMessageProcessor.this.processResponse(AbstractRequestResponseMessageProcessor.this.recreateEventWithOriginalReplyToHandler(event, originalReplyToHandler), request);
                    if (!NonBlockingVoidMuleEvent.getInstance().equals(response)) {
                        originalReplyToHandler.processReplyTo(response, null, null);
                    }
                }
                catch (Exception e) {
                    this.processExceptionReplyTo(new MessagingException(event, (Throwable)e), null);
                }
                finally {
                    AbstractRequestResponseMessageProcessor.this.processFinally(event, null);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processExceptionReplyTo(MessagingException exception, Object replyTo) {
                try {
                    MuleEvent handledEvent = AbstractRequestResponseMessageProcessor.this.processCatch(exception.getEvent(), exception);
                    originalReplyToHandler.processReplyTo(handledEvent, null, null);
                }
                catch (Exception e) {
                    originalReplyToHandler.processExceptionReplyTo(exception, replyTo);
                }
                finally {
                    AbstractRequestResponseMessageProcessor.this.processFinally(exception.getEvent(), exception);
                }
            }
        };
    }

    private MuleEvent recreateEventWithOriginalReplyToHandler(MuleEvent event, ReplyToHandler originalReplyToHandler) {
        if (event != null) {
            event = new DefaultMuleEvent(event, originalReplyToHandler);
            OptimizedRequestContext.unsafeSetEvent(event);
        }
        return event;
    }

    protected boolean isNonBlocking(MuleEvent event) {
        return event.isAllowNonBlocking() && event.getReplyToHandler() != null;
    }

    protected MuleEvent processRequest(MuleEvent request) throws MuleException {
        return request;
    }

    protected MuleEvent processResponse(MuleEvent response, MuleEvent request) throws MuleException {
        return this.processResponse(response);
    }

    @Deprecated
    protected MuleEvent processResponse(MuleEvent response) throws MuleException {
        return response;
    }

    protected void processFinally(MuleEvent event, MessagingException exception) {
    }

    protected MuleEvent processCatch(MuleEvent event, MessagingException exception) throws MessagingException {
        throw exception;
    }
}

