/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.http.HttpMethod;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.RegexRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRequestMatcherRegistry<C> {
    private static final RequestMatcher ANY_REQUEST = AnyRequestMatcher.INSTANCE;

    public C anyRequest() {
        return this.requestMatchers(ANY_REQUEST);
    }

    public C antMatchers(HttpMethod method) {
        return this.antMatchers(method, "/**");
    }

    public C antMatchers(HttpMethod method, String ... antPatterns) {
        return this.chainRequestMatchers(RequestMatchers.antMatchers(method, antPatterns));
    }

    public C antMatchers(String ... antPatterns) {
        return this.chainRequestMatchers(RequestMatchers.antMatchers(antPatterns));
    }

    public C regexMatchers(HttpMethod method, String ... regexPatterns) {
        return this.chainRequestMatchers(RequestMatchers.regexMatchers(method, regexPatterns));
    }

    public C regexMatchers(String ... regexPatterns) {
        return this.chainRequestMatchers(RequestMatchers.regexMatchers(regexPatterns));
    }

    public C requestMatchers(RequestMatcher ... requestMatchers) {
        return this.chainRequestMatchers(Arrays.asList(requestMatchers));
    }

    protected abstract C chainRequestMatchers(List<RequestMatcher> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RequestMatchers {
        public static List<RequestMatcher> antMatchers(HttpMethod httpMethod, String ... antPatterns) {
            String method = httpMethod == null ? null : httpMethod.toString();
            ArrayList<RequestMatcher> matchers = new ArrayList<RequestMatcher>();
            for (String pattern : antPatterns) {
                matchers.add((RequestMatcher)new AntPathRequestMatcher(pattern, method));
            }
            return matchers;
        }

        public static List<RequestMatcher> antMatchers(String ... antPatterns) {
            return RequestMatchers.antMatchers(null, antPatterns);
        }

        public static List<RequestMatcher> regexMatchers(HttpMethod httpMethod, String ... regexPatterns) {
            String method = httpMethod == null ? null : httpMethod.toString();
            ArrayList<RequestMatcher> matchers = new ArrayList<RequestMatcher>();
            for (String pattern : regexPatterns) {
                matchers.add((RequestMatcher)new RegexRequestMatcher(pattern, method));
            }
            return matchers;
        }

        public static List<RequestMatcher> regexMatchers(String ... regexPatterns) {
            return RequestMatchers.regexMatchers(null, regexPatterns);
        }

        private RequestMatchers() {
        }
    }
}

