/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet.jetty;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.continuation.Continuation;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageReceiver;
import org.mule.execution.MessageProcessContext;
import org.mule.execution.MessageProcessTemplate;
import org.mule.execution.MessageProcessingManager;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.TransportMessageProcessContext;
import org.mule.transport.servlet.jetty.JettyContinuationsMessageProcessTemplate;
import org.mule.transport.servlet.jetty.JettyMessageProcessTemplate;

public class JettyHttpMessageReceiver
extends AbstractMessageReceiver {
    private MessageProcessingManager messageProcessingManager;

    public JettyHttpMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(connector, flowConstruct, endpoint);
    }

    public void processMessage(HttpServletRequest request, HttpServletResponse response) {
        JettyMessageProcessTemplate messageProcessTemplate = new JettyMessageProcessTemplate(request, response, this, this.getEndpoint().getMuleContext());
        TransportMessageProcessContext messageProcessContext = new TransportMessageProcessContext((MessageReceiver)this);
        this.messageProcessingManager.processMessage((MessageProcessTemplate)messageProcessTemplate, (MessageProcessContext)messageProcessContext);
    }

    public ContinuationsResponseHandler processMessageAsync(HttpServletRequest request, HttpServletResponse response, Continuation continuation) {
        JettyContinuationsMessageProcessTemplate messageProcessTemplate = new JettyContinuationsMessageProcessTemplate(request, response, this, this.getEndpoint().getMuleContext(), continuation);
        TransportMessageProcessContext messageProcessContext = new TransportMessageProcessContext((MessageReceiver)this, this.getWorkManager());
        this.messageProcessingManager.processMessage((MessageProcessTemplate)messageProcessTemplate, (MessageProcessContext)messageProcessContext);
        return new ContinuationsResponseHandler(messageProcessTemplate);
    }

    protected void doInitialise() throws InitialisationException {
        super.doInitialise();
        this.messageProcessingManager = (MessageProcessingManager)this.endpoint.getMuleContext().getRegistry().get("_muleMessageProcessingManager");
    }

    public static class ContinuationsResponseHandler {
        private JettyContinuationsMessageProcessTemplate jettyMessageProcessTemplateAndContext;

        public ContinuationsResponseHandler(JettyContinuationsMessageProcessTemplate jettyMessageProcessTemplateAndContext) {
            this.jettyMessageProcessTemplateAndContext = jettyMessageProcessTemplateAndContext;
        }

        void suspended() {
            this.jettyMessageProcessTemplateAndContext.suspended();
        }

        void complete() {
            this.jettyMessageProcessTemplateAndContext.completeProcessingRequest();
        }
    }
}

