/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.provider;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.ExtensionProviderInfo;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.IQProviderInfo;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.provider.ProviderLoader;

public final class ProviderManager {
    private static ProviderManager instance;
    private Map<String, Object> extensionProviders = new ConcurrentHashMap<String, Object>();
    private Map<String, Object> iqProviders = new ConcurrentHashMap<String, Object>();

    public static synchronized ProviderManager getInstance() {
        if (instance == null) {
            instance = new ProviderManager();
        }
        return instance;
    }

    private ProviderManager() {
    }

    public void addLoader(ProviderLoader loader) {
        if (loader == null) {
            throw new IllegalArgumentException("loader cannot be null");
        }
        if (loader.getIQProviderInfo() != null) {
            for (IQProviderInfo iQProviderInfo : loader.getIQProviderInfo()) {
                this.iqProviders.put(this.getProviderKey(iQProviderInfo.getElementName(), iQProviderInfo.getNamespace()), iQProviderInfo.getProvider());
            }
        }
        if (loader.getExtensionProviderInfo() != null) {
            for (ExtensionProviderInfo extensionProviderInfo : loader.getExtensionProviderInfo()) {
                this.extensionProviders.put(this.getProviderKey(extensionProviderInfo.getElementName(), extensionProviderInfo.getNamespace()), extensionProviderInfo.getProvider());
            }
        }
    }

    public Object getIQProvider(String elementName, String namespace) {
        String key = this.getProviderKey(elementName, namespace);
        return this.iqProviders.get(key);
    }

    public Collection<Object> getIQProviders() {
        return Collections.unmodifiableCollection(this.iqProviders.values());
    }

    public void addIQProvider(String elementName, String namespace, Object provider) {
        if (!(provider instanceof IQProvider || provider instanceof Class && IQ.class.isAssignableFrom((Class)provider))) {
            throw new IllegalArgumentException("Provider must be an IQProvider or a Class instance.");
        }
        String key = this.getProviderKey(elementName, namespace);
        this.iqProviders.put(key, provider);
    }

    public void removeIQProvider(String elementName, String namespace) {
        String key = this.getProviderKey(elementName, namespace);
        this.iqProviders.remove(key);
    }

    public Object getExtensionProvider(String elementName, String namespace) {
        String key = this.getProviderKey(elementName, namespace);
        return this.extensionProviders.get(key);
    }

    public void addExtensionProvider(String elementName, String namespace, Object provider) {
        if (!(provider instanceof PacketExtensionProvider) && !(provider instanceof Class)) {
            throw new IllegalArgumentException("Provider must be a PacketExtensionProvider or a Class instance.");
        }
        String key = this.getProviderKey(elementName, namespace);
        this.extensionProviders.put(key, provider);
    }

    public void removeExtensionProvider(String elementName, String namespace) {
        String key = this.getProviderKey(elementName, namespace);
        this.extensionProviders.remove(key);
    }

    public Collection<Object> getExtensionProviders() {
        return Collections.unmodifiableCollection(this.extensionProviders.values());
    }

    private String getProviderKey(String elementName, String namespace) {
        StringBuilder buf = new StringBuilder();
        buf.append("<").append(elementName).append("/><").append(namespace).append("/>");
        return buf.toString();
    }
}

