/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.request.grizzly;

import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.AsyncHttpProviderConfig;
import com.ning.http.client.BodyDeferringAsyncHandler;
import com.ning.http.client.BodyGenerator;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.filter.RequestFilter;
import com.ning.http.client.generators.InputStreamBodyGenerator;
import com.ning.http.client.multipart.Part;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProviderConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import org.mule.api.CompletionHandler;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.context.WorkManager;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleUtils;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.requester.proxy.ProxyConfig;
import org.mule.module.http.internal.domain.ByteArrayHttpEntity;
import org.mule.module.http.internal.domain.InputStreamHttpEntity;
import org.mule.module.http.internal.domain.MultipartHttpEntity;
import org.mule.module.http.internal.domain.request.DefaultHttpRequest;
import org.mule.module.http.internal.domain.request.HttpRequest;
import org.mule.module.http.internal.domain.request.HttpRequestAuthentication;
import org.mule.module.http.internal.domain.response.HttpResponse;
import org.mule.module.http.internal.domain.response.HttpResponseBuilder;
import org.mule.module.http.internal.multipart.HttpPart;
import org.mule.module.http.internal.request.HttpAuthenticationType;
import org.mule.module.http.internal.request.HttpClient;
import org.mule.module.http.internal.request.HttpClientConfiguration;
import org.mule.module.http.internal.request.NtlmProxyConfig;
import org.mule.module.http.internal.request.grizzly.ByteArrayPart;
import org.mule.module.http.internal.request.grizzly.CompositeTransportCustomizer;
import org.mule.module.http.internal.request.grizzly.CustomTimeoutThrottleRequestFilter;
import org.mule.module.http.internal.request.grizzly.IOStrategyTransportCustomizer;
import org.mule.module.http.internal.request.grizzly.LoggerTransportCustomizer;
import org.mule.module.http.internal.request.grizzly.MemoryManagerTransportCustomizer;
import org.mule.module.http.internal.request.grizzly.SocketConfigTransportCustomizer;
import org.mule.transport.ssl.api.TlsContextFactory;
import org.mule.transport.ssl.api.TlsContextTrustStoreConfiguration;
import org.mule.transport.tcp.TcpClientSocketProperties;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrizzlyHttpClient
implements HttpClient {
    private static final int MAX_CONNECTION_LIFETIME = 1800000;
    public static final String CUSTOM_MAX_HTTP_PACKET_HEADER_SIZE = "mule.http.client.headerSectionSize";
    private static final Logger logger = LoggerFactory.getLogger(GrizzlyHttpClient.class);
    private static final List<String> SPECIAL_CUSTOM_HEADERS = Arrays.asList("Content-Disposition".toLowerCase(), "Content-Transfer-Encoding".toLowerCase(), "Content-Type".toLowerCase(), "Content-Id".toLowerCase());
    public static final String HOST_SEPARATOR = ",";
    private final TlsContextFactory tlsContextFactory;
    private final ProxyConfig proxyConfig;
    private final TcpClientSocketProperties clientSocketProperties;
    private int maxConnections;
    private boolean usePersistentConnections;
    private int connectionIdleTimeout;
    private final boolean streaming;
    private int responseBufferSize;
    private String threadNamePrefix;
    private final Integer kernelCoreSize;
    private final Integer maxKernelCoreSize;
    private final Integer workerCoreSize;
    private final Integer maxWorkerCoreSize;
    private final Integer selectorRunnerCoreSize;
    private String ownerName;
    private AsyncHttpClient asyncHttpClient;
    private SSLContext sslContext;

    public GrizzlyHttpClient(HttpClientConfiguration config) {
        this.tlsContextFactory = config.getTlsContextFactory();
        this.proxyConfig = config.getProxyConfig();
        this.clientSocketProperties = config.getClientSocketProperties();
        this.maxConnections = config.getMaxConnections();
        this.usePersistentConnections = config.isUsePersistentConnections();
        this.connectionIdleTimeout = config.getConnectionIdleTimeout();
        this.streaming = config.isStreaming();
        this.responseBufferSize = config.getResponseBufferSize();
        this.threadNamePrefix = config.getThreadNamePrefix();
        this.ownerName = config.getOwnerName();
        this.kernelCoreSize = config.getKernelCoreSize();
        this.maxKernelCoreSize = config.getMaxKernelPoolSize();
        this.workerCoreSize = config.getWorkerCoreSize();
        this.maxWorkerCoreSize = config.getMaxWorkerPoolSize();
        this.selectorRunnerCoreSize = config.getSelectorRunnersCount();
    }

    public void start() throws MuleException {
        AsyncHttpClientConfig.Builder builder = new AsyncHttpClientConfig.Builder();
        builder.setAllowPoolingConnections(true);
        this.configureTransport(builder);
        this.configureTlsContext(builder);
        this.configureProxy(builder);
        this.configureConnections(builder);
        AsyncHttpClientConfig config = builder.build();
        this.asyncHttpClient = new AsyncHttpClient((AsyncHttpProvider)new GrizzlyAsyncHttpProvider(config), config);
    }

    private void configureTlsContext(AsyncHttpClientConfig.Builder builder) throws MuleException {
        if (this.tlsContextFactory != null) {
            TlsContextTrustStoreConfiguration trustStoreConfiguration;
            LifecycleUtils.initialiseIfNeeded((Object)this.tlsContextFactory);
            try {
                this.sslContext = this.tlsContextFactory.createSslContext();
            }
            catch (Exception e) {
                throw new DefaultMuleException(MessageFactory.createStaticMessage((String)"Cannot initialize SSL context"), (Throwable)e);
            }
            builder.setSSLContext(this.sslContext);
            if (this.tlsContextFactory.getEnabledCipherSuites() != null) {
                builder.setEnabledCipherSuites(this.tlsContextFactory.getEnabledCipherSuites());
            }
            if (this.tlsContextFactory.getEnabledProtocols() != null) {
                builder.setEnabledProtocols(this.tlsContextFactory.getEnabledProtocols());
            }
            if ((trustStoreConfiguration = this.tlsContextFactory.getTrustStoreConfiguration()) != null && trustStoreConfiguration.isInsecure()) {
                logger.warn(String.format("TLS configuration for requester %s has been set to use an insecure trust store. This means no certificate validations will be performed, rendering connections vulnerable to attacks. Use at own risk.", this.ownerName));
                builder.setAcceptAnyCertificate(true);
            }
        }
    }

    private void configureProxy(AsyncHttpClientConfig.Builder builder) {
        if (this.proxyConfig != null) {
            this.doConfigureProxy(builder, this.proxyConfig);
        }
    }

    protected void doConfigureProxy(AsyncHttpClientConfig.Builder builder, ProxyConfig proxyConfig) {
        builder.setProxyServer(this.buildProxy(proxyConfig));
    }

    protected final ProxyServer buildProxy(ProxyConfig proxyConfig) {
        ProxyServer proxyServer;
        if (!StringUtils.isEmpty((String)proxyConfig.getUsername())) {
            proxyServer = new ProxyServer(proxyConfig.getHost(), proxyConfig.getPort(), proxyConfig.getUsername(), proxyConfig.getPassword());
            if (proxyConfig instanceof NtlmProxyConfig) {
                proxyServer.setNtlmDomain(((NtlmProxyConfig)proxyConfig).getNtlmDomain());
                try {
                    proxyServer.setNtlmHost(this.getHostName());
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                proxyServer.setScheme(Realm.AuthScheme.NTLM);
            }
        } else {
            proxyServer = new ProxyServer(proxyConfig.getHost(), proxyConfig.getPort());
        }
        if (proxyConfig.getNonProxyHosts() != null && !proxyConfig.getNonProxyHosts().isEmpty()) {
            for (String host : proxyConfig.getNonProxyHosts().split(HOST_SEPARATOR)) {
                proxyServer.addNonProxyHost(host.trim());
            }
        }
        return proxyServer;
    }

    private void configureTransport(AsyncHttpClientConfig.Builder builder) {
        GrizzlyAsyncHttpProviderConfig providerConfig = new GrizzlyAsyncHttpProviderConfig();
        CompositeTransportCustomizer compositeTransportCustomizer = new CompositeTransportCustomizer();
        compositeTransportCustomizer.addTransportCustomizer(new IOStrategyTransportCustomizer(this.threadNamePrefix, this.maxWorkerCoreSize, this.workerCoreSize, this.maxKernelCoreSize, this.kernelCoreSize, this.selectorRunnerCoreSize));
        compositeTransportCustomizer.addTransportCustomizer(new LoggerTransportCustomizer());
        if (System.getProperty(HttpConstants.HttpProperties.GRIZZLY_MEMORY_MANAGER_SYSTEM_PROPERTY) == null) {
            compositeTransportCustomizer.addTransportCustomizer(new MemoryManagerTransportCustomizer());
        }
        if (this.clientSocketProperties != null) {
            compositeTransportCustomizer.addTransportCustomizer(new SocketConfigTransportCustomizer(this.clientSocketProperties));
            builder.setConnectTimeout(this.clientSocketProperties.getConnectionTimeout().intValue());
        }
        providerConfig.addProperty(GrizzlyAsyncHttpProviderConfig.Property.TRANSPORT_CUSTOMIZER, (Object)compositeTransportCustomizer);
        providerConfig.addProperty(GrizzlyAsyncHttpProviderConfig.Property.DECOMPRESS_RESPONSE, (Object)Boolean.FALSE);
        providerConfig.addProperty(GrizzlyAsyncHttpProviderConfig.Property.MAX_HTTP_PACKET_HEADER_SIZE, (Object)this.retrieveMaximumHeaderSectionSize());
        builder.setAsyncHttpClientProviderConfig((AsyncHttpProviderConfig)providerConfig);
    }

    private void configureConnections(AsyncHttpClientConfig.Builder builder) throws InitialisationException {
        if (this.maxConnections > 0) {
            builder.addRequestFilter((RequestFilter)new CustomTimeoutThrottleRequestFilter(this.maxConnections));
        }
        builder.setMaxConnections(this.maxConnections);
        builder.setMaxConnectionsPerHost(this.maxConnections);
        builder.setAllowPoolingConnections(this.usePersistentConnections);
        builder.setAllowPoolingSslConnections(this.usePersistentConnections);
        builder.setConnectionTTL(1800000);
        builder.setPooledConnectionIdleTimeout(this.connectionIdleTimeout);
        builder.setIOThreadMultiplier(1);
    }

    @Override
    public HttpResponse send(HttpRequest request, int responseTimeout, boolean followRedirects, HttpRequestAuthentication authentication) throws IOException, TimeoutException {
        if (this.streaming) {
            return this.sendAndDefer(request, responseTimeout, followRedirects, authentication);
        }
        return this.sendAndWait(request, responseTimeout, followRedirects, authentication);
    }

    public HttpResponse sendAndDefer(HttpRequest request, int responseTimeout, boolean followRedirects, HttpRequestAuthentication authentication) throws IOException, TimeoutException {
        Request grizzlyRequest = this.createGrizzlyRequest(request, responseTimeout, followRedirects, authentication);
        PipedOutputStream outPipe = new PipedOutputStream();
        PipedInputStream inPipe = new PipedInputStream(outPipe, this.responseBufferSize);
        BodyDeferringAsyncHandler asyncHandler = new BodyDeferringAsyncHandler((OutputStream)outPipe);
        this.asyncHttpClient.executeRequest(grizzlyRequest, (AsyncHandler)asyncHandler);
        try {
            Response response = asyncHandler.getResponse();
            return this.createMuleResponse(response, inPipe);
        }
        catch (IOException e) {
            if (e.getCause() instanceof TimeoutException) {
                throw (TimeoutException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public HttpResponse sendAndWait(HttpRequest request, int responseTimeout, boolean followRedirects, HttpRequestAuthentication authentication) throws IOException, TimeoutException {
        Request grizzlyRequest = this.createGrizzlyRequest(request, responseTimeout, followRedirects, authentication);
        ListenableFuture future = this.asyncHttpClient.executeRequest(grizzlyRequest);
        try {
            Response response = (Response)future.get();
            if (response == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Null response returned by async client");
                }
                response = (Response)future.get();
            }
            return this.createMuleResponse(response, response.getResponseBodyAsStream());
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof TimeoutException) {
                throw (TimeoutException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
    }

    @Override
    public void send(HttpRequest request, int responseTimeout, boolean followRedirects, HttpRequestAuthentication authentication, CompletionHandler<HttpResponse, Exception> completionHandler, WorkManager workManager) {
        try {
            Object handler = this.streaming ? new WorkManagerBodyDeferringAsyncHandler(completionHandler, workManager, new PipedOutputStream()) : new WorkManagerAsyncCompletionHandler(completionHandler, workManager);
            this.asyncHttpClient.executeRequest(this.createGrizzlyRequest(request, responseTimeout, followRedirects, authentication), (AsyncHandler)handler);
        }
        catch (Exception e) {
            completionHandler.onFailure((Throwable)e);
        }
    }

    private HttpResponse createMuleResponse(Response response, InputStream inputStream) throws IOException {
        HttpResponseBuilder responseBuilder = new HttpResponseBuilder();
        responseBuilder.setStatusCode(response.getStatusCode());
        responseBuilder.setReasonPhrase(response.getStatusText());
        responseBuilder.setEntity(new InputStreamHttpEntity(inputStream));
        if (response.hasResponseHeaders()) {
            for (String header : response.getHeaders().keySet()) {
                for (String headerValue : response.getHeaders(header)) {
                    responseBuilder.addHeader(header, headerValue);
                }
            }
        }
        return responseBuilder.build();
    }

    private Request createGrizzlyRequest(final HttpRequest request, final int responseTimeout, final boolean followRedirects, final HttpRequestAuthentication authentication) throws IOException {
        RequestBuilder builder = this.createRequestBuilder(request, new RequestConfigurer(){

            @Override
            public void configure(RequestBuilder builder) throws IOException {
                builder.setMethod(request.getMethod());
                builder.setFollowRedirects(followRedirects);
                GrizzlyHttpClient.this.populateHeaders(request, builder);
                DefaultHttpRequest defaultHttpRequest = (DefaultHttpRequest)request;
                for (String queryParamName : defaultHttpRequest.getQueryParams().keySet()) {
                    for (String queryParamValue : defaultHttpRequest.getQueryParams().getAll(queryParamName)) {
                        builder.addQueryParam(queryParamName, queryParamValue);
                    }
                }
                if (authentication != null) {
                    Realm.RealmBuilder realmBuilder = new Realm.RealmBuilder().setPrincipal(authentication.getUsername()).setPassword(authentication.getPassword()).setUsePreemptiveAuth(authentication.isPreemptive());
                    if (authentication.getType() == HttpAuthenticationType.BASIC) {
                        realmBuilder.setScheme(Realm.AuthScheme.BASIC);
                    } else if (authentication.getType() == HttpAuthenticationType.DIGEST) {
                        realmBuilder.setScheme(Realm.AuthScheme.DIGEST);
                    } else if (authentication.getType() == HttpAuthenticationType.NTLM) {
                        String workstation;
                        String domain = authentication.getDomain();
                        if (domain != null) {
                            realmBuilder.setNtlmDomain(domain);
                        }
                        String ntlmHost = (workstation = authentication.getWorkstation()) != null ? workstation : GrizzlyHttpClient.this.getHostName();
                        realmBuilder.setNtlmHost(ntlmHost).setScheme(Realm.AuthScheme.NTLM);
                    }
                    builder.setRealm(realmBuilder.build());
                }
                if (request.getEntity() != null) {
                    if (request.getEntity() instanceof InputStreamHttpEntity) {
                        builder.setBody((BodyGenerator)new InputStreamBodyGenerator(((InputStreamHttpEntity)request.getEntity()).getInputStream()));
                    } else if (request.getEntity() instanceof ByteArrayHttpEntity) {
                        builder.setBody(((ByteArrayHttpEntity)request.getEntity()).getContent());
                    } else if (request.getEntity() instanceof MultipartHttpEntity) {
                        MultipartHttpEntity multipartHttpEntity = (MultipartHttpEntity)request.getEntity();
                        for (HttpPart part : multipartHttpEntity.getParts()) {
                            String encoding = null;
                            String contentId = null;
                            for (String headerName : part.getHeaderNames()) {
                                if (headerName.toLowerCase().equals("Content-Transfer-Encoding".toLowerCase())) {
                                    encoding = part.getHeader(headerName);
                                    continue;
                                }
                                if (!headerName.toLowerCase().equals("Content-Id".toLowerCase())) continue;
                                contentId = part.getHeader(headerName);
                            }
                            byte[] content = IOUtils.toByteArray((InputStream)part.getInputStream());
                            ByteArrayPart byteArrayPart = new ByteArrayPart(part.getName(), content, part.getContentType(), null, part.getFileName(), contentId, encoding);
                            for (String headerName : part.getHeaderNames()) {
                                if (!SPECIAL_CUSTOM_HEADERS.contains(headerName.toLowerCase())) {
                                    byteArrayPart.addCustomHeader(headerName + ": ", part.getHeader(headerName));
                                    continue;
                                }
                                if (headerName.toLowerCase().equals("Content-Disposition".toLowerCase())) {
                                    byteArrayPart.setCustomContentDisposition(part.getHeader(headerName));
                                    continue;
                                }
                                if (!headerName.toLowerCase().equals("Content-Type".toLowerCase())) continue;
                                byteArrayPart.setCustomContentType(part.getHeader(headerName));
                            }
                            builder.addBodyPart((Part)byteArrayPart);
                        }
                    }
                }
                builder.setRequestTimeout(responseTimeout);
            }
        });
        builder.setUrl(request.getUri());
        return builder.build();
    }

    protected RequestBuilder createRequestBuilder(HttpRequest request, RequestConfigurer requestConfigurer) throws IOException {
        RequestBuilder requestBuilder = new RequestBuilder();
        requestConfigurer.configure(requestBuilder);
        return requestBuilder;
    }

    protected void populateHeaders(HttpRequest request, RequestBuilder builder) {
        for (String headerName : request.getHeaderNames()) {
            for (String headerValue : request.getHeaderValues(headerName)) {
                builder.addHeader(headerName, headerValue);
            }
        }
        if (!this.usePersistentConnections) {
            String connectionHeaderValue = request.getHeaderValueIgnoreCase("Connection");
            if (connectionHeaderValue != null && !"close".equals(connectionHeaderValue) && logger.isDebugEnabled()) {
                logger.debug("Persistent connections are disabled in the HTTP requester configuration, but the request already contains a Connection header with value {}. This header will be ignored, and a Connection: close header will be sent instead.", (Object)connectionHeaderValue);
            }
            builder.setHeader("Connection", "close");
        }
    }

    private String getHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    protected ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public void stop() {
        this.asyncHttpClient.close();
    }

    @Override
    public InputStream sendAndReceiveInputStream(HttpRequest request, int responseTimeout, boolean followRedirects, HttpRequestAuthentication authentication) throws IOException, TimeoutException {
        Request grizzlyRequest = this.createGrizzlyRequest(request, responseTimeout, followRedirects, authentication);
        ListenableFuture future = this.asyncHttpClient.executeRequest(grizzlyRequest);
        try {
            Response response = (Response)future.get();
            if (response == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Null response returned by async client");
                }
                response = (Response)future.get();
            }
            return response.getResponseBodyAsStream();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof TimeoutException) {
                throw (TimeoutException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
    }

    private int retrieveMaximumHeaderSectionSize() {
        try {
            return Integer.valueOf(System.getProperty(CUSTOM_MAX_HTTP_PACKET_HEADER_SIZE, String.valueOf(8192)));
        }
        catch (NumberFormatException e) {
            throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)String.format("Invalid value %s for %s configuration.", System.getProperty(CUSTOM_MAX_HTTP_PACKET_HEADER_SIZE), CUSTOM_MAX_HTTP_PACKET_HEADER_SIZE)), (Throwable)e);
        }
    }

    private class WorkManagerBodyDeferringAsyncHandler
    implements AsyncHandler<Response> {
        private volatile Response response;
        private final OutputStream output;
        private final InputStream input;
        private final WorkManager workManager;
        private final CompletionHandler<HttpResponse, Exception> completionHandler;
        private final Response.ResponseBuilder responseBuilder = new Response.ResponseBuilder();
        private final AtomicBoolean handled = new AtomicBoolean(false);

        public WorkManagerBodyDeferringAsyncHandler(CompletionHandler<HttpResponse, Exception> completionHandler, WorkManager workManager, PipedOutputStream output) throws IOException {
            this.output = output;
            this.workManager = workManager;
            this.completionHandler = completionHandler;
            this.input = new PipedInputStream(output, GrizzlyHttpClient.this.responseBufferSize);
        }

        public void onThrowable(final Throwable t) {
            try {
                this.closeOut();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!this.handled.getAndSet(true)) {
                this.workManager.execute(new Runnable(){

                    @Override
                    public void run() {
                        WorkManagerBodyDeferringAsyncHandler.this.completionHandler.onFailure((Throwable)((Exception)t));
                    }
                });
            }
        }

        public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
            this.responseBuilder.reset();
            this.responseBuilder.accumulate(responseStatus);
            return AsyncHandler.STATE.CONTINUE;
        }

        public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
            this.responseBuilder.accumulate(headers);
            return AsyncHandler.STATE.CONTINUE;
        }

        public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
            this.handleIfNecessary();
            bodyPart.writeTo(this.output);
            return AsyncHandler.STATE.CONTINUE;
        }

        protected void closeOut() throws IOException {
            try {
                this.output.flush();
            }
            finally {
                this.output.close();
            }
        }

        public Response onCompleted() throws IOException {
            this.handleIfNecessary();
            this.closeOut();
            return null;
        }

        private void handleIfNecessary() {
            if (!this.handled.getAndSet(true)) {
                this.response = this.responseBuilder.build();
                this.workManager.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            WorkManagerBodyDeferringAsyncHandler.this.completionHandler.onCompletion((Object)GrizzlyHttpClient.this.createMuleResponse(WorkManagerBodyDeferringAsyncHandler.this.response, WorkManagerBodyDeferringAsyncHandler.this.input));
                        }
                        catch (IOException e) {
                            WorkManagerBodyDeferringAsyncHandler.this.completionHandler.onFailure((Throwable)e);
                        }
                    }
                });
            }
        }
    }

    private class WorkManagerAsyncCompletionHandler
    extends AsyncCompletionHandler<Response> {
        private CompletionHandler<HttpResponse, Exception> completionHandler;
        private WorkManager workManager;

        WorkManagerAsyncCompletionHandler(CompletionHandler<HttpResponse, Exception> completionHandler, WorkManager workManager) {
            this.completionHandler = completionHandler;
            this.workManager = workManager;
        }

        public Response onCompleted(final Response response) throws Exception {
            this.workManager.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        WorkManagerAsyncCompletionHandler.this.completionHandler.onCompletion((Object)GrizzlyHttpClient.this.createMuleResponse(response, response.getResponseBodyAsStream()));
                    }
                    catch (IOException e) {
                        WorkManagerAsyncCompletionHandler.this.completionHandler.onFailure((Throwable)e);
                    }
                }
            });
            return null;
        }

        public void onThrowable(final Throwable t) {
            this.workManager.execute(new Runnable(){

                @Override
                public void run() {
                    WorkManagerAsyncCompletionHandler.this.completionHandler.onFailure((Throwable)((Exception)t));
                }
            });
        }
    }

    protected static interface RequestConfigurer {
        public void configure(RequestBuilder var1) throws IOException;
    }
}

