/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.Arrays;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.commons.lang.SerializationUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transformer.simple.ObjectToByteArray;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transformer.types.SimpleDataType;
import org.mule.util.StringDataSource;
import org.mule.util.store.DeserializationPostInitialisable;

public class DefaultMuleMessageSerializationTestCase
extends AbstractMuleContextTestCase {
    private static final String INNER_TEST_MESSAGE = "TestTestTestHello";

    @Test
    public void testSerializablePayload() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        message.setOutboundProperty("foo", (Object)"bar");
        MuleMessage deserializedMessage = this.serializationRoundtrip((MuleMessage)message);
        Assert.assertEquals((Object)"Test Message", (Object)deserializedMessage.getPayload());
        Assert.assertEquals((Object)"bar", (Object)deserializedMessage.getOutboundProperty("foo"));
    }

    @Test
    public void testNonSerializablePayload() throws Exception {
        muleContext.getRegistry().registerTransformer((Transformer)new NonSerializableToByteArray());
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new NonSerializable(), muleContext);
        message.setOutboundProperty("foo", (Object)"bar");
        MuleMessage deserializedMessage = this.serializationRoundtrip((MuleMessage)message);
        Assert.assertTrue((boolean)(deserializedMessage.getPayload() instanceof byte[]));
        Assert.assertEquals((Object)INNER_TEST_MESSAGE, (Object)deserializedMessage.getPayloadAsString());
    }

    @Test
    public void testStreamPayloadSerialization() throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream("Test Message".getBytes());
        DefaultMuleMessage message = new DefaultMuleMessage((Object)stream, muleContext);
        message.setOutboundProperty("foo", (Object)"bar");
        MuleMessage deserializedMessage = this.serializationRoundtrip((MuleMessage)message);
        Assert.assertEquals(byte[].class, deserializedMessage.getPayload().getClass());
        byte[] payload = (byte[])deserializedMessage.getPayload();
        Assert.assertTrue((boolean)Arrays.equals("Test Message".getBytes(), payload));
    }

    @Test
    @Ignore(value="see MULE-2964")
    public void testAttachments() throws Exception {
        String attachmentName = "the-attachment";
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        DataHandler dataHandler = new DataHandler((DataSource)new StringDataSource("attachment content"));
        message.addAttachment(attachmentName, dataHandler);
        MuleMessage deserializedMessage = this.serializationRoundtrip((MuleMessage)message);
        Assert.assertEquals((long)1L, (long)deserializedMessage.getAttachmentNames().size());
        Assert.assertTrue((boolean)deserializedMessage.getAttachmentNames().contains(attachmentName));
    }

    private MuleMessage serializationRoundtrip(MuleMessage message) throws Exception {
        byte[] serialized = SerializationUtils.serialize((Serializable)message);
        MuleMessage deserializedMessage = (MuleMessage)SerializationUtils.deserialize((byte[])serialized);
        DeserializationPostInitialisable.Implementation.init((Object)deserializedMessage, (MuleContext)muleContext);
        return deserializedMessage;
    }

    static class NonSerializableToByteArray
    extends ObjectToByteArray {
        public NonSerializableToByteArray() {
            this.registerSourceType((DataType)new SimpleDataType(NonSerializable.class));
            this.setReturnDataType(DataTypeFactory.BYTE_ARRAY);
        }

        public Object doTransform(Object src, String outputEncoding) throws TransformerException {
            String content = ((NonSerializable)src).getContent();
            return content.getBytes();
        }
    }

    static class NonSerializable {
        private String content = "TestTestTestHello";

        NonSerializable() {
        }

        String getContent() {
            return this.content;
        }
    }
}

