/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.schedule;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleContext;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.schedule.Scheduler;
import org.mule.api.schedule.SchedulerCreationException;
import org.mule.api.schedule.SchedulerFactory;
import org.mule.api.schedule.SchedulerFactoryPostProcessor;
import org.mule.tck.size.SmallTest;

@SmallTest
public class SchedulerFactoryTest {
    public static final String NAME = "test";
    private Scheduler mockScheduler = (Scheduler)Mockito.mock(Scheduler.class);
    private SchedulerFactoryPostProcessor postProcessor1 = (SchedulerFactoryPostProcessor)Mockito.mock(SchedulerFactoryPostProcessor.class);
    private MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
    private MuleRegistry muleRegistry = (MuleRegistry)Mockito.mock(MuleRegistry.class);
    private SchedulerFactoryPostProcessor postProcessor2 = (SchedulerFactoryPostProcessor)Mockito.mock(SchedulerFactoryPostProcessor.class);

    @Test(expected=SchedulerCreationException.class)
    public void checkCreationOfNullScheduler() {
        this.factory(null, null).create(NAME, this.newRunnable());
    }

    @Test(expected=SchedulerCreationException.class)
    public void postProcessMethodMustNeverReturnANullScheduler() {
        this.commonMockBehaviour(this.singlePostProcessor());
        this.factory(this.mockScheduler, this.muleContext).create(NAME, this.newRunnable());
    }

    @Test(expected=SchedulerCreationException.class)
    public void postProcessorMustNeverReturnANullScheduler() {
        this.commonMockBehaviour(this.postProcessors());
        SchedulerFactory<Runnable> factory = this.factory(this.mockScheduler, this.muleContext);
        try {
            factory.create(NAME, this.newRunnable());
        }
        finally {
            ((SchedulerFactoryPostProcessor)Mockito.verify((Object)this.postProcessor2, (VerificationMode)Mockito.never())).process(null, null);
            ((SchedulerFactoryPostProcessor)Mockito.verify((Object)this.postProcessor1, (VerificationMode)Mockito.never())).process(null, null);
        }
    }

    @Test
    public void muleContextIsNullThenAvoidPostProcessing() {
        this.commonMockBehaviour(this.postProcessors());
        Object job = new Object();
        SchedulerFactory<Runnable> factory = this.factory(this.mockScheduler, null);
        try {
            Assert.assertEquals((Object)this.mockScheduler, (Object)factory.create(NAME, this.newRunnable()));
        }
        finally {
            ((SchedulerFactoryPostProcessor)Mockito.verify((Object)this.postProcessor2, (VerificationMode)Mockito.never())).process(job, null);
            ((SchedulerFactoryPostProcessor)Mockito.verify((Object)this.postProcessor1, (VerificationMode)Mockito.never())).process(job, null);
        }
    }

    @Test
    public void createTheScheduler() {
        Runnable job = this.newRunnable();
        this.commonMockBehaviour(this.singlePostProcessor());
        Mockito.when((Object)this.postProcessor1.process((Object)job, this.mockScheduler)).thenReturn((Object)this.mockScheduler);
        Assert.assertEquals((Object)this.mockScheduler, (Object)this.factory(this.mockScheduler, this.muleContext).create(NAME, job));
    }

    private Map<String, SchedulerFactoryPostProcessor> postProcessors() {
        Map<String, SchedulerFactoryPostProcessor> registeredPostProcessors = this.singlePostProcessor();
        registeredPostProcessors.put("postProcessor2", this.postProcessor2);
        return registeredPostProcessors;
    }

    private void commonMockBehaviour(Map<String, SchedulerFactoryPostProcessor> registeredPostProcessors) {
        Mockito.when((Object)this.muleContext.getRegistry()).thenReturn((Object)this.muleRegistry);
        Mockito.when((Object)this.muleRegistry.lookupByType(SchedulerFactoryPostProcessor.class)).thenReturn(registeredPostProcessors);
    }

    private Map<String, SchedulerFactoryPostProcessor> singlePostProcessor() {
        HashMap<String, SchedulerFactoryPostProcessor> registeredPostProcessors = new HashMap<String, SchedulerFactoryPostProcessor>();
        registeredPostProcessors.put("postProcessor1", this.postProcessor1);
        return registeredPostProcessors;
    }

    private SchedulerFactory<Runnable> factory(Scheduler schedulerToReturn, MuleContext muleContext) {
        TestedSchedulerFactory factory = new TestedSchedulerFactory(schedulerToReturn);
        factory.setMuleContext(muleContext);
        return factory;
    }

    private Runnable newRunnable() {
        return new Runnable(){

            @Override
            public void run() {
            }
        };
    }

    private class TestedSchedulerFactory
    extends SchedulerFactory<Runnable> {
        private Scheduler schedulerToReturn;

        private TestedSchedulerFactory(Scheduler schedulerToReturn) {
            this.schedulerToReturn = schedulerToReturn;
        }

        protected Scheduler doCreate(String name, Runnable job) {
            return this.schedulerToReturn;
        }
    }
}

