/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.transport;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.transport.ExceptionHandlingReplyToHandlerDecorator;
import org.mule.api.transport.ReplyToHandler;
import org.mule.tck.SensingNullReplyToHandler;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class ExceptionHandlingReplyToHandlerDecoratorTestCase
extends AbstractMuleTestCase {
    @Mock
    private MessagingExceptionHandler messagingExceptionHandler;
    @Mock
    private MuleEvent sourceEvent;
    @Mock
    private MuleEvent handledEvent;

    @Test
    public void handleException() {
        SensingNullReplyToHandler sensingReplyToHandler = new SensingNullReplyToHandler();
        ExceptionHandlingReplyToHandlerDecorator errorHandlingreplyToHandler = new ExceptionHandlingReplyToHandlerDecorator((ReplyToHandler)sensingReplyToHandler, this.messagingExceptionHandler);
        MessagingException messagingException = new MessagingException(this.sourceEvent, (Throwable)new RuntimeException());
        Mockito.when((Object)this.messagingExceptionHandler.handleException((Exception)((Object)messagingException), this.sourceEvent)).thenAnswer((Answer)new Answer<MuleEvent>(){

            public MuleEvent answer(InvocationOnMock invocation) throws Throwable {
                return ExceptionHandlingReplyToHandlerDecoratorTestCase.this.handledEvent;
            }
        });
        errorHandlingreplyToHandler.processExceptionReplyTo(messagingException, null);
        ((MessagingExceptionHandler)Mockito.verify((Object)this.messagingExceptionHandler, (VerificationMode)Mockito.times((int)1))).handleException((Exception)((Object)messagingException), this.sourceEvent);
        Assert.assertThat((Object)sensingReplyToHandler.exception, (Matcher)CoreMatchers.equalTo((Object)((Object)messagingException)));
        Assert.assertThat((Object)((MessagingException)((Object)sensingReplyToHandler.exception)).getEvent(), (Matcher)CoreMatchers.equalTo((Object)this.handledEvent));
        Assert.assertThat((Object)sensingReplyToHandler.event, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void handleExceptionAndMarkHandled() {
        SensingNullReplyToHandler sensingReplyToHandler = new SensingNullReplyToHandler();
        ExceptionHandlingReplyToHandlerDecorator errorHandlingReplyToHandler = new ExceptionHandlingReplyToHandlerDecorator((ReplyToHandler)sensingReplyToHandler, this.messagingExceptionHandler);
        MessagingException messagingException = new MessagingException(this.sourceEvent, (Throwable)new RuntimeException());
        Mockito.when((Object)this.messagingExceptionHandler.handleException((Exception)((Object)messagingException), this.sourceEvent)).thenAnswer((Answer)new Answer<MuleEvent>(){

            public MuleEvent answer(InvocationOnMock invocation) throws Throwable {
                ((MessagingException)((Object)invocation.getArguments()[0])).setHandled(true);
                return ExceptionHandlingReplyToHandlerDecoratorTestCase.this.handledEvent;
            }
        });
        errorHandlingReplyToHandler.processExceptionReplyTo(messagingException, null);
        ((MessagingExceptionHandler)Mockito.verify((Object)this.messagingExceptionHandler, (VerificationMode)Mockito.times((int)1))).handleException((Exception)((Object)messagingException), this.sourceEvent);
        Assert.assertThat((Object)sensingReplyToHandler.exception, (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)sensingReplyToHandler.event, (Matcher)CoreMatchers.equalTo((Object)this.handledEvent));
    }
}

