/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.expression.RequiredValueException;
import org.mule.api.transport.PropertyScope;
import org.mule.expression.MessageHeadersExpressionEvaluator;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class MessageHeadersExpressionEvaluatorTestCase
extends AbstractMuleContextTestCase {
    private HashMap<String, Object> messageProperties;
    private MessageHeadersExpressionEvaluator evaluator = new MessageHeadersExpressionEvaluator();
    private MuleMessage message;

    public MessageHeadersExpressionEvaluatorTestCase() {
        this.setDisposeContextPerClass(true);
    }

    @Override
    public void doSetUp() {
        this.messageProperties = new HashMap(3);
        this.messageProperties.put("foo", "foovalue");
        this.messageProperties.put("bar", "barvalue");
        this.messageProperties.put("baz", "bazvalue");
        this.message = new DefaultMuleMessage((Object)"Test Message", this.messageProperties, muleContext);
    }

    @Test
    public void requiredHeadersWithExitingValueShouldReturnValue() {
        Object result = this.evaluator.evaluate("foo, baz", this.message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertTrue((boolean)map.values().contains("foovalue"));
        Assert.assertTrue((boolean)map.values().contains("bazvalue"));
        Assert.assertFalse((boolean)map.values().contains("barvalue"));
    }

    @Test
    public void requiredHeadersWithExistingValuesViaExpressionManagerShouldReturnValues() {
        Object result = muleContext.getExpressionManager().evaluate("#[headers:foo, baz]", this.message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertTrue((boolean)map.values().contains("foovalue"));
        Assert.assertTrue((boolean)map.values().contains("bazvalue"));
        Assert.assertFalse((boolean)map.values().contains("barvalue"));
    }

    @Test(expected=RequiredValueException.class)
    public void requiredHeadersWithMissingValuesShouldFail() {
        this.evaluator.evaluate("OUTBOUND:foo, baz, faz", this.message);
    }

    @Test(expected=RequiredValueException.class)
    public void requiredHeadersWithMissingValuesViaExpressionManagerShouldFail() {
        muleContext.getExpressionManager().evaluate("#[headers:nonexistent]", this.message);
    }

    @Test
    public void optionalHeadersWithExistingValuesShouldReturnValues() {
        Object result = this.evaluator.evaluate("foo?, baz", this.message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertTrue((boolean)map.values().contains("foovalue"));
        Assert.assertTrue((boolean)map.values().contains("bazvalue"));
        Assert.assertFalse((boolean)map.values().contains("barvalue"));
    }

    @Test
    public void optionalHeadersWithExistingValuesViaExpressionManagerShouldReturnValues() {
        Object result = muleContext.getExpressionManager().evaluate("#[headers:foo?, baz]", this.message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertTrue((boolean)map.values().contains("foovalue"));
        Assert.assertTrue((boolean)map.values().contains("bazvalue"));
        Assert.assertFalse((boolean)map.values().contains("barvalue"));
    }

    @Test
    public void optionalHeadersWithMissingValuesShouldReturnEmptyMap() {
        Object result = this.evaluator.evaluate("fool?", this.message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void optionalHeadersWithMissingValuesViaExpressionManagerShouldReturnEmptyMap() {
        Object result = muleContext.getExpressionManager().evaluate("#[headers:nonexistent?]", this.message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void requiredHeadersWithExplicitScopeShouldReturnValues() {
        Object result = this.evaluator.evaluate("OUTBOUND:foo, OUTBOUND:baz", this.message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertTrue((boolean)map.values().contains("foovalue"));
        Assert.assertTrue((boolean)map.values().contains("bazvalue"));
    }

    @Test
    public void propertyScopeSpecifiedForOneKeyShouldSetScopeForAllOtherKeys() {
        Object result = this.evaluator.evaluate("OUTBOUND:foo, baz", this.message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertTrue((boolean)map.values().contains("foovalue"));
        Assert.assertTrue((boolean)map.values().contains("bazvalue"));
    }

    @Test
    public void propertiesFromDifferentScopesWithValuesShouldReturnValues() {
        this.message.setProperty("faz", (Object)"fazvalue", PropertyScope.INVOCATION);
        Object result = this.evaluator.evaluate("OUTBOUND:foo, OUTBOUND:baz, INVOCATION:faz", this.message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertTrue((boolean)map.values().contains("foovalue"));
        Assert.assertTrue((boolean)map.values().contains("bazvalue"));
        Assert.assertTrue((boolean)map.values().contains("fazvalue"));
    }

    @Test
    public void matchAllWildcardShouldReturnAllHeaderValues() throws Exception {
        Object result = this.evaluator.evaluate("*", this.message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertTrue((boolean)map.values().contains("foovalue"));
        Assert.assertTrue((boolean)map.values().contains("bazvalue"));
        Assert.assertTrue((boolean)map.values().contains("barvalue"));
    }

    @Test
    public void matchAllWildcardViaExpressionManagerShouldReturnAllHeaderValues() {
        Object result = muleContext.getExpressionManager().evaluate("#[headers:*]", this.message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertTrue((boolean)map.values().contains("foovalue"));
        Assert.assertTrue((boolean)map.values().contains("bazvalue"));
        Assert.assertTrue((boolean)map.values().contains("barvalue"));
    }

    @Test
    public void matchBeginningWildcardShouldReturnValues() {
        Object result = this.evaluator.evaluate("ba*", this.message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertFalse((boolean)map.values().contains("foovalue"));
        Assert.assertTrue((boolean)map.values().contains("bazvalue"));
        Assert.assertTrue((boolean)map.values().contains("barvalue"));
    }

    @Test
    public void matchBeginningWildcardViaExpressionManagerShouldReturnValues() {
        Object result = muleContext.getExpressionManager().evaluate("#[headers:ba*]", this.message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertFalse((boolean)map.values().contains("foovalue"));
        Assert.assertTrue((boolean)map.values().contains("bazvalue"));
        Assert.assertTrue((boolean)map.values().contains("barvalue"));
    }

    @Test
    public void wildcardWithNoMatchShouldReturnEmptyMap() {
        Object result = this.evaluator.evaluate("x*", this.message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void wildcardWithnoMatchViaExpressionManagerShouldReturnEmptyMap() {
        Object result = muleContext.getExpressionManager().evaluate("#[headers:x*]", this.message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void multipleWildcardsShouldReturnValues() throws Exception {
        Object result = this.evaluator.evaluate("ba*, f*", this.message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertTrue((boolean)map.values().contains("foovalue"));
        Assert.assertTrue((boolean)map.values().contains("bazvalue"));
        Assert.assertTrue((boolean)map.values().contains("barvalue"));
    }

    @Test
    public void multipleWildcardsViaExpressionManagerShouldReturnValues() {
        Object result = muleContext.getExpressionManager().evaluate("#[headers:ba*, f*]", this.message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertTrue((boolean)map.values().contains("foovalue"));
        Assert.assertTrue((boolean)map.values().contains("bazvalue"));
        Assert.assertTrue((boolean)map.values().contains("barvalue"));
    }
}

