/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry;

import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.api.registry.ServiceRegistry;
import org.mule.registry.SpiServiceRegistry;
import org.mule.registry.TestDiscoverableObject;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class SpiServiceRegistryTestCase
extends AbstractMuleTestCase {
    private ServiceRegistry serviceRegistry = new SpiServiceRegistry();

    @Test
    public void lookupProviders() throws Exception {
        Collection discoveredObjects = this.serviceRegistry.lookupProviders(TestDiscoverableObject.class);
        this.assertProvidersFound(discoveredObjects);
    }

    @Test
    public void lookupProvidersWithCustomClassLoader() throws Exception {
        ClassLoader classLoader = (ClassLoader)Mockito.mock(ClassLoader.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.serviceRegistry.lookupProviders(TestDiscoverableObject.class, classLoader);
        ((ClassLoader)Mockito.verify((Object)classLoader)).getResources("META-INF/services/" + TestDiscoverableObject.class.getName());
    }

    private void assertProvidersFound(Collection<TestDiscoverableObject> discoveredObjects) {
        Assert.assertThat(discoveredObjects, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)discoveredObjects.iterator().next(), (Matcher)Matchers.instanceOf(TestDiscoverableObject.class));
    }
}

