/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.Serializable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.transformer.Converter;
import org.mule.api.transformer.Transformer;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.fruit.FruitBowl;
import org.mule.transformer.TransformerWeighting;
import org.mule.transformer.builder.MockConverterBuilder;
import org.mule.transformer.types.DataTypeFactory;

@SmallTest
public class TransformerWeightingTestCase
extends AbstractMuleTestCase {
    @Test
    public void testExactMatch() throws Exception {
        Converter trans = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(DataTypeFactory.create(IOException.class))).to(DataTypeFactory.BYTE_ARRAY)).build();
        TransformerWeighting weighting = new TransformerWeighting(IOException.class, byte[].class, (Transformer)trans);
        Assert.assertFalse((boolean)weighting.isNotMatch());
        Assert.assertTrue((boolean)weighting.isExactMatch());
    }

    @Test
    public void testNearMatch() throws Exception {
        Converter trans = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(DataTypeFactory.INPUT_STREAM)).to(DataTypeFactory.BYTE_ARRAY)).build();
        TransformerWeighting weighting = new TransformerWeighting(FilterInputStream.class, byte[].class, (Transformer)trans);
        Assert.assertFalse((boolean)weighting.isNotMatch());
        Assert.assertFalse((boolean)weighting.isExactMatch());
        Assert.assertEquals((long)1L, (long)weighting.getInputWeighting());
        Assert.assertEquals((long)0L, (long)weighting.getOutputWeighting());
    }

    @Test
    public void testNoMatchWeighting() throws Exception {
        Converter trans = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(DataTypeFactory.create(Serializable.class))).to(DataTypeFactory.BYTE_ARRAY)).build();
        TransformerWeighting weighting = new TransformerWeighting(FruitBowl.class, byte[].class, (Transformer)trans);
        Assert.assertTrue((boolean)weighting.isNotMatch());
        Assert.assertEquals((long)-1L, (long)weighting.getInputWeighting());
        Assert.assertEquals((long)0L, (long)weighting.getOutputWeighting());
    }

    @Test
    public void testCompareWeightingWithNearMatches() throws Exception {
        Converter trans1 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(DataTypeFactory.create(Serializable.class))).to(DataTypeFactory.BYTE_ARRAY)).build();
        Converter trans2 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(DataTypeFactory.create(Exception.class))).to(DataTypeFactory.BYTE_ARRAY)).build();
        TransformerWeighting weighting1 = new TransformerWeighting(IOException.class, byte[].class, (Transformer)trans1);
        TransformerWeighting weighting2 = new TransformerWeighting(IOException.class, byte[].class, (Transformer)trans2);
        Assert.assertFalse((boolean)weighting1.isNotMatch());
        Assert.assertFalse((boolean)weighting2.isNotMatch());
        Assert.assertFalse((boolean)weighting1.isExactMatch());
        Assert.assertFalse((boolean)weighting2.isExactMatch());
        Assert.assertEquals((long)1L, (long)weighting2.compareTo((Object)weighting1));
        Assert.assertEquals((long)3L, (long)weighting1.getInputWeighting());
        Assert.assertEquals((long)1L, (long)weighting2.getInputWeighting());
        Assert.assertEquals((long)0L, (long)weighting1.getOutputWeighting());
        Assert.assertEquals((long)0L, (long)weighting2.getOutputWeighting());
    }

    @Test
    public void testCompareWeightingWithExactMatch() throws Exception {
        Converter trans1 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(DataTypeFactory.create(Serializable.class))).to(DataTypeFactory.BYTE_ARRAY)).build();
        Converter trans2 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(DataTypeFactory.create(IOException.class))).to(DataTypeFactory.BYTE_ARRAY)).build();
        TransformerWeighting weighting1 = new TransformerWeighting(IOException.class, byte[].class, (Transformer)trans1);
        TransformerWeighting weighting2 = new TransformerWeighting(IOException.class, byte[].class, (Transformer)trans2);
        Assert.assertFalse((boolean)weighting1.isNotMatch());
        Assert.assertFalse((boolean)weighting2.isNotMatch());
        Assert.assertFalse((boolean)weighting1.isExactMatch());
        Assert.assertTrue((boolean)weighting2.isExactMatch());
        Assert.assertEquals((long)1L, (long)weighting2.compareTo((Object)weighting1));
        Assert.assertEquals((long)3L, (long)weighting1.getInputWeighting());
        Assert.assertEquals((long)0L, (long)weighting2.getInputWeighting());
        Assert.assertEquals((long)0L, (long)weighting1.getOutputWeighting());
        Assert.assertEquals((long)0L, (long)weighting2.getOutputWeighting());
    }

    @Test
    public void testOrderInNoMatchWhenDifferenceBetweenInputAndOutputWeightings() {
        Converter trans1 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(DataTypeFactory.create(IOException.class))).to(DataTypeFactory.create(IOException.class))).build();
        Converter trans2 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(DataTypeFactory.create(IOException.class))).to(DataTypeFactory.create(IOException.class))).build();
        TransformerWeighting weighting1 = new TransformerWeighting(byte[].class, IOException.class, (Transformer)trans1);
        TransformerWeighting weighting2 = new TransformerWeighting(IOException.class, byte[].class, (Transformer)trans2);
        MatcherAssert.assertThat((Object)weighting1.isNotMatch(), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)weighting2.isNotMatch(), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)weighting1.compareTo((Object)weighting2), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)weighting2.compareTo((Object)weighting1), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void testCompareWeightingWithNoMatch() throws Exception {
        Converter trans1 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(DataTypeFactory.create(Serializable.class))).to(DataTypeFactory.BYTE_ARRAY)).build();
        Converter trans2 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(DataTypeFactory.create(FruitBowl.class))).to(DataTypeFactory.BYTE_ARRAY)).build();
        TransformerWeighting weighting1 = new TransformerWeighting(IOException.class, byte[].class, (Transformer)trans1);
        TransformerWeighting weighting2 = new TransformerWeighting(IOException.class, byte[].class, (Transformer)trans2);
        Assert.assertFalse((boolean)weighting1.isNotMatch());
        Assert.assertTrue((boolean)weighting2.isNotMatch());
        Assert.assertFalse((boolean)weighting1.isExactMatch());
        Assert.assertFalse((boolean)weighting2.isExactMatch());
        Assert.assertEquals((long)-1L, (long)weighting2.compareTo((Object)weighting1));
        Assert.assertEquals((long)3L, (long)weighting1.getInputWeighting());
        Assert.assertEquals((long)-1L, (long)weighting2.getInputWeighting());
        Assert.assertEquals((long)0L, (long)weighting1.getOutputWeighting());
        Assert.assertEquals((long)0L, (long)weighting2.getOutputWeighting());
    }
}

