/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.util.UUID;

public class UUIDTestCase
extends AbstractMuleTestCase {
    @Test
    public void testGenerateUniqueAndIncrementalIds() throws Exception {
        HashSet<String> ids = new HashSet<String>();
        ArrayList<Object[]> idsWithIndexes = new ArrayList<Object[]>(1000);
        int numberOfIdsToGenerate = 10000;
        for (int index = 0; index < 10000; ++index) {
            String generatedId = UUID.getUUID();
            idsWithIndexes.add(new Object[]{generatedId, index});
            if (ids.contains(generatedId)) {
                Assert.fail((String)("REPEATED ID :" + index + ": " + generatedId));
                continue;
            }
            ids.add(generatedId);
        }
        Comparator<Object[]> comparatorById = new Comparator<Object[]>(){

            @Override
            public int compare(Object[] o1, Object[] o2) {
                return ((String)o1[0]).compareTo((String)o2[0]);
            }
        };
        Collections.sort(idsWithIndexes, comparatorById);
        for (int index = 0; index < 10000; ++index) {
            Assert.assertEquals((Object)index, (Object)((Object[])idsWithIndexes.get(index))[1]);
        }
    }

    @Test
    public void testUUUIDLength() throws Exception {
        String generatedId = UUID.getUUID();
        Assert.assertThat((Object)generatedId.length(), (Matcher)CoreMatchers.is((Object)36));
    }
}

