/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.util.queue.QueueFileProvider;
import org.mule.util.queue.RandomAccessFileQueueStore;

@SmallTest
public class RandomAccessFileQueueStoreTestCase
extends AbstractMuleTestCase {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void getLengthWithNoFileContent() {
        RandomAccessFileQueueStore randomAccessFileQueueStore = this.createRandomAccessFileQueueStore();
        Assert.assertThat((Object)randomAccessFileQueueStore.getLength(), (Matcher)Is.is((Object)0L));
    }

    @Test
    public void getLengthWithOneElement() {
        RandomAccessFileQueueStore randomAccessFileQueueStore = this.createRandomAccessFileQueueStore();
        long dataSize = 10L;
        randomAccessFileQueueStore.addLast(new byte[10]);
        Assert.assertThat((Object)randomAccessFileQueueStore.getLength(), (Matcher)Is.is((Object)15L));
    }

    @Test
    public void getLengthWithSeveralElements() {
        RandomAccessFileQueueStore randomAccessFileQueueStore = this.createRandomAccessFileQueueStore();
        long dataSize = 10L;
        byte[] data = new byte[10];
        int numberOfElements = 10;
        for (int i = 0; i < 10; ++i) {
            randomAccessFileQueueStore.addLast(data);
        }
        Assert.assertThat((Object)randomAccessFileQueueStore.getLength(), (Matcher)Is.is((Object)150L));
    }

    private RandomAccessFileQueueStore createRandomAccessFileQueueStore() {
        return new RandomAccessFileQueueStore(new QueueFileProvider(this.temporaryFolder.getRoot(), "datafile"));
    }
}

