/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.TreeSet;
import org.python.icu.impl.Grego;

public class JavaTimeZone
extends org.python.icu.util.TimeZone {
    private static final long serialVersionUID = 6977448185543929364L;
    private static final TreeSet<String> AVAILABLESET = new TreeSet();
    private TimeZone javatz;
    private transient Calendar javacal;
    private static Method mObservesDaylightTime;
    private volatile transient boolean isFrozen = false;

    public JavaTimeZone() {
        this(TimeZone.getDefault(), null);
    }

    public JavaTimeZone(TimeZone jtz, String id) {
        if (id == null) {
            id = jtz.getID();
        }
        this.javatz = jtz;
        this.setID(id);
        this.javacal = new GregorianCalendar(this.javatz);
    }

    public static JavaTimeZone createTimeZone(String id) {
        TimeZone jtz = null;
        if (AVAILABLESET.contains(id)) {
            jtz = TimeZone.getTimeZone(id);
        }
        if (jtz == null) {
            boolean[] isSystemID = new boolean[1];
            String canonicalID = org.python.icu.util.TimeZone.getCanonicalID(id, isSystemID);
            if (isSystemID[0] && AVAILABLESET.contains(canonicalID)) {
                jtz = TimeZone.getTimeZone(canonicalID);
            }
        }
        if (jtz == null) {
            return null;
        }
        return new JavaTimeZone(jtz, id);
    }

    public int getOffset(int era, int year, int month, int day, int dayOfWeek, int milliseconds) {
        return this.javatz.getOffset(era, year, month, day, dayOfWeek, milliseconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getOffset(long date, boolean local, int[] offsets) {
        Calendar calendar2 = this.javacal;
        synchronized (calendar2) {
            if (local) {
                int[] fields = new int[6];
                Grego.timeToFields(date, fields);
                int tmp = fields[5];
                int mil = tmp % 1000;
                int sec = (tmp /= 1000) % 60;
                int min = (tmp /= 60) % 60;
                int hour = tmp / 60;
                this.javacal.clear();
                this.javacal.set(fields[0], fields[1], fields[2], hour, min, sec);
                this.javacal.set(14, mil);
                int doy1 = this.javacal.get(6);
                int hour1 = this.javacal.get(11);
                int min1 = this.javacal.get(12);
                int sec1 = this.javacal.get(13);
                int mil1 = this.javacal.get(14);
                if (fields[4] != doy1 || hour != hour1 || min != min1 || sec != sec1 || mil != mil1) {
                    int dayDelta = Math.abs(doy1 - fields[4]) > 1 ? 1 : doy1 - fields[4];
                    int delta = (((dayDelta * 24 + hour1 - hour) * 60 + min1 - min) * 60 + sec1 - sec) * 1000 + mil1 - mil;
                    this.javacal.setTimeInMillis(this.javacal.getTimeInMillis() - (long)delta - 1L);
                }
            } else {
                this.javacal.setTimeInMillis(date);
            }
            offsets[0] = this.javacal.get(15);
            offsets[1] = this.javacal.get(16);
        }
    }

    public int getRawOffset() {
        return this.javatz.getRawOffset();
    }

    public boolean inDaylightTime(Date date) {
        return this.javatz.inDaylightTime(date);
    }

    public void setRawOffset(int offsetMillis) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify a frozen JavaTimeZone instance.");
        }
        this.javatz.setRawOffset(offsetMillis);
    }

    public boolean useDaylightTime() {
        return this.javatz.useDaylightTime();
    }

    public boolean observesDaylightTime() {
        if (mObservesDaylightTime != null) {
            try {
                return (Boolean)mObservesDaylightTime.invoke((Object)this.javatz, (Object[])null);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return super.observesDaylightTime();
    }

    public int getDSTSavings() {
        return this.javatz.getDSTSavings();
    }

    public TimeZone unwrap() {
        return this.javatz;
    }

    public Object clone() {
        if (this.isFrozen()) {
            return this;
        }
        return this.cloneAsThawed();
    }

    public int hashCode() {
        return super.hashCode() + this.javatz.hashCode();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.javacal = new GregorianCalendar(this.javatz);
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    public org.python.icu.util.TimeZone freeze() {
        this.isFrozen = true;
        return this;
    }

    public org.python.icu.util.TimeZone cloneAsThawed() {
        JavaTimeZone tz = (JavaTimeZone)super.cloneAsThawed();
        tz.javatz = (TimeZone)this.javatz.clone();
        tz.javacal = (GregorianCalendar)this.javacal.clone();
        tz.isFrozen = false;
        return tz;
    }

    static {
        String[] availableIds = TimeZone.getAvailableIDs();
        for (int i = 0; i < availableIds.length; ++i) {
            AVAILABLESET.add(availableIds[i]);
        }
        try {
            mObservesDaylightTime = TimeZone.class.getMethod("observesDaylightTime", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

