/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.module.db.internal.config.processor;

import org.mule.module.db.internal.domain.executor.UpdateExecutorFactory;
import org.mule.module.db.internal.metadata.DdlMetadataProvider;
import org.mule.module.db.internal.processor.ExecuteDdlMessageProcessor;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.w3c.dom.Element;

public class ExecuteDdlProcessorBeanDefinitionParser extends AbstractSingleQueryProcessorDefinitionParser
{

    @Override
    protected Class<?> getBeanClass(Element element)
    {
        return ExecuteDdlMessageProcessor.class;
    }

    @Override
    protected Object createExecutorFactory(Element element)
    {
        BeanDefinitionBuilder executorFactoryBean = BeanDefinitionBuilder.genericBeanDefinition(UpdateExecutorFactory.class);

        executorFactoryBean.addConstructorArgValue(parseStatementFactory(element));

        return executorFactoryBean.getBeanDefinition();
    }

    @Override
    protected Object getMetadataProvider()
    {
        BeanDefinitionBuilder metadataProviderBuilder = BeanDefinitionBuilder.genericBeanDefinition(DdlMetadataProvider.class);
        metadataProviderBuilder.addConstructorArgValue(dbConfigResolverFactoryBeanDefinition);
        metadataProviderBuilder.addConstructorArgValue(queryBean);
        metadataProviderBuilder.addConstructorArgValue(autoGeneratedKeyStrategy);

        return metadataProviderBuilder.getBeanDefinition();
    }
}