/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.imageio.spi.ServiceRegistry;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.mule.api.MuleRuntimeException;
import org.mule.config.PreferredObjectSelector;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.launcher.AppBloodhound;
import org.mule.module.launcher.MuleFoldersUtil;
import org.mule.module.launcher.artifact.ArtifactFactoryUtils;
import org.mule.module.launcher.descriptor.ApplicationDescriptor;
import org.mule.module.launcher.descriptor.DescriptorParser;
import org.mule.module.launcher.descriptor.EmptyApplicationDescriptor;
import org.mule.module.launcher.descriptor.PropertiesDescriptorParser;
import org.mule.module.launcher.plugin.PluginDescriptor;
import org.mule.module.launcher.plugin.PluginDescriptorParser;
import org.mule.util.FileUtils;
import org.mule.util.FilenameUtils;
import org.mule.util.PropertiesUtils;

public class DefaultAppBloodhound
implements AppBloodhound {
    public static final String MULE_WILDCARD_DEPLOY_FILE = "mule-deploy.*";
    protected Map<String, DescriptorParser> parserRegistry = new HashMap<String, DescriptorParser>();
    public static final String SYSTEM_PROPERTY_OVERRIDE = "-O";

    public DefaultAppBloodhound() {
        this.parserRegistry.put("properties", new PropertiesDescriptorParser());
        Iterator<DescriptorParser> it = ServiceRegistry.lookupProviders(DescriptorParser.class);
        MultiValueMap overrides = new MultiValueMap();
        while (it.hasNext()) {
            DescriptorParser parser = it.next();
            overrides.put((Object)parser.getSupportedFormat(), (Object)parser);
        }
        this.mergeParserOverrides((MultiMap)overrides);
    }

    @Override
    public ApplicationDescriptor fetch(String appName) throws IOException {
        ApplicationDescriptor desc;
        File appDir = MuleFoldersUtil.getAppFolder(appName);
        File descriptorFile = ArtifactFactoryUtils.getDeploymentFile(appDir, appName, MULE_WILDCARD_DEPLOY_FILE);
        if (descriptorFile == null) {
            desc = new EmptyApplicationDescriptor(appName);
        } else {
            String ext = FilenameUtils.getExtension((String)descriptorFile.getName());
            DescriptorParser descriptorParser = this.parserRegistry.get(ext);
            if (descriptorParser == null) {
                throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)String.format("Unsupported deployment descriptor format for app '%s': %s", appName, ext)));
            }
            desc = descriptorParser.parse(descriptorFile, appName);
            desc.setName(appName);
        }
        File appPropsFile = new File(appDir, "mule-app.properties");
        this.setApplicationProperties(desc, appPropsFile);
        Set<PluginDescriptor> plugins = new PluginDescriptorParser(desc, appDir).parse();
        desc.setPlugins(plugins);
        desc.setSharedPluginLibs(this.findSharedPluginLibs(appName));
        return desc;
    }

    private URL[] findSharedPluginLibs(String appName) throws MalformedURLException {
        HashSet<URL> urls = new HashSet<URL>();
        File sharedPluginLibs = MuleFoldersUtil.getAppSharedPluginLibsFolder(appName);
        if (sharedPluginLibs.exists()) {
            Collection jars = FileUtils.listFiles((File)sharedPluginLibs, (String[])new String[]{"jar"}, (boolean)false);
            for (File jar : jars) {
                urls.add(jar.toURI().toURL());
            }
        }
        return urls.toArray(new URL[0]);
    }

    public void setApplicationProperties(ApplicationDescriptor desc, File appPropsFile) throws IOException {
        HashMap<String, String> m = new HashMap<String, String>();
        if (appPropsFile.exists() && appPropsFile.canRead()) {
            Properties props = PropertiesUtils.loadProperties((URL)appPropsFile.toURI().toURL());
            for (Object key : props.keySet()) {
                m.put(key.toString(), props.getProperty(key.toString()));
            }
        }
        Properties sysProps = System.getProperties();
        for (Map.Entry<Object, Object> entry : sysProps.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(SYSTEM_PROPERTY_OVERRIDE)) continue;
            m.put(key.substring(SYSTEM_PROPERTY_OVERRIDE.length()), entry.getValue().toString());
        }
        desc.setAppProperties(m);
    }

    protected void mergeParserOverrides(MultiMap overrides) {
        PreferredObjectSelector selector = new PreferredObjectSelector();
        for (Map.Entry<String, DescriptorParser> entry : this.parserRegistry.entrySet()) {
            Collection candidates = (Collection)overrides.get((Object)entry.getKey());
            if (candidates == null) continue;
            this.parserRegistry.put(entry.getKey(), (DescriptorParser)selector.select(candidates.iterator()));
        }
    }
}

