/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.ChoiceFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;
import org.python.icu.impl.CurrencyData;
import org.python.icu.impl.ICUCache;
import org.python.icu.impl.ICUResourceBundle;
import org.python.icu.impl.SimpleCache;
import org.python.icu.text.NumberingSystem;
import org.python.icu.util.Currency;
import org.python.icu.util.ICUCloneNotSupportedException;
import org.python.icu.util.ULocale;
import org.python.icu.util.UResourceBundle;

public class DecimalFormatSymbols
implements Cloneable,
Serializable {
    public static final int CURRENCY_SPC_CURRENCY_MATCH = 0;
    public static final int CURRENCY_SPC_SURROUNDING_MATCH = 1;
    public static final int CURRENCY_SPC_INSERT = 2;
    private String[] currencySpcBeforeSym;
    private String[] currencySpcAfterSym;
    private char zeroDigit;
    private char[] digits;
    private char groupingSeparator;
    private char decimalSeparator;
    private char perMill;
    private char percent;
    private char digit;
    private char sigDigit;
    private char patternSeparator;
    private String infinity;
    private String NaN;
    private char minusSign;
    private String currencySymbol;
    private String intlCurrencySymbol;
    private char monetarySeparator;
    private char monetaryGroupingSeparator;
    private char exponential;
    private String exponentSeparator;
    private char padEscape;
    private char plusSign;
    private Locale requestedLocale;
    private ULocale ulocale;
    private String minusString = null;
    private String plusString = null;
    private String exponentMultiplicationSign = null;
    private static final long serialVersionUID = 5772796243397350300L;
    private static final int currentSerialVersion = 8;
    private int serialVersionOnStream = 8;
    private static final ICUCache<ULocale, String[][]> cachedLocaleData = new SimpleCache<ULocale, String[][]>();
    private String currencyPattern = null;
    private ULocale validLocale;
    private ULocale actualLocale;
    private transient Currency currency;

    public DecimalFormatSymbols() {
        this.initialize(ULocale.getDefault(ULocale.Category.FORMAT));
    }

    public DecimalFormatSymbols(Locale locale2) {
        this.initialize(ULocale.forLocale(locale2));
    }

    public DecimalFormatSymbols(ULocale locale2) {
        this.initialize(locale2);
    }

    public static DecimalFormatSymbols getInstance() {
        return new DecimalFormatSymbols();
    }

    public static DecimalFormatSymbols getInstance(Locale locale2) {
        return new DecimalFormatSymbols(locale2);
    }

    public static DecimalFormatSymbols getInstance(ULocale locale2) {
        return new DecimalFormatSymbols(locale2);
    }

    public static Locale[] getAvailableLocales() {
        return ICUResourceBundle.getAvailableLocales();
    }

    public static ULocale[] getAvailableULocales() {
        return ICUResourceBundle.getAvailableULocales();
    }

    public char getZeroDigit() {
        if (this.digits != null) {
            return this.digits[0];
        }
        return this.zeroDigit;
    }

    public char[] getDigits() {
        if (this.digits != null) {
            return (char[])this.digits.clone();
        }
        char[] digitArray = new char[10];
        for (int i = 0; i < 10; ++i) {
            digitArray[i] = (char)(this.zeroDigit + i);
        }
        return digitArray;
    }

    char[] getDigitsLocal() {
        if (this.digits != null) {
            return this.digits;
        }
        char[] digitArray = new char[10];
        for (int i = 0; i < 10; ++i) {
            digitArray[i] = (char)(this.zeroDigit + i);
        }
        return digitArray;
    }

    public void setZeroDigit(char zeroDigit) {
        if (this.digits != null) {
            this.digits[0] = zeroDigit;
            if (Character.digit(zeroDigit, 10) == 0) {
                for (int i = 1; i < 10; ++i) {
                    this.digits[i] = (char)(zeroDigit + i);
                }
            }
        } else {
            this.zeroDigit = zeroDigit;
        }
    }

    public char getSignificantDigit() {
        return this.sigDigit;
    }

    public void setSignificantDigit(char sigDigit) {
        this.sigDigit = sigDigit;
    }

    public char getGroupingSeparator() {
        return this.groupingSeparator;
    }

    public void setGroupingSeparator(char groupingSeparator) {
        this.groupingSeparator = groupingSeparator;
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public void setDecimalSeparator(char decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
    }

    public char getPerMill() {
        return this.perMill;
    }

    public void setPerMill(char perMill) {
        this.perMill = perMill;
    }

    public char getPercent() {
        return this.percent;
    }

    public void setPercent(char percent) {
        this.percent = percent;
    }

    public char getDigit() {
        return this.digit;
    }

    public void setDigit(char digit) {
        this.digit = digit;
    }

    public char getPatternSeparator() {
        return this.patternSeparator;
    }

    public void setPatternSeparator(char patternSeparator) {
        this.patternSeparator = patternSeparator;
    }

    public String getInfinity() {
        return this.infinity;
    }

    public void setInfinity(String infinity) {
        this.infinity = infinity;
    }

    public String getNaN() {
        return this.NaN;
    }

    public void setNaN(String NaN) {
        this.NaN = NaN;
    }

    public char getMinusSign() {
        return this.minusSign;
    }

    @Deprecated
    public String getMinusString() {
        return this.minusString;
    }

    public void setMinusSign(char minusSign) {
        this.minusSign = minusSign;
        char[] minusArray = new char[]{minusSign};
        this.minusString = new String(minusArray);
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currency) {
        this.currencySymbol = currency;
    }

    public String getInternationalCurrencySymbol() {
        return this.intlCurrencySymbol;
    }

    public void setInternationalCurrencySymbol(String currency) {
        this.intlCurrencySymbol = currency;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        if (currency == null) {
            throw new NullPointerException();
        }
        this.currency = currency;
        this.intlCurrencySymbol = currency.getCurrencyCode();
        this.currencySymbol = currency.getSymbol(this.requestedLocale);
    }

    public char getMonetaryDecimalSeparator() {
        return this.monetarySeparator;
    }

    public char getMonetaryGroupingSeparator() {
        return this.monetaryGroupingSeparator;
    }

    String getCurrencyPattern() {
        return this.currencyPattern;
    }

    public void setMonetaryDecimalSeparator(char sep) {
        this.monetarySeparator = sep;
    }

    public void setMonetaryGroupingSeparator(char sep) {
        this.monetaryGroupingSeparator = sep;
    }

    public String getExponentMultiplicationSign() {
        return this.exponentMultiplicationSign;
    }

    public void setExponentMultiplicationSign(String exponentMultiplicationSign) {
        this.exponentMultiplicationSign = exponentMultiplicationSign;
    }

    public String getExponentSeparator() {
        return this.exponentSeparator;
    }

    public void setExponentSeparator(String exp) {
        this.exponentSeparator = exp;
    }

    public char getPlusSign() {
        return this.plusSign;
    }

    @Deprecated
    public String getPlusString() {
        return this.plusString;
    }

    public void setPlusSign(char plus) {
        this.plusSign = plus;
        char[] plusArray = new char[]{this.plusSign};
        this.plusString = new String(plusArray);
    }

    public char getPadEscape() {
        return this.padEscape;
    }

    public void setPadEscape(char c) {
        this.padEscape = c;
    }

    public String getPatternForCurrencySpacing(int itemType, boolean beforeCurrency) {
        if (itemType < 0 || itemType > 2) {
            throw new IllegalArgumentException("unknown currency spacing: " + itemType);
        }
        if (beforeCurrency) {
            return this.currencySpcBeforeSym[itemType];
        }
        return this.currencySpcAfterSym[itemType];
    }

    public void setPatternForCurrencySpacing(int itemType, boolean beforeCurrency, String pattern) {
        if (itemType < 0 || itemType > 2) {
            throw new IllegalArgumentException("unknown currency spacing: " + itemType);
        }
        if (beforeCurrency) {
            this.currencySpcBeforeSym[itemType] = pattern;
        } else {
            this.currencySpcAfterSym[itemType] = pattern;
        }
    }

    public Locale getLocale() {
        return this.requestedLocale;
    }

    public ULocale getULocale() {
        return this.ulocale;
    }

    public Object clone() {
        try {
            return (DecimalFormatSymbols)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new ICUCloneNotSupportedException(e);
        }
    }

    public boolean equals(Object obj) {
        int i;
        if (!(obj instanceof DecimalFormatSymbols)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        DecimalFormatSymbols other = (DecimalFormatSymbols)obj;
        for (i = 0; i <= 2; ++i) {
            if (!this.currencySpcBeforeSym[i].equals(other.currencySpcBeforeSym[i])) {
                return false;
            }
            if (this.currencySpcAfterSym[i].equals(other.currencySpcAfterSym[i])) continue;
            return false;
        }
        if (other.digits == null) {
            for (i = 0; i < 10; ++i) {
                if (this.digits[i] == other.zeroDigit + i) continue;
                return false;
            }
        } else if (!Arrays.equals(this.digits, other.digits)) {
            return false;
        }
        return this.groupingSeparator == other.groupingSeparator && this.decimalSeparator == other.decimalSeparator && this.percent == other.percent && this.perMill == other.perMill && this.digit == other.digit && this.minusSign == other.minusSign && this.minusString.equals(other.minusString) && this.patternSeparator == other.patternSeparator && this.infinity.equals(other.infinity) && this.NaN.equals(other.NaN) && this.currencySymbol.equals(other.currencySymbol) && this.intlCurrencySymbol.equals(other.intlCurrencySymbol) && this.padEscape == other.padEscape && this.plusSign == other.plusSign && this.plusString.equals(other.plusString) && this.exponentSeparator.equals(other.exponentSeparator) && this.monetarySeparator == other.monetarySeparator && this.monetaryGroupingSeparator == other.monetaryGroupingSeparator && this.exponentMultiplicationSign.equals(other.exponentMultiplicationSign);
    }

    public int hashCode() {
        int result2 = this.digits[0];
        result2 = result2 * 37 + this.groupingSeparator;
        result2 = result2 * 37 + this.decimalSeparator;
        return result2;
    }

    private static boolean isBidiMark(char c) {
        return c == '\u200e' || c == '\u200f' || c == '\u061c';
    }

    private void initialize(ULocale locale2) {
        String nsName;
        this.requestedLocale = locale2.toLocale();
        this.ulocale = locale2;
        NumberingSystem ns = NumberingSystem.getInstance(locale2);
        this.digits = new char[10];
        if (ns != null && ns.getRadix() == 10 && !ns.isAlgorithmic() && NumberingSystem.isValidDigitString(ns.getDescription())) {
            String digitString = ns.getDescription();
            this.digits[0] = digitString.charAt(0);
            this.digits[1] = digitString.charAt(1);
            this.digits[2] = digitString.charAt(2);
            this.digits[3] = digitString.charAt(3);
            this.digits[4] = digitString.charAt(4);
            this.digits[5] = digitString.charAt(5);
            this.digits[6] = digitString.charAt(6);
            this.digits[7] = digitString.charAt(7);
            this.digits[8] = digitString.charAt(8);
            this.digits[9] = digitString.charAt(9);
            nsName = ns.getName();
        } else {
            this.digits[0] = 48;
            this.digits[1] = 49;
            this.digits[2] = 50;
            this.digits[3] = 51;
            this.digits[4] = 52;
            this.digits[5] = 53;
            this.digits[6] = 54;
            this.digits[7] = 55;
            this.digits[8] = 56;
            this.digits[9] = 57;
            nsName = "latn";
        }
        String[][] data = cachedLocaleData.get(locale2);
        if (data == null) {
            data = new String[1][];
            ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("org/python/icu/impl/data/icudt56b", locale2);
            boolean isLatn = nsName.equals("latn");
            String baseKey = "NumberElements/" + nsName + "/symbols/";
            String latnKey = "NumberElements/latn/symbols/";
            String[] symbolKeys = new String[]{"decimal", "group", "list", "percentSign", "minusSign", "plusSign", "exponential", "perMille", "infinity", "nan", "currencyDecimal", "currencyGroup", "superscriptingExponent"};
            String[] fallbackElements = new String[]{".", ",", ";", "%", "-", "+", "E", "\u2030", "\u221e", "NaN", null, null};
            String[] symbolsArray = new String[symbolKeys.length];
            for (int i = 0; i < symbolKeys.length; ++i) {
                try {
                    symbolsArray[i] = rb.getStringWithFallback(baseKey + symbolKeys[i]);
                    continue;
                }
                catch (MissingResourceException ex) {
                    if (!isLatn) {
                        try {
                            symbolsArray[i] = rb.getStringWithFallback(latnKey + symbolKeys[i]);
                        }
                        catch (MissingResourceException ex1) {
                            symbolsArray[i] = fallbackElements[i];
                        }
                        continue;
                    }
                    symbolsArray[i] = fallbackElements[i];
                }
            }
            data[0] = symbolsArray;
            cachedLocaleData.put(locale2, data);
        }
        String[] numberElements = data[0];
        ICUResourceBundle r = (ICUResourceBundle)UResourceBundle.getBundleInstance("org/python/icu/impl/data/icudt56b", locale2);
        ULocale uloc = r.getULocale();
        this.setLocale(uloc, uloc);
        this.decimalSeparator = numberElements[0].charAt(0);
        this.groupingSeparator = numberElements[1].charAt(0);
        this.patternSeparator = numberElements[2].charAt(0);
        this.percent = numberElements[3].charAt(0);
        this.minusString = numberElements[4];
        this.minusSign = this.minusString.length() > 1 && DecimalFormatSymbols.isBidiMark(this.minusString.charAt(0)) ? this.minusString.charAt(1) : this.minusString.charAt(0);
        this.plusString = numberElements[5];
        this.plusSign = this.plusString.length() > 1 && DecimalFormatSymbols.isBidiMark(this.plusString.charAt(0)) ? this.plusString.charAt(1) : this.plusString.charAt(0);
        this.exponentSeparator = numberElements[6];
        this.perMill = numberElements[7].charAt(0);
        this.infinity = numberElements[8];
        this.NaN = numberElements[9];
        this.monetarySeparator = numberElements[10] != null ? numberElements[10].charAt(0) : this.decimalSeparator;
        this.monetaryGroupingSeparator = numberElements[11] != null ? numberElements[11].charAt(0) : this.groupingSeparator;
        this.exponentMultiplicationSign = numberElements[12] != null ? numberElements[12] : "\u00d7";
        this.digit = (char)35;
        this.padEscape = (char)42;
        this.sigDigit = (char)64;
        CurrencyData.CurrencyDisplayInfo info = CurrencyData.provider.getInstance(locale2, true);
        String currname = null;
        this.currency = Currency.getInstance(locale2);
        if (this.currency != null) {
            this.intlCurrencySymbol = this.currency.getCurrencyCode();
            boolean[] isChoiceFormat = new boolean[1];
            currname = this.currency.getName(locale2, 0, isChoiceFormat);
            this.currencySymbol = isChoiceFormat[0] ? new ChoiceFormat(currname).format(2.0) : currname;
            CurrencyData.CurrencyFormatInfo fmtInfo = info.getFormatInfo(this.intlCurrencySymbol);
            if (fmtInfo != null) {
                this.currencyPattern = fmtInfo.currencyPattern;
                this.monetarySeparator = fmtInfo.monetarySeparator;
                this.monetaryGroupingSeparator = fmtInfo.monetaryGroupingSeparator;
            }
        } else {
            this.intlCurrencySymbol = "XXX";
            this.currencySymbol = "\u00a4";
        }
        this.currencySpcBeforeSym = new String[3];
        this.currencySpcAfterSym = new String[3];
        this.initSpacingInfo(info.getSpacingInfo());
    }

    private void initSpacingInfo(CurrencyData.CurrencySpacingInfo spcInfo) {
        this.currencySpcBeforeSym[0] = spcInfo.beforeCurrencyMatch;
        this.currencySpcBeforeSym[1] = spcInfo.beforeContextMatch;
        this.currencySpcBeforeSym[2] = spcInfo.beforeInsert;
        this.currencySpcAfterSym[0] = spcInfo.afterCurrencyMatch;
        this.currencySpcAfterSym[1] = spcInfo.afterContextMatch;
        this.currencySpcAfterSym[2] = spcInfo.afterInsert;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.monetarySeparator = this.decimalSeparator;
            this.exponential = (char)69;
        }
        if (this.serialVersionOnStream < 2) {
            this.padEscape = (char)42;
            this.plusSign = (char)43;
            this.exponentSeparator = String.valueOf(this.exponential);
        }
        if (this.serialVersionOnStream < 3) {
            this.requestedLocale = Locale.getDefault();
        }
        if (this.serialVersionOnStream < 4) {
            this.ulocale = ULocale.forLocale(this.requestedLocale);
        }
        if (this.serialVersionOnStream < 5) {
            this.monetaryGroupingSeparator = this.groupingSeparator;
        }
        if (this.serialVersionOnStream < 6) {
            if (this.currencySpcBeforeSym == null) {
                this.currencySpcBeforeSym = new String[3];
            }
            if (this.currencySpcAfterSym == null) {
                this.currencySpcAfterSym = new String[3];
            }
            this.initSpacingInfo(CurrencyData.CurrencySpacingInfo.DEFAULT);
        }
        if (this.serialVersionOnStream < 7) {
            if (this.minusString == null) {
                char[] minusArray = new char[]{this.minusSign};
                this.minusString = new String(minusArray);
            }
            if (this.plusString == null) {
                char[] plusArray = new char[]{this.plusSign};
                this.plusString = new String(plusArray);
            }
        }
        if (this.serialVersionOnStream < 8 && this.exponentMultiplicationSign == null) {
            this.exponentMultiplicationSign = "\u00d7";
        }
        this.serialVersionOnStream = 8;
        this.currency = Currency.getInstance(this.intlCurrencySymbol);
    }

    public final ULocale getLocale(ULocale.Type type) {
        return type == ULocale.ACTUAL_LOCALE ? this.actualLocale : this.validLocale;
    }

    final void setLocale(ULocale valid, ULocale actual) {
        if (valid == null != (actual == null)) {
            throw new IllegalArgumentException();
        }
        this.validLocale = valid;
        this.actualLocale = actual;
    }
}

