/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.jce;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;

public class SignatureDSA
implements com.jcraft.jsch.SignatureDSA {
    private Signature signature;
    private KeyFactory keyFactory;

    public void init() throws Exception {
        this.signature = Signature.getInstance("SHA1withDSA");
        this.keyFactory = KeyFactory.getInstance("DSA");
    }

    public void setPubKey(byte[] y, byte[] p, byte[] q, byte[] g) throws Exception {
        DSAPublicKeySpec dsaPubKeySpec = new DSAPublicKeySpec(new BigInteger(y), new BigInteger(p), new BigInteger(q), new BigInteger(g));
        PublicKey pubKey = this.keyFactory.generatePublic(dsaPubKeySpec);
        this.signature.initVerify(pubKey);
    }

    public void setPrvKey(byte[] x, byte[] p, byte[] q, byte[] g) throws Exception {
        DSAPrivateKeySpec dsaPrivKeySpec = new DSAPrivateKeySpec(new BigInteger(x), new BigInteger(p), new BigInteger(q), new BigInteger(g));
        PrivateKey prvKey = this.keyFactory.generatePrivate(dsaPrivKeySpec);
        this.signature.initSign(prvKey);
    }

    public byte[] sign() throws Exception {
        return this.fromASN1ToMPINT(this.signature.sign());
    }

    public void update(byte[] foo) throws Exception {
        this.signature.update(foo);
    }

    public boolean verify(byte[] sig) throws Exception {
        return this.signature.verify(this.fromMPINTtoASN1(sig));
    }

    byte[] fromASN1ToMPINT(byte[] sig) {
        byte[] r = this.computeMPINT(sig, 3);
        byte[] s = this.computeMPINT(sig, 4 + r.length + 1);
        byte[] result = new byte[40];
        System.arraycopy(r, r.length > 20 ? 1 : 0, result, r.length > 20 ? 0 : 20 - r.length, r.length > 20 ? 20 : r.length);
        System.arraycopy(s, s.length > 20 ? 1 : 0, result, s.length > 20 ? 20 : 40 - s.length, s.length > 20 ? 20 : s.length);
        return result;
    }

    private byte[] computeMPINT(byte[] sig, int index) {
        int len = sig[index] & 0xFF;
        byte[] result = new byte[len];
        System.arraycopy(sig, index + 1, result, 0, result.length);
        return result;
    }

    byte[] fromMPINTtoASN1(byte[] input) {
        byte[] tmp;
        byte[] sig = input;
        if (sig[0] == 0 && sig[1] == 0 && sig[2] == 0 && sig[3] == 7 && sig[4] == 115 && sig[5] == 115 && sig[6] == 104 && sig[7] == 45) {
            int i = 0;
            int j = 0;
            j = sig[i++] << 24 & 0xFF000000 | sig[i++] << 16 & 0xFF0000 | sig[i++] << 8 & 0xFF00 | sig[i++] & 0xFF;
            i += j;
            j = sig[i++] << 24 & 0xFF000000 | sig[i++] << 16 & 0xFF0000 | sig[i++] << 8 & 0xFF00 | sig[i++] & 0xFF;
            tmp = new byte[j];
            System.arraycopy(sig, i, tmp, 0, j);
            sig = tmp;
        }
        int lengthOfFrst = this.computeASN1Length(sig, 0);
        int lengthOfScnd = this.computeASN1Length(sig, 20);
        int lengthOfFrstMax20 = Math.min(lengthOfFrst, 20);
        int lengthOfScndMax20 = Math.min(lengthOfScnd, 20);
        int length = 6 + lengthOfFrst + lengthOfScnd;
        tmp = new byte[length];
        tmp[0] = 48;
        tmp[1] = (byte)(lengthOfFrst + lengthOfScnd + 4);
        tmp[2] = 2;
        tmp[3] = (byte)lengthOfFrst;
        System.arraycopy(sig, 20 - lengthOfFrstMax20, tmp, 4 + (lengthOfFrst > 20 ? 1 : 0), lengthOfFrstMax20);
        tmp[4 + tmp[3]] = 2;
        tmp[5 + tmp[3]] = (byte)lengthOfScnd;
        System.arraycopy(sig, 40 - lengthOfScndMax20, tmp, 6 + tmp[3] + (lengthOfScnd > 20 ? 1 : 0), lengthOfScndMax20);
        sig = tmp;
        return sig;
    }

    private int computeASN1Length(byte[] sig, int index) {
        int length = 20;
        if ((sig[index] & 0x80) != 0) {
            ++length;
        } else {
            while (sig[index + 20 - length] == 0 && (sig[index + 20 - length + 1] & 0x80) != 128) {
                --length;
            }
        }
        return length;
    }
}

