/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet.jetty;

import javax.servlet.http.HttpServletRequest;
import org.mule.DefaultMuleMessage;
import org.mule.api.transport.PropertyScope;
import org.mule.transport.servlet.ServletMuleMessageFactory;

public class JettyMuleMessageFactory
extends ServletMuleMessageFactory {
    protected void addProperties(DefaultMuleMessage message, Object transportMessage) throws Exception {
        super.addProperties(message, transportMessage);
        HttpServletRequest request = (HttpServletRequest)transportMessage;
        String requestUriWithoutParameters = request.getRequestURI();
        String queryString = request.getQueryString();
        String requestUriWithParameters = requestUriWithoutParameters;
        if (queryString != null) {
            requestUriWithParameters = requestUriWithParameters + "?" + queryString;
        }
        message.setProperty("http.request", (Object)requestUriWithParameters, PropertyScope.INBOUND);
        message.setProperty("http.request.path", (Object)requestUriWithoutParameters, PropertyScope.INBOUND);
        message.setProperty("MULE_REMOTE_CLIENT_ADDRESS", (Object)request.getRemoteAddr(), PropertyScope.INBOUND);
        message.setProperty("http.context.uri", (Object)request.getRequestURL().toString(), PropertyScope.INBOUND);
        message.setProperty("http.method", (Object)request.getMethod(), PropertyScope.INBOUND);
    }
}

