/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.api.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.raml.v2.api.loader.ResourceLoaderExtended;
import org.raml.v2.api.loader.ResourceUriCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootRamlFileResourceLoader
implements ResourceLoaderExtended {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private File parentPath;

    public RootRamlFileResourceLoader(File path) {
        this.parentPath = path;
    }

    @Override
    @Nullable
    public InputStream fetchResource(String resourceName, ResourceUriCallback callback) {
        FileInputStream inputStream = null;
        File includedFile = new File(this.parentPath, resourceName.startsWith("/") ? resourceName.substring(1) : resourceName);
        this.logger.debug("Looking for resource: {} on directory: {}...", (Object)resourceName, (Object)this.parentPath);
        try {
            inputStream = new FileInputStream(includedFile);
            if (callback != null) {
                callback.onResourceFound(includedFile.toURI());
            }
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        return inputStream;
    }

    @Override
    @Nullable
    public InputStream fetchResource(String resourceName) {
        return this.fetchResource(resourceName, null);
    }
}

