/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.zlib;

import com.jcraft.jzlib.Deflater;
import com.jcraft.jzlib.GZIPException;
import com.jcraft.jzlib.GZIPOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jcodings.specific.ASCIIEncoding;
import org.joda.time.DateTime;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.stringio.RubyStringIO;
import org.jruby.ext.stringio.StringIO;
import org.jruby.ext.zlib.RubyGzipFile;
import org.jruby.ext.zlib.RubyZlib;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.IOOutputStream;
import org.jruby.util.TypeConverter;
import org.jruby.util.encoding.Transcoder;

@JRubyClass(name={"Zlib::GzipWriter"}, parent="Zlib::GzipFile")
public class JZlibRubyGzipWriter
extends RubyGzipFile {
    protected static final ObjectAllocator GZIPWRITER_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new JZlibRubyGzipWriter(runtime, klass);
        }
    };
    private GZIPOutputStream io;

    @JRubyMethod(name={"new"}, rest=true, meta=true)
    public static JZlibRubyGzipWriter newInstance(IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyClass klass = (RubyClass)recv2;
        JZlibRubyGzipWriter result2 = (JZlibRubyGzipWriter)klass.allocate();
        result2.callInit(args2, block);
        return result2;
    }

    @JRubyMethod(name={"open"}, required=1, optional=2, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject open18(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime = recv2.getRuntime();
        args2[0] = Helpers.invoke(context, (IRubyObject)runtime.getFile(), "open", args2[0], (IRubyObject)runtime.newString("wb"));
        JZlibRubyGzipWriter gzio = JZlibRubyGzipWriter.newInstance(recv2, args2, block);
        return RubyGzipFile.wrapBlock(context, gzio, block);
    }

    @JRubyMethod(name={"open"}, required=1, optional=3, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject open19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime = recv2.getRuntime();
        args2[0] = Helpers.invoke(context, (IRubyObject)runtime.getFile(), "open", args2[0], (IRubyObject)runtime.newString("wb"));
        JZlibRubyGzipWriter gzio = JZlibRubyGzipWriter.newInstance(recv2, args2, block);
        return RubyGzipFile.wrapBlock(context, gzio, block);
    }

    public JZlibRubyGzipWriter(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    @JRubyMethod(name={"initialize"}, required=1, rest=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject initialize(IRubyObject[] args2) {
        Ruby runtime = this.getRuntime();
        this.level = this.processLevel(args2.length, args2, runtime);
        this.processStrategy(args2.length, args2);
        return this.initializeCommon(args2[0], this.level);
    }

    @JRubyMethod(name={"initialize"}, rest=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(ThreadContext context, IRubyObject[] args2, Block unused2) {
        Ruby runtime = context.getRuntime();
        IRubyObject opt = context.nil;
        int argc = args2.length;
        if (argc > 1 && !(opt = TypeConverter.checkHashType(runtime, opt)).isNil()) {
            --argc;
        }
        this.level = this.processLevel(argc, args2, runtime);
        this.processStrategy(argc, args2);
        this.initializeCommon(args2[0], this.level);
        this.ecopts(context, opt);
        return this;
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject path(ThreadContext context) {
        return this.realIo.callMethod(context, "path");
    }

    @JRubyMethod(name={"respond_to?"}, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject respond_to(ThreadContext context, IRubyObject name2) {
        if (name2.asJavaString().equals("path")) {
            return this.realIo.callMethod(context, "respond_to?", name2);
        }
        return Helpers.invokeSuper(context, (IRubyObject)this, name2, Block.NULL_BLOCK);
    }

    private int processStrategy(int argc, IRubyObject[] args2) {
        return argc < 3 ? 0 : RubyZlib.FIXNUMARG(args2[2], 0);
    }

    private int processLevel(int argc, IRubyObject[] args2, Ruby runtime) {
        int level2 = argc < 2 ? -1 : RubyZlib.FIXNUMARG(args2[1], -1);
        JZlibRubyGzipWriter.checkLevel(runtime, level2);
        return level2;
    }

    private IRubyObject initializeCommon(IRubyObject stream, int level2) {
        this.realIo = (RubyObject)stream;
        try {
            Deflater deflater = new Deflater(level2, 31, false);
            IOOutputStream ioOutputStream = new IOOutputStream(this.realIo, false, false){

                @Override
                public void write(byte[] bytes2, int off, int len) throws IOException {
                    byte[] bytesCopy = new byte[len];
                    System.arraycopy(bytes2, off, bytesCopy, 0, len);
                    super.write(bytesCopy, 0, len);
                }
            };
            this.io = new GZIPOutputStream((OutputStream)ioOutputStream, deflater, 512, false);
            return this;
        }
        catch (IOException ioe) {
            throw this.getRuntime().newIOErrorFromException(ioe);
        }
    }

    private static void checkLevel(Ruby runtime, int level2) {
        if (level2 != -1 && (level2 < 0 || level2 > 9)) {
            throw RubyZlib.newStreamError(runtime, "stream error: invalid level");
        }
    }

    @Override
    @JRubyMethod(name={"close"})
    public IRubyObject close() {
        if (!this.closed) {
            try {
                this.io.close();
                if (this.realIo.respondsTo("close")) {
                    this.realIo.callMethod(this.realIo.getRuntime().getCurrentContext(), "close");
                }
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
        }
        this.closed = true;
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"append", "<<"}, required=1)
    public IRubyObject append(IRubyObject p1) {
        this.write(p1);
        return this;
    }

    @JRubyMethod(name={"printf"}, required=1, rest=true)
    public IRubyObject printf(ThreadContext context, IRubyObject[] args2) {
        this.write(RubyKernel.sprintf(context, this, args2));
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"print"}, rest=true)
    public IRubyObject print(IRubyObject[] args2) {
        IRubyObject sep;
        if (args2.length != 0) {
            int j = args2.length;
            for (int i2 = 0; i2 < j; ++i2) {
                this.write(args2[i2]);
            }
        }
        if (!(sep = this.getRuntime().getGlobalVariables().get("$\\")).isNil()) {
            this.write(sep);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"pos", "tell"})
    public IRubyObject pos() {
        return RubyNumeric.int2fix(this.getRuntime(), this.io.getTotalIn());
    }

    @JRubyMethod(name={"orig_name="}, required=1)
    public IRubyObject set_orig_name(IRubyObject obj) {
        this.nullFreeOrigName = obj.convertToString();
        this.ensureNonNull(this.nullFreeOrigName);
        try {
            this.io.setName(this.nullFreeOrigName.toString());
        }
        catch (GZIPException e) {
            throw RubyZlib.newGzipFileError(this.getRuntime(), "header is already written");
        }
        return obj;
    }

    @JRubyMethod(name={"comment="}, required=1)
    public IRubyObject set_comment(IRubyObject obj) {
        this.nullFreeComment = obj.convertToString();
        this.ensureNonNull(this.nullFreeComment);
        try {
            this.io.setComment(this.nullFreeComment.toString());
        }
        catch (GZIPException e) {
            throw RubyZlib.newGzipFileError(this.getRuntime(), "header is already written");
        }
        return obj;
    }

    private void ensureNonNull(RubyString obj) {
        String str = obj.toString();
        if (str.indexOf(0) >= 0) {
            String trim = str.substring(0, str.toString().indexOf(0));
            obj.setValue(new ByteList(trim.getBytes()));
        }
    }

    @JRubyMethod(name={"putc"}, required=1)
    public IRubyObject putc(IRubyObject p1) {
        try {
            this.io.write((int)RubyNumeric.num2chr(p1));
            return p1;
        }
        catch (IOException ioe) {
            throw this.getRuntime().newIOErrorFromException(ioe);
        }
    }

    @JRubyMethod(name={"puts"}, rest=true)
    public IRubyObject puts(ThreadContext context, IRubyObject[] args2) {
        IRubyObject _sio = this.getRuntime().getClass("StringIO").newInstance(context, new IRubyObject[0], Block.NULL_BLOCK);
        if (_sio instanceof RubyStringIO) {
            RubyStringIO sio = (RubyStringIO)_sio;
            sio.puts(context, args2);
            this.write(sio.string());
        } else {
            StringIO sio = (StringIO)_sio;
            sio.puts(context, args2);
            this.write(sio.string(context));
        }
        return this.getRuntime().getNil();
    }

    @Override
    public IRubyObject finish() {
        if (!this.finished) {
            try {
                this.io.finish();
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
        }
        this.finished = true;
        return this.realIo;
    }

    @JRubyMethod(name={"flush"}, optional=1)
    public IRubyObject flush(IRubyObject[] args2) {
        int flush2 = 2;
        if (args2.length > 0 && !args2[0].isNil()) {
            flush2 = RubyNumeric.fix2int(args2[0]);
        }
        boolean tmp = this.io.getSyncFlush();
        try {
            if (flush2 != 0) {
                this.io.setSyncFlush(true);
            }
            this.io.flush();
        }
        catch (IOException ioe) {
            throw this.getRuntime().newIOErrorFromException(ioe);
        }
        finally {
            this.io.setSyncFlush(tmp);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"mtime="}, required=1)
    public IRubyObject set_mtime(IRubyObject arg2) {
        if (arg2 instanceof RubyTime) {
            this.mtime = (RubyTime)arg2;
        } else if (!arg2.isNil()) {
            this.mtime.setDateTime(new DateTime(RubyNumeric.fix2long(arg2) * 1000L));
        }
        try {
            this.io.setModifiedTime(this.mtime.to_i().getLongValue());
        }
        catch (GZIPException e) {
            throw RubyZlib.newGzipFileError(this.getRuntime(), "header is already written");
        }
        return this.getRuntime().getNil();
    }

    @Override
    @JRubyMethod(name={"crc"})
    public IRubyObject crc() {
        long crc2 = 0L;
        try {
            crc2 = this.io.getCRC();
        }
        catch (GZIPException gZIPException) {
            // empty catch block
        }
        return this.getRuntime().newFixnum(crc2);
    }

    @JRubyMethod(name={"write"}, required=1)
    public IRubyObject write(IRubyObject p1) {
        Ruby runtime = this.getRuntime();
        ByteList bytes2 = p1.asString().getByteList();
        if (runtime.is1_9() && this.enc2 != null && this.enc2 != ASCIIEncoding.INSTANCE) {
            bytes2 = Transcoder.strConvEncOpts(runtime.getCurrentContext(), bytes2, bytes2.getEncoding(), this.enc2, 0, runtime.getNil());
        }
        try {
            if (bytes2.length() > 0) {
                this.io.write(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length());
            }
            return runtime.newFixnum(bytes2.length());
        }
        catch (IOException ioe) {
            throw runtime.newIOErrorFromException(ioe);
        }
    }

    @Override
    @JRubyMethod
    public IRubyObject set_sync(IRubyObject arg2) {
        IRubyObject s2 = super.set_sync(arg2);
        this.io.setSyncFlush(this.sync);
        return s2;
    }
}

