/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Registration;
import org.jivesoftware.smack.util.StringUtils;

public class AccountManager {
    private static Logger logger = Logger.getLogger(AccountManager.class.getName());
    private Connection connection;
    private Registration info = null;
    private boolean accountCreationSupported = false;

    public AccountManager(Connection connection) {
        this.connection = connection;
    }

    void setSupportsAccountCreation(boolean accountCreationSupported) {
        this.accountCreationSupported = accountCreationSupported;
    }

    public boolean supportsAccountCreation() {
        if (this.accountCreationSupported) {
            return true;
        }
        try {
            if (this.info == null) {
                this.getRegistrationInfo();
                this.accountCreationSupported = this.info.getType() != IQ.Type.ERROR;
            }
            return this.accountCreationSupported;
        }
        catch (XMPPException xe) {
            return false;
        }
    }

    public Collection<String> getAccountAttributes() {
        try {
            Map<String, String> attributes;
            if (this.info == null) {
                this.getRegistrationInfo();
            }
            if ((attributes = this.info.getAttributes()) != null) {
                return Collections.unmodifiableSet(attributes.keySet());
            }
        }
        catch (XMPPException xe) {
            logger.log(Level.SEVERE, "Error retrieving account attributes from server", xe);
        }
        return Collections.emptySet();
    }

    public String getAccountAttribute(String name) {
        try {
            if (this.info == null) {
                this.getRegistrationInfo();
            }
            return this.info.getAttributes().get(name);
        }
        catch (XMPPException xe) {
            logger.log(Level.SEVERE, "Error retrieving account attribute " + name + " info from server", xe);
            return null;
        }
    }

    public String getAccountInstructions() {
        try {
            if (this.info == null) {
                this.getRegistrationInfo();
            }
            return this.info.getInstructions();
        }
        catch (XMPPException xe) {
            logger.log(Level.SEVERE, "Error retrieving account instructions from server", xe);
            return null;
        }
    }

    public void createAccount(String username, String password) throws XMPPException {
        if (!this.supportsAccountCreation()) {
            throw new XMPPException("Server does not support account creation.");
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (String attributeName : this.getAccountAttributes()) {
            attributes.put(attributeName, "");
        }
        this.createAccount(username, password, attributes);
    }

    public void createAccount(String username, String password, Map<String, String> attributes) throws XMPPException {
        if (!this.supportsAccountCreation()) {
            throw new XMPPException("Server does not support account creation.");
        }
        Registration reg = new Registration();
        reg.setType(IQ.Type.SET);
        reg.setTo(this.connection.getServiceName());
        attributes.put("username", username);
        attributes.put("password", password);
        reg.setAttributes(attributes);
        AndFilter filter = new AndFilter(new PacketIDFilter(reg.getPacketID()), new PacketTypeFilter(IQ.class));
        PacketCollector collector = this.connection.createPacketCollector(filter);
        this.connection.sendPacket(reg);
        IQ result = (IQ)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (result == null) {
            throw new XMPPException("No response from server.");
        }
        if (result.getType() == IQ.Type.ERROR) {
            throw new XMPPException(result.getError());
        }
    }

    public void changePassword(String newPassword) throws XMPPException {
        Registration reg = new Registration();
        reg.setType(IQ.Type.SET);
        reg.setTo(this.connection.getServiceName());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("username", StringUtils.parseName(this.connection.getUser()));
        map.put("password", newPassword);
        reg.setAttributes(map);
        AndFilter filter = new AndFilter(new PacketIDFilter(reg.getPacketID()), new PacketTypeFilter(IQ.class));
        PacketCollector collector = this.connection.createPacketCollector(filter);
        this.connection.sendPacket(reg);
        IQ result = (IQ)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (result == null) {
            throw new XMPPException("No response from server.");
        }
        if (result.getType() == IQ.Type.ERROR) {
            throw new XMPPException(result.getError());
        }
    }

    public void deleteAccount() throws XMPPException {
        if (!this.connection.isAuthenticated()) {
            throw new IllegalStateException("Must be logged in to delete a account.");
        }
        Registration reg = new Registration();
        reg.setType(IQ.Type.SET);
        reg.setTo(this.connection.getServiceName());
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("remove", "");
        reg.setAttributes(attributes);
        AndFilter filter = new AndFilter(new PacketIDFilter(reg.getPacketID()), new PacketTypeFilter(IQ.class));
        PacketCollector collector = this.connection.createPacketCollector(filter);
        this.connection.sendPacket(reg);
        IQ result = (IQ)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (result == null) {
            throw new XMPPException("No response from server.");
        }
        if (result.getType() == IQ.Type.ERROR) {
            throw new XMPPException(result.getError());
        }
    }

    private synchronized void getRegistrationInfo() throws XMPPException {
        Registration reg = new Registration();
        reg.setTo(this.connection.getServiceName());
        AndFilter filter = new AndFilter(new PacketIDFilter(reg.getPacketID()), new PacketTypeFilter(IQ.class));
        PacketCollector collector = this.connection.createPacketCollector(filter);
        this.connection.sendPacket(reg);
        IQ result = (IQ)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (result == null) {
            throw new XMPPException("No response from server.");
        }
        if (result.getType() == IQ.Type.ERROR) {
            throw new XMPPException(result.getError());
        }
        this.info = (Registration)result;
    }
}

