/*
 * Decompiled with CFR 0.152.
 */
package org.mule.lifecycle;

import com.google.common.base.Optional;
import java.util.Map;
import java.util.WeakHashMap;
import org.mule.api.lifecycle.LifecycleInterceptor;
import org.mule.api.lifecycle.LifecyclePhase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhaseErrorLifecycleInterceptor
implements LifecycleInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhaseErrorLifecycleInterceptor.class);
    private Map<Object, Object> trackingPhaseFailureObjects = new WeakHashMap<Object, Object>();
    private final String trackingPhase;
    private final String phaseToPreventOnTrackingPhaseError;
    private final Class trackingPhaseClass;

    public PhaseErrorLifecycleInterceptor(String trackingPhase, String phaseToPreventOnTrackingPhaseError, Class lifecycleClass) {
        this.trackingPhase = trackingPhase;
        this.phaseToPreventOnTrackingPhaseError = phaseToPreventOnTrackingPhaseError;
        this.trackingPhaseClass = lifecycleClass;
    }

    @Override
    public boolean beforePhaseExecution(LifecyclePhase phase, Object object) {
        if (this.isPhaseToPrevent(phase) && this.trackingPhaseClass.isAssignableFrom(object.getClass()) && this.trackingPhaseFailureObjects.containsKey(object)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Skipping %s lifecycle phase on object because %s phase failed before it could be applied on it. Object is: %s", this.phaseToPreventOnTrackingPhaseError, this.trackingPhase, object));
            }
            return false;
        }
        return true;
    }

    @Override
    public void afterPhaseExecution(LifecyclePhase phase, Object object, Optional<Exception> exceptionThrownOptional) {
        if (this.isTrackingPhase(phase) && exceptionThrownOptional.isPresent()) {
            this.trackingPhaseFailureObjects.put(object, object);
        }
    }

    @Override
    public void onPhaseCompleted(LifecyclePhase phase) {
        if (this.isTrackingPhase(phase)) {
            this.trackingPhaseFailureObjects.clear();
        }
    }

    private boolean isTrackingPhase(LifecyclePhase phase) {
        return this.trackingPhase.equals(phase.getName());
    }

    private boolean isPhaseToPrevent(LifecyclePhase phase) {
        return this.phaseToPreventOnTrackingPhaseError.equals(phase.getName());
    }
}

