/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.resource.spi.work.Work;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.exception.SystemExceptionHandler;
import org.mule.api.execution.ExecutionCallback;
import org.mule.api.execution.ExecutionTemplate;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transaction.Transaction;
import org.mule.api.transport.Connector;
import org.mule.routing.DefaultRouterResultsHandler;
import org.mule.transaction.TransactionCoordination;
import org.mule.transport.AbstractPollingMessageReceiver;

public abstract class TransactedPollingMessageReceiver
extends AbstractPollingMessageReceiver {
    private static final long NO_MESSAGES_SLEEP_TIME = Long.parseLong(System.getProperty("mule.vm.pollingSleepWaitTime", "50"));
    private boolean receiveMessagesInTransaction = true;
    private boolean useMultipleReceivers = true;
    private final DefaultRouterResultsHandler defaultRouterResultsHandler = new DefaultRouterResultsHandler(false);

    public TransactedPollingMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(connector, flowConstruct, endpoint);
        this.setReceiveMessagesInTransaction(endpoint.getTransactionConfig().isTransacted());
    }

    @Deprecated
    public TransactedPollingMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint, long frequency) throws CreateException {
        this(connector, flowConstruct, endpoint);
        this.setFrequency(frequency);
    }

    public boolean isReceiveMessagesInTransaction() {
        return this.receiveMessagesInTransaction;
    }

    public void setReceiveMessagesInTransaction(boolean useTx) {
        this.receiveMessagesInTransaction = useTx;
    }

    public boolean isUseMultipleTransactedReceivers() {
        return this.useMultipleReceivers;
    }

    public void setUseMultipleTransactedReceivers(boolean useMultiple) {
        this.useMultipleReceivers = useMultiple;
    }

    @Override
    public void doStart() throws MuleException {
        this.setUseMultipleTransactedReceivers(this.connector.isCreateMultipleTransactedReceivers());
        ThreadingProfile tp = this.connector.getReceiverThreadingProfile();
        int numReceiversToStart = 1;
        if (this.isReceiveMessagesInTransaction() && this.isUseMultipleTransactedReceivers() && tp.isDoThreading()) {
            numReceiversToStart = this.connector.getNumberOfConcurrentTransactedReceivers();
        }
        for (int i = 0; i < numReceiversToStart; ++i) {
            super.doStart();
        }
    }

    protected void pollMessagesOutsideTransactions() throws Exception {
        ExecutionTemplate<MuleEvent> pt = this.createExecutionTemplate();
        List<MuleMessage> messages = this.getMessages();
        if (messages != null && messages.size() > 0) {
            CountDownLatch countdown = new CountDownLatch(messages.size());
            for (MuleMessage message : messages) {
                try {
                    this.getWorkManager().scheduleWork(new MessageProcessorWorker(pt, countdown, this.endpoint.getMuleContext().getExceptionListener(), message));
                }
                catch (Exception e) {
                    countdown.countDown();
                    throw e;
                }
            }
            countdown.await();
        }
    }

    @Override
    public void poll() throws Exception {
        try {
            if (this.isReceiveMessagesInTransaction()) {
                ExecutionTemplate<MuleEvent> pt = this.createExecutionTemplate();
                if (this.hasNoMessages()) {
                    if (NO_MESSAGES_SLEEP_TIME > 0L) {
                        Thread.sleep(NO_MESSAGES_SLEEP_TIME);
                    }
                    return;
                }
                ExecutionCallback<MuleEvent> cb = new ExecutionCallback<MuleEvent>(){

                    @Override
                    public MuleEvent process() throws Exception {
                        List<MuleMessage> messages = TransactedPollingMessageReceiver.this.getMessages();
                        LinkedList<MuleEvent> results = new LinkedList<MuleEvent>();
                        if (messages != null && messages.size() > 0) {
                            for (MuleMessage message : messages) {
                                results.add(TransactedPollingMessageReceiver.this.processMessage(message));
                            }
                        } else {
                            Transaction currentTx = TransactionCoordination.getInstance().getTransaction();
                            currentTx.setRollbackOnly();
                            return null;
                        }
                        return TransactedPollingMessageReceiver.this.defaultRouterResultsHandler.aggregateResults(results, (MuleEvent)results.getLast(), TransactedPollingMessageReceiver.this.endpoint.getMuleContext());
                    }
                };
                pt.execute(cb);
            } else {
                this.pollMessagesOutsideTransactions();
            }
        }
        catch (MessagingException pt) {
        }
        catch (Exception e) {
            this.getEndpoint().getMuleContext().handleException(e);
        }
    }

    protected boolean hasNoMessages() {
        return false;
    }

    protected abstract List<MuleMessage> getMessages() throws Exception;

    protected abstract MuleEvent processMessage(Object var1) throws Exception;

    protected class MessageProcessorWorker
    implements Work,
    ExecutionCallback<MuleEvent> {
        private final ExecutionTemplate<MuleEvent> pt;
        private final Object message;
        private final CountDownLatch latch;
        private final SystemExceptionHandler exceptionHandler;

        public MessageProcessorWorker(ExecutionTemplate<MuleEvent> pt, CountDownLatch latch, SystemExceptionHandler exceptionHandler, Object message) {
            this.pt = pt;
            this.message = message;
            this.latch = latch;
            this.exceptionHandler = exceptionHandler;
        }

        public void release() {
        }

        public void run() {
            try {
                this.pt.execute(this);
            }
            catch (MessagingException messagingException) {
            }
            catch (Exception e) {
                this.exceptionHandler.handleException(e);
            }
            finally {
                this.latch.countDown();
            }
        }

        @Override
        public MuleEvent process() throws Exception {
            TransactedPollingMessageReceiver.this.processMessage(this.message);
            return null;
        }
    }
}

