/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleEvent;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.api.security.Credentials;
import org.mule.api.service.Service;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.routing.MessageFilter;
import org.mule.routing.filters.PayloadTypeFilter;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.simple.ByteArrayToObject;
import org.mule.transformer.simple.SerializableToByteArray;

public class MuleEventTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testNoPasswordNoNullPointerException() throws Exception {
        OutboundEndpoint endpoint = MuleEventTestCase.getTestOutboundEndpoint("AuthTest", "test://john.doe@xyz.fr");
        MuleEvent event = MuleEventTestCase.getTestEvent(new Object());
        Credentials credentials = event.getCredentials();
        Assert.assertNull((String)"Credentials must not be created for endpoints without a password.", (Object)credentials);
    }

    @Test
    public void testEventSerialization() throws Exception {
        InboundEndpoint endpoint = MuleEventTestCase.getTestInboundEndpoint("Test", null, null, (Filter)new PayloadTypeFilter(Object.class), null, null);
        MuleEvent event = RequestContext.setEvent((MuleEvent)MuleEventTestCase.getTestEvent((Object)"payload", endpoint));
        Transformer transformer = this.createSerializableToByteArrayTransformer();
        transformer.setMuleContext(muleContext);
        Serializable serialized = (Serializable)this.createSerializableToByteArrayTransformer().transform((Object)event);
        Assert.assertNotNull((Object)serialized);
        ByteArrayToObject trans = new ByteArrayToObject();
        trans.setMuleContext(muleContext);
        MuleEvent deserialized = (MuleEvent)trans.transform((Object)serialized);
        Assert.assertNotNull((Object)deserialized);
        Assert.assertNotNull((Object)deserialized.getMuleContext());
        Assert.assertNotNull((Object)deserialized.getSession());
        Assert.assertEquals((Object)event.getSession().getId(), (Object)deserialized.getSession().getId());
        Assert.assertNotNull((Object)deserialized.getFlowConstruct());
        Assert.assertEquals((Object)event.getFlowConstruct(), (Object)deserialized.getFlowConstruct());
        Assert.assertSame((Object)event.getFlowConstruct(), (Object)deserialized.getFlowConstruct());
    }

    private Transformer createSerializableToByteArrayTransformer() {
        SerializableToByteArray transformer = new SerializableToByteArray();
        transformer.setMuleContext(muleContext);
        return transformer;
    }

    @Test
    public void testEventSerializationRestart() throws Exception {
        MuleEvent event = this.createEventToSerialize();
        muleContext.start();
        Serializable serialized = (Serializable)this.createSerializableToByteArrayTransformer().transform((Object)event);
        Assert.assertNotNull((Object)serialized);
        muleContext.dispose();
        muleContext = this.createMuleContext();
        muleContext.start();
        ByteArrayToObject trans = new ByteArrayToObject();
        trans.setMuleContext(muleContext);
        this.createAndRegisterTransformersEndpointBuilderService();
        MuleEvent deserialized = (MuleEvent)trans.transform((Object)serialized);
        Assert.assertNotNull((Object)deserialized);
        Assert.assertNotNull((Object)deserialized.getMuleContext());
        Assert.assertNotNull((Object)deserialized.getSession());
        Assert.assertEquals((Object)event.getSession().getId(), (Object)deserialized.getSession().getId());
        Assert.assertNotNull((Object)deserialized.getFlowConstruct());
        Service service = (Service)event.getFlowConstruct();
        Service deserializedService = (Service)deserialized.getFlowConstruct();
        Assert.assertEquals((Object)service.getName(), (Object)deserializedService.getName());
        Assert.assertEquals((Object)service.getInitialState(), (Object)deserializedService.getInitialState());
        Assert.assertEquals(service.getExceptionListener().getClass(), deserializedService.getExceptionListener().getClass());
        Assert.assertEquals(service.getComponent().getClass(), deserializedService.getComponent().getClass());
    }

    @Test
    public void testMuleCredentialsSerialization() throws Exception {
        String username = "mule";
        String password = "rulez";
        String url = "test://" + username + ":" + password + "@localhost";
        InboundEndpoint endpoint = MuleEventTestCase.getTestInboundEndpoint("Test", url);
        ByteArrayToObject trans = new ByteArrayToObject();
        trans.setMuleContext(muleContext);
        MuleEvent event = RequestContext.setEvent((MuleEvent)MuleEventTestCase.getTestEvent((Object)"payload", endpoint));
        Serializable serialized = (Serializable)this.createSerializableToByteArrayTransformer().transform((Object)event);
        Assert.assertNotNull((Object)serialized);
        MuleEvent deserialized = (MuleEvent)trans.transform((Object)serialized);
        Assert.assertNotNull((Object)deserialized);
        Credentials credentials = deserialized.getCredentials();
        Assert.assertNotNull((Object)credentials);
        Assert.assertEquals((Object)username, (Object)credentials.getUsername());
        Assert.assertTrue((boolean)Arrays.equals(password.toCharArray(), credentials.getPassword()));
    }

    private MuleEvent createEventToSerialize() throws Exception {
        this.createAndRegisterTransformersEndpointBuilderService();
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint(muleContext.getRegistry().lookupEndpointBuilder("epBuilderTest"));
        Service service = muleContext.getRegistry().lookupService("appleService");
        return RequestContext.setEvent((MuleEvent)MuleEventTestCase.getTestEvent((Object)"payload", service, endpoint));
    }

    @Test
    public void testMuleEventSerializationWithRawPayload() throws Exception {
        StringBuilder payload = new StringBuilder();
        for (int i = 0; i < 108; ++i) {
            payload.append("1234567890");
        }
        MuleEvent testEvent = MuleEventTestCase.getTestEvent(new ByteArrayInputStream(payload.toString().getBytes()));
        byte[] serializedEvent = muleContext.getObjectSerializer().serialize((Object)testEvent);
        testEvent = (MuleEvent)muleContext.getObjectSerializer().deserialize(serializedEvent);
        Assert.assertArrayEquals((byte[])((byte[])testEvent.getMessage().getPayload()), (byte[])payload.toString().getBytes());
    }

    private void createAndRegisterTransformersEndpointBuilderService() throws Exception {
        TestEventTransformer trans1 = new TestEventTransformer();
        trans1.setName("OptimusPrime");
        muleContext.getRegistry().registerTransformer((Transformer)trans1);
        TestEventTransformer trans2 = new TestEventTransformer();
        trans2.setName("Bumblebee");
        muleContext.getRegistry().registerTransformer((Transformer)trans2);
        ArrayList<TestEventTransformer> transformers = new ArrayList<TestEventTransformer>();
        transformers.add(trans1);
        transformers.add(trans2);
        PayloadTypeFilter filter = new PayloadTypeFilter(Object.class);
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder("test://serializationTest", muleContext);
        endpointBuilder.setTransformers(transformers);
        endpointBuilder.setName("epBuilderTest");
        endpointBuilder.addMessageProcessor((MessageProcessor)new MessageFilter((Filter)filter));
        muleContext.getRegistry().registerEndpointBuilder("epBuilderTest", (EndpointBuilder)endpointBuilder);
        MuleEventTestCase.getTestService();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testFlowVarNamesAddImmutable() throws Exception {
        MuleEvent event = MuleEventTestCase.getTestEvent("whatever");
        event.setFlowVariable("test", (Object)"val");
        event.getFlowVariableNames().add("other");
    }

    public void testFlowVarNamesRemoveMutable() throws Exception {
        MuleEvent event = MuleEventTestCase.getTestEvent("whatever");
        event.setFlowVariable("test", (Object)"val");
        event.getFlowVariableNames().remove("test");
        Assert.assertNull((Object)event.getFlowVariable("test"));
    }

    @Test
    public void testFlowVarsNotShared() throws Exception {
        MuleEvent event = MuleEventTestCase.getTestEvent("whatever");
        MuleMessage message = event.getMessage();
        message.setInvocationProperty("foo", (Object)"bar");
        DefaultMuleEvent copy = new DefaultMuleEvent((MuleMessage)((ThreadSafeAccess)event.getMessage()).newThreadCopy(), event, false, false);
        MuleMessage messageCopy = copy.getMessage();
        messageCopy.setInvocationProperty("foo", (Object)"bar2");
        Assert.assertEquals((Object)"bar", (Object)event.getFlowVariable("foo"));
        Assert.assertEquals((Object)"bar", (Object)message.getInvocationProperty("foo"));
        Assert.assertEquals((Object)"bar2", (Object)copy.getFlowVariable("foo"));
        Assert.assertEquals((Object)"bar2", (Object)messageCopy.getInvocationProperty("foo"));
    }

    @Test
    public void testFlowVarsShared() throws Exception {
        MuleEvent event = MuleEventTestCase.getTestEvent("whatever");
        MuleMessage message = event.getMessage();
        message.setInvocationProperty("foo", (Object)"bar");
        DefaultMuleEvent copy = new DefaultMuleEvent((MuleMessage)((ThreadSafeAccess)event.getMessage()).newThreadCopy(), event, false);
        MuleMessage messageCopy = copy.getMessage();
        messageCopy.setInvocationProperty("foo", (Object)"bar2");
        Assert.assertEquals((Object)"bar2", (Object)event.getFlowVariable("foo"));
        Assert.assertEquals((Object)"bar2", (Object)message.getInvocationProperty("foo"));
        Assert.assertEquals((Object)"bar2", (Object)copy.getFlowVariable("foo"));
        Assert.assertEquals((Object)"bar2", (Object)messageCopy.getInvocationProperty("foo"));
    }

    private static class TestEventTransformer
    extends AbstractTransformer {
        private TestEventTransformer() {
        }

        public Object doTransform(Object src, String encoding) throws TransformerException {
            return "Transformed Test Data";
        }
    }
}

