/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.net.URI;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.api.endpoint.EndpointURI;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class MuleEndpointURITestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testEquality() throws Exception {
        MuleEndpointURI u1 = new MuleEndpointURI("test://mule:secret@jabber.org:6666/ross@jabber.org", muleContext);
        MuleEndpointURI u2 = new MuleEndpointURI("test://mule:secret@jabber.org:6666/ross@jabber.org", muleContext);
        Assert.assertEquals((Object)u1, (Object)u2);
        Assert.assertEquals((Object)u2, (Object)u1);
        Assert.assertEquals((long)u1.hashCode(), (long)u2.hashCode());
        Assert.assertEquals((long)u2.hashCode(), (long)u1.hashCode());
        MuleEndpointURI u3 = new MuleEndpointURI((EndpointURI)u1);
        Assert.assertEquals((Object)u1, (Object)u3);
        Assert.assertEquals((Object)u2, (Object)u3);
        Assert.assertEquals((Object)u3, (Object)u1);
        Assert.assertEquals((Object)u3, (Object)u2);
        Assert.assertEquals((long)u1.hashCode(), (long)u3.hashCode());
        Assert.assertEquals((long)u2.hashCode(), (long)u3.hashCode());
    }

    @Test
    public void testUriWithHostOnly() throws Exception {
        MuleEndpointURI uri = this.buildEndpointUri("test://theHost");
        this.assertSchemeAndHostAndEnpointName(uri);
        Assert.assertEquals((long)-1L, (long)uri.getPort());
        Assert.assertEquals((long)0L, (long)uri.getParams().size());
    }

    @Test
    public void testUriWithHostAndPort() throws Exception {
        MuleEndpointURI uri = this.buildEndpointUri("test://theHost:9999");
        this.assertSchemeAndHostAndEnpointName(uri);
        Assert.assertEquals((long)9999L, (long)uri.getPort());
        Assert.assertEquals((long)0L, (long)uri.getParams().size());
    }

    @Test
    public void testUriWithUsername() throws Exception {
        MuleEndpointURI uri = this.buildEndpointUri("test://theUser@theHost");
        this.assertSchemeAndHostAndEnpointName(uri);
        Assert.assertEquals((long)-1L, (long)uri.getPort());
        Assert.assertEquals((Object)"theUser", (Object)uri.getUser());
        Assert.assertEquals((long)0L, (long)uri.getParams().size());
    }

    @Test
    public void testUriWithUsernameAndPassword() throws Exception {
        MuleEndpointURI uri = this.buildEndpointUri("test://theUser:secret@theHost");
        this.assertSchemeAndHostAndEnpointName(uri);
        Assert.assertEquals((long)-1L, (long)uri.getPort());
        Assert.assertEquals((Object)"theUser", (Object)uri.getUser());
        Assert.assertEquals((Object)"secret", (Object)uri.getPassword());
        Assert.assertEquals((Object)"theUser:secret", (Object)uri.getUserInfo());
        Assert.assertEquals((long)0L, (long)uri.getParams().size());
    }

    @Test
    public void testUriWithUsernameContainingAtSignAndPassword() throws Exception {
        MuleEndpointURI uri = this.buildEndpointUri("test://theUser%40theEmailHost:secret@theHost");
        this.assertSchemeAndHostAndEnpointName(uri);
        Assert.assertEquals((long)-1L, (long)uri.getPort());
        Assert.assertEquals((Object)"theUser@theEmailHost", (Object)uri.getUser());
        Assert.assertEquals((Object)"secret", (Object)uri.getPassword());
        Assert.assertEquals((long)0L, (long)uri.getParams().size());
    }

    @Test
    public void testUriWithUsernameAndPasswordContainingAtSign() throws Exception {
        MuleEndpointURI uri = this.buildEndpointUri("test://theUser:secret%40secret@theHost");
        this.assertSchemeAndHostAndEnpointName(uri);
        Assert.assertEquals((long)-1L, (long)uri.getPort());
        Assert.assertEquals((Object)"theUser", (Object)uri.getUser());
        Assert.assertEquals((Object)"secret@secret", (Object)uri.getPassword());
        Assert.assertEquals((long)0L, (long)uri.getParams().size());
    }

    @Test
    public void testUriWithPath() throws Exception {
        MuleEndpointURI uri = this.buildEndpointUri("test://theHost/thePath");
        this.assertSchemeAndHostAndEnpointName(uri);
        Assert.assertEquals((long)-1L, (long)uri.getPort());
        Assert.assertEquals((Object)"/thePath", (Object)uri.getPath());
        Assert.assertEquals((long)0L, (long)uri.getParams().size());
    }

    @Test
    public void testUriWithQuery() throws Exception {
        MuleEndpointURI uri = this.buildEndpointUri("test://theHost?query=xxx");
        this.assertSchemeAndHostAndEnpointName(uri);
        Assert.assertEquals((long)-1L, (long)uri.getPort());
        Assert.assertEquals((Object)"query=xxx", (Object)uri.getQuery());
        Properties params = uri.getParams();
        Assert.assertEquals((long)1L, (long)params.size());
        Assert.assertEquals((Object)"xxx", (Object)params.getProperty("query"));
    }

    @Test
    public void testUriWithQueryContainingAtSign() throws Exception {
        MuleEndpointURI uri = this.buildEndpointUri("test://theHost?query=xxx@yyy");
        this.assertSchemeAndHostAndEnpointName(uri);
        Assert.assertEquals((long)-1L, (long)uri.getPort());
        Assert.assertEquals((Object)"query=xxx@yyy", (Object)uri.getQuery());
        Properties params = uri.getParams();
        Assert.assertEquals((long)1L, (long)params.size());
        Assert.assertEquals((Object)"xxx@yyy", (Object)params.getProperty("query"));
    }

    @Test
    public void testUriWithPathAndQuery() throws Exception {
        MuleEndpointURI uri = this.buildEndpointUri("test://theHost/thePath?query=xxx");
        this.assertSchemeAndHostAndEnpointName(uri);
        Assert.assertEquals((long)-1L, (long)uri.getPort());
        Assert.assertEquals((Object)"/thePath", (Object)uri.getPath());
        Assert.assertEquals((Object)"query=xxx", (Object)uri.getQuery());
        Properties params = uri.getParams();
        Assert.assertEquals((long)1L, (long)params.size());
        Assert.assertEquals((Object)"xxx", (Object)params.getProperty("query"));
    }

    @Test
    public void testPasswordMasking() throws Exception {
        MuleEndpointURI uri = new MuleEndpointURI("test://theUser:password@theHost", muleContext);
        Assert.assertEquals((Object)"test://theUser:****@theHost", (Object)uri.toString());
    }

    @Test
    public void testPasswordMaskingWithUsernameContainingAtSign() throws Exception {
        MuleEndpointURI uri = new MuleEndpointURI("test://theUser%40theEmailHost:password@theHost", muleContext);
        Assert.assertEquals((Object)"test://theUser%40theEmailHost:****@theHost", (Object)uri.toString());
    }

    @Test
    public void userPasswordEncoding() throws MuleException {
        MuleEndpointURI uri = this.buildEndpointUri("test://user%3Aname%40somehost.com:pass%3Aword@host:8081");
        Assert.assertThat((Object)uri.getUser(), (Matcher)Matchers.is((Object)"user:name@somehost.com"));
        Assert.assertThat((Object)uri.getPassword(), (Matcher)Matchers.is((Object)"pass:word"));
    }

    @Test
    public void ensuresDeadlockFreeEquals() throws Exception {
        Properties props1 = System.getProperties();
        Properties props2 = new Properties(props1);
        MuleEndpointURI uri1 = new MuleEndpointURI("", "", "", "", "", props1, new URI("http://localhost"), null);
        MuleEndpointURI uri2 = new MuleEndpointURI("", "", "", "", "", props2, new URI("http://localhost"), null);
        ExecutorService pool = Executors.newFixedThreadPool(10);
        pool.submit(new UriComparator(uri1, uri2));
        pool.submit(new UriComparator(uri2, uri1));
        pool.shutdown();
        pool.awaitTermination(30L, TimeUnit.SECONDS);
    }

    private MuleEndpointURI buildEndpointUri(String uriString) throws MuleException {
        MuleEndpointURI uri = new MuleEndpointURI(uriString, muleContext);
        uri.initialise();
        return uri;
    }

    private void assertSchemeAndHostAndEnpointName(MuleEndpointURI uri) {
        Assert.assertEquals((Object)"test", (Object)uri.getScheme());
        Assert.assertEquals((Object)"theHost", (Object)uri.getHost());
        Assert.assertNull((Object)uri.getEndpointName());
    }

    private static class UriComparator
    implements Runnable {
        private final MuleEndpointURI uri1;
        private final MuleEndpointURI uri2;

        public UriComparator(MuleEndpointURI uri1, MuleEndpointURI uri2) {
            this.uri1 = uri1;
            this.uri2 = uri2;
        }

        @Override
        public void run() {
            for (int i = 0; i < 1000; ++i) {
                this.uri1.equals((Object)this.uri2);
            }
        }
    }
}

