/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.expression.StringExpressionEvaluator;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;

public class StringExpressionEvaluatorTestCase
extends AbstractMuleContextTestCase {
    private Map props;

    @Override
    public void doSetUp() {
        this.props = new HashMap(3);
        this.props.put("foo", "moo");
        this.props.put("bar", "mar");
        this.props.put("baz", "maz");
    }

    @Test
    public void testString() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new Apple(), this.props, muleContext);
        StringExpressionEvaluator extractor = new StringExpressionEvaluator();
        extractor.setMuleContext(muleContext);
        Object o = extractor.evaluate("payload is #[function:shortPayloadClass] and has foo=#[header:foo] header", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((Object)"payload is Apple and has foo=moo header", (Object)o.toString());
        o = extractor.evaluate("literal string", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((Object)"literal string", (Object)o.toString());
    }

    @Test
    public void testStringUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new Apple(), this.props, muleContext);
        Object o = muleContext.getExpressionManager().evaluate("#[string:payload is #[function:shortPayloadClass] and has foo=#[header:foo] header]", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((Object)"payload is Apple and has foo=moo header", (Object)o.toString());
        o = muleContext.getExpressionManager().evaluate("#[string:literal string]", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((Object)"literal string", (Object)o.toString());
    }
}

