/*
 * Decompiled with CFR 0.152.
 */
package org.mule.keygenerator;

import java.io.NotSerializableException;
import java.io.Serializable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.expression.ExpressionManager;
import org.mule.keygenerator.ExpressionMuleEventKeyGenerator;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class ExpressionKeyGeneratorTestCase
extends AbstractMuleTestCase {
    private static final String RESOLVED_KEY = "KEY";
    private static final String SINGLE_EXPRESSION = "#[expression]";
    private ExpressionMuleEventKeyGenerator keyGenerator;
    private ExpressionManager expressionManager;
    private MuleContext muleContext;
    private MuleEvent event;

    @Before
    public void setUp() throws Exception {
        this.keyGenerator = new ExpressionMuleEventKeyGenerator();
        this.expressionManager = (ExpressionManager)Mockito.mock(ExpressionManager.class);
        this.muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        Mockito.when((Object)this.muleContext.getExpressionManager()).thenReturn((Object)this.expressionManager);
        this.event = (MuleEvent)Mockito.mock(MuleEvent.class);
        MuleContext context = (MuleContext)Mockito.mock(MuleContext.class);
        Mockito.when((Object)context.getExpressionManager()).thenReturn((Object)this.expressionManager);
        this.keyGenerator = new ExpressionMuleEventKeyGenerator();
    }

    @Test
    public void testGeneratesSerializableKey() throws Exception {
        this.keyGenerator.setExpression(SINGLE_EXPRESSION);
        this.keyGenerator.setMuleContext(this.muleContext);
        Mockito.when((Object)this.expressionManager.evaluate(SINGLE_EXPRESSION, this.event)).thenReturn((Object)RESOLVED_KEY);
        Serializable key = this.keyGenerator.generateKey(this.event);
        MatcherAssert.assertThat((Object)key, (Matcher)Matchers.equalTo((Object)RESOLVED_KEY));
    }

    @Test
    public void resolvesCompositeExpression() throws Exception {
        this.keyGenerator.setExpression("#[expression]#[expression]");
        this.keyGenerator.setMuleContext(this.muleContext);
        Mockito.when((Object)this.expressionManager.parse("#[expression]#[expression]", this.event)).thenReturn((Object)RESOLVED_KEY);
        Serializable key = this.keyGenerator.generateKey(this.event);
        MatcherAssert.assertThat((Object)key, (Matcher)Matchers.equalTo((Object)RESOLVED_KEY));
    }

    @Test(expected=NotSerializableException.class)
    public void testThrowsExceptionOnNonSerializableKey() throws Exception {
        this.keyGenerator.setExpression(SINGLE_EXPRESSION);
        this.keyGenerator.setMuleContext(this.muleContext);
        Mockito.when((Object)this.expressionManager.evaluate(SINGLE_EXPRESSION, this.event)).thenReturn(null);
        this.keyGenerator.generateKey(this.event);
    }
}

