/*
 * Decompiled with CFR 0.152.
 */
package org.mule.message.processing;

import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.DefaultMuleEvent;
import org.mule.RequestContext;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.context.notification.NotificationHelper;
import org.mule.context.notification.ServerNotificationManager;
import org.mule.execution.AsyncResponseFlowProcessingPhase;
import org.mule.execution.AsyncResponseFlowProcessingPhaseTemplate;
import org.mule.execution.MessageProcessContext;
import org.mule.execution.MessageProcessPhase;
import org.mule.execution.PhaseResultNotifier;
import org.mule.execution.ResponseCompletionCallback;
import org.mule.execution.ResponseDispatchException;
import org.mule.execution.ValidationPhase;
import org.mule.message.processing.PhaseSupportTestHelper;
import org.mule.tck.SensingNullMessageProcessor;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.util.concurrent.Latch;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class AsyncResponseFlowProcessingPhaseTestCase
extends AbstractMuleTestCase {
    private static final int LATCH_TIMEOUT = 50;
    private AsyncResponseFlowProcessingPhase phase = new AsyncResponseFlowProcessingPhase(){

        protected NotificationHelper getNotificationHelper(ServerNotificationManager serverNotificationManager) {
            return AsyncResponseFlowProcessingPhaseTestCase.this.notificationHelper;
        }
    };
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private AsyncResponseFlowProcessingPhaseTemplate mockTemplate;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessageProcessContext mockContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private PhaseResultNotifier mockNotifier;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ResponseDispatchException mockResponseDispatchException;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessagingException mockMessagingException;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleException mockException;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private DefaultMuleEvent mockMuleEvent;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private NotificationHelper notificationHelper;

    @Before
    public void before() {
        this.phase.setMuleContext((MuleContext)Mockito.mock(MuleContext.class));
    }

    @Before
    public void configureExpectedBehaviour() throws Exception {
        Mockito.when((Object)this.mockTemplate.getMuleEvent()).thenReturn((Object)this.mockMuleEvent);
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                ResponseCompletionCallback callback = (ResponseCompletionCallback)invocationOnMock.getArguments()[1];
                callback.responseSentSuccessfully();
                return null;
            }
        }).when((Object)this.mockTemplate)).sendFailureResponseToClient((MessagingException)((Object)Matchers.any(MessagingException.class)), (ResponseCompletionCallback)Matchers.any(ResponseCompletionCallback.class));
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                ResponseCompletionCallback callback = (ResponseCompletionCallback)invocationOnMock.getArguments()[1];
                callback.responseSentSuccessfully();
                return null;
            }
        }).when((Object)this.mockTemplate)).sendResponseToClient((MuleEvent)Matchers.any(MuleEvent.class), (ResponseCompletionCallback)Matchers.any(ResponseCompletionCallback.class));
        Mockito.when((Object)this.mockTemplate.getMuleEvent()).thenReturn((Object)this.mockMuleEvent);
    }

    @Test
    public void supportedTemplates() {
        new PhaseSupportTestHelper<AsyncResponseFlowProcessingPhaseTemplate>(AsyncResponseFlowProcessingPhaseTemplate.class).testSupportTemplates((MessageProcessPhase)this.phase);
    }

    @Test
    public void order() {
        Assert.assertThat((Object)this.phase.compareTo((MessageProcessPhase)new ValidationPhase()), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.phase.compareTo((MessageProcessPhase)Mockito.mock(MessageProcessPhase.class)), (Matcher)Is.is((Object)0));
    }

    @Test
    public void runPhaseWithMessagingExceptionThrown() throws Exception {
        Mockito.when((Object)this.mockContext.supportsAsynchronousProcessing()).thenReturn((Object)true);
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.doThrow((Throwable)this.mockMessagingException).when((Object)this.mockTemplate)).routeEvent((MuleEvent)Matchers.any(MuleEvent.class));
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        ((MessagingExceptionHandler)Mockito.verify((Object)this.mockContext.getFlowConstruct().getExceptionListener())).handleException((Exception)Matchers.any(Exception.class), (MuleEvent)Matchers.any(MuleEvent.class));
        this.verifyOnlySuccessfulWasCalled();
    }

    @Test
    public void runPhaseWithSuccessfulFlowProcessing() throws Exception {
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.verify((Object)this.mockTemplate)).sendResponseToClient((MuleEvent)Matchers.any(MuleEvent.class), (ResponseCompletionCallback)Matchers.any(ResponseCompletionCallback.class));
        this.verifyOnlySuccessfulWasCalled();
    }

    @Test
    public void runPhaseWithSuccessfulFlowProcessingNonBlocking() throws Exception {
        final SensingNullMessageProcessor sensingMessageProcessor = new SensingNullMessageProcessor();
        Mockito.when((Object)this.mockMuleEvent.isAllowNonBlocking()).thenReturn((Object)true);
        Mockito.when((Object)this.mockTemplate.routeEvent((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new Answer<MuleEvent>(){

            public MuleEvent answer(InvocationOnMock invocation) throws Throwable {
                return sensingMessageProcessor.process((MuleEvent)invocation.getArguments()[0]);
            }
        });
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        sensingMessageProcessor.latch.await(50L, TimeUnit.MILLISECONDS);
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.verify((Object)this.mockTemplate)).sendResponseToClient((MuleEvent)Matchers.any(MuleEvent.class), (ResponseCompletionCallback)Matchers.any(ResponseCompletionCallback.class));
        this.verifyOnlySuccessfulWasCalled();
    }

    @Test
    public void sendResponseWhenFlowExecutionFailsAndExceptionIsHandled() throws MuleException {
        Mockito.when((Object)this.mockTemplate.routeEvent((MuleEvent)Matchers.any(MuleEvent.class))).thenThrow(new Throwable[]{this.mockMessagingException});
        Mockito.when((Object)this.mockMessagingException.handled()).thenReturn((Object)true);
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.verify((Object)this.mockTemplate)).sendResponseToClient((MuleEvent)Matchers.any(MuleEvent.class), (ResponseCompletionCallback)Matchers.any(ResponseCompletionCallback.class));
        this.verifyOnlySuccessfulWasCalled();
    }

    @Test
    public void sendResponseWhenFlowExecutionFailsAndExceptionIsHandledNonBlocking() throws Exception {
        Mockito.when((Object)this.mockTemplate.routeEvent((MuleEvent)Matchers.any(MuleEvent.class))).thenThrow(new Throwable[]{this.mockMessagingException});
        Mockito.when((Object)this.mockMessagingException.handled()).thenReturn((Object)true);
        Latch latch = new Latch();
        Mockito.when((Object)this.mockMuleEvent.isAllowNonBlocking()).thenReturn((Object)true);
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.verify((Object)this.mockTemplate)).sendResponseToClient((MuleEvent)Matchers.any(MuleEvent.class), (ResponseCompletionCallback)Matchers.any(ResponseCompletionCallback.class));
        this.verifyOnlySuccessfulWasCalled();
    }

    @Test
    public void sendFailureResponseWhenFlowExecutionFailsAndExceptionIsNotHandled() throws MuleException {
        Mockito.when((Object)this.mockTemplate.routeEvent((MuleEvent)Matchers.any(MuleEvent.class))).thenThrow(new Throwable[]{this.mockMessagingException});
        Mockito.when((Object)this.mockMessagingException.handled()).thenReturn((Object)false);
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.verify((Object)this.mockTemplate)).sendFailureResponseToClient((MessagingException)((Object)Matchers.any(MessagingException.class)), (ResponseCompletionCallback)Matchers.any(ResponseCompletionCallback.class));
        this.verifyOnlySuccessfulWasCalled();
    }

    @Test
    public void sendFailureResponseWhenFlowExecutionFailsAndExceptionIsNotHandledNonBlocking() throws Exception {
        Mockito.when((Object)this.mockTemplate.routeEvent((MuleEvent)Matchers.any(MuleEvent.class))).thenThrow(new Throwable[]{this.mockMessagingException});
        Mockito.when((Object)this.mockMessagingException.handled()).thenReturn((Object)false);
        Mockito.when((Object)this.mockMuleEvent.isAllowNonBlocking()).thenReturn((Object)true);
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.verify((Object)this.mockTemplate)).sendFailureResponseToClient((MessagingException)((Object)Matchers.any(MessagingException.class)), (ResponseCompletionCallback)Matchers.any(ResponseCompletionCallback.class));
        this.verifyOnlySuccessfulWasCalled();
    }

    @Test
    public void callExceptionHandlerWhenSuccessfulExecutionFailsWritingResponse() throws Exception {
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                ResponseCompletionCallback callback = (ResponseCompletionCallback)invocationOnMock.getArguments()[1];
                callback.responseSentWithFailure((Exception)((Object)AsyncResponseFlowProcessingPhaseTestCase.this.mockException), (MuleEvent)AsyncResponseFlowProcessingPhaseTestCase.this.mockMuleEvent);
                return null;
            }
        }).when((Object)this.mockTemplate)).sendResponseToClient((MuleEvent)Matchers.any(MuleEvent.class), (ResponseCompletionCallback)Matchers.any(ResponseCompletionCallback.class));
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        ((MessagingExceptionHandler)Mockito.verify((Object)this.mockContext.getFlowConstruct().getExceptionListener())).handleException((Exception)Matchers.any(Exception.class), (MuleEvent)Matchers.any(MuleEvent.class));
        ((DefaultMuleEvent)Mockito.verify((Object)this.mockMuleEvent)).resetAccessControl();
        this.verifyOnlySuccessfulWasCalled();
    }

    @Test
    public void callExceptionHandlerWhenSuccessfulExecutionFailsWritingResponseNonBlocking() throws Exception {
        final SensingNullMessageProcessor sensingMessageProcessor = new SensingNullMessageProcessor();
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                ResponseCompletionCallback callback = (ResponseCompletionCallback)invocationOnMock.getArguments()[1];
                callback.responseSentWithFailure((Exception)((Object)AsyncResponseFlowProcessingPhaseTestCase.this.mockException), (MuleEvent)AsyncResponseFlowProcessingPhaseTestCase.this.mockMuleEvent);
                return null;
            }
        }).when((Object)this.mockTemplate)).sendResponseToClient((MuleEvent)Matchers.any(MuleEvent.class), (ResponseCompletionCallback)Matchers.any(ResponseCompletionCallback.class));
        Mockito.when((Object)this.mockMuleEvent.isAllowNonBlocking()).thenReturn((Object)true);
        Mockito.when((Object)this.mockTemplate.routeEvent((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new Answer<MuleEvent>(){

            public MuleEvent answer(InvocationOnMock invocation) throws Throwable {
                return sensingMessageProcessor.process((MuleEvent)invocation.getArguments()[0]);
            }
        });
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        sensingMessageProcessor.latch.await(50L, TimeUnit.MILLISECONDS);
        ((MessagingExceptionHandler)Mockito.verify((Object)this.mockContext.getFlowConstruct().getExceptionListener())).handleException((Exception)Matchers.any(Exception.class), (MuleEvent)Matchers.any(MuleEvent.class));
        ((DefaultMuleEvent)Mockito.verify((Object)this.mockMuleEvent)).resetAccessControl();
        this.verifyOnlySuccessfulWasCalled();
    }

    @Test
    public void doNotCallExceptionHandlerWhenFailureExecutionFailsWritingResponse() throws Exception {
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                ResponseCompletionCallback callback = (ResponseCompletionCallback)invocationOnMock.getArguments()[1];
                callback.responseSentWithFailure((Exception)((Object)AsyncResponseFlowProcessingPhaseTestCase.this.mockException), ((MessagingException)((Object)invocationOnMock.getArguments()[0])).getEvent());
                return null;
            }
        }).when((Object)this.mockTemplate)).sendFailureResponseToClient((MessagingException)((Object)Matchers.any(MessagingException.class)), (ResponseCompletionCallback)Matchers.any(ResponseCompletionCallback.class));
        Mockito.when((Object)this.mockTemplate.routeEvent((MuleEvent)Matchers.any(MuleEvent.class))).thenThrow(new Throwable[]{this.mockMessagingException});
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        ((MessagingExceptionHandler)Mockito.verify((Object)this.mockContext.getFlowConstruct().getExceptionListener())).handleException((Exception)Matchers.any(Exception.class), (MuleEvent)Matchers.any(MuleEvent.class));
        this.verifyOnlyFailureWasCalled((Exception)((Object)this.mockException));
    }

    @Test
    public void doNotCallExceptionHandlerWhenFailureExecutionFailsWritingResponseNonBlocking() throws Exception {
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                ResponseCompletionCallback callback = (ResponseCompletionCallback)invocationOnMock.getArguments()[1];
                callback.responseSentWithFailure((Exception)((Object)AsyncResponseFlowProcessingPhaseTestCase.this.mockException), ((MessagingException)((Object)invocationOnMock.getArguments()[0])).getEvent());
                return null;
            }
        }).when((Object)this.mockTemplate)).sendFailureResponseToClient((MessagingException)((Object)Matchers.any(MessagingException.class)), (ResponseCompletionCallback)Matchers.any(ResponseCompletionCallback.class));
        Mockito.when((Object)this.mockMuleEvent.isAllowNonBlocking()).thenReturn((Object)true);
        Mockito.when((Object)this.mockTemplate.routeEvent((MuleEvent)Matchers.any(MuleEvent.class))).thenThrow(new Throwable[]{this.mockMessagingException});
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        ((MessagingExceptionHandler)Mockito.verify((Object)this.mockContext.getFlowConstruct().getExceptionListener())).handleException((Exception)Matchers.any(Exception.class), (MuleEvent)Matchers.any(MuleEvent.class));
        this.verifyOnlyFailureWasCalled((Exception)((Object)this.mockException));
    }

    @Test
    public void allowNullEventsOnNotifications() throws Exception {
        RequestContext.setEvent(null);
        Mockito.when((Object)this.mockTemplate.getMuleEvent()).thenReturn(null);
        Mockito.when((Object)this.mockTemplate.routeEvent((MuleEvent)Matchers.any(MuleEvent.class))).thenReturn(null);
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        Mockito.when((Object)this.mockMuleEvent.newThreadCopy()).thenReturn((Object)this.mockMuleEvent);
        RequestContext.setEvent((MuleEvent)this.mockMuleEvent);
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
    }

    @Test
    public void responseNotificationFired() throws Exception {
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                ResponseCompletionCallback callback = (ResponseCompletionCallback)invocationOnMock.getArguments()[1];
                callback.responseSentWithFailure((Exception)((Object)AsyncResponseFlowProcessingPhaseTestCase.this.mockException), (MuleEvent)AsyncResponseFlowProcessingPhaseTestCase.this.mockMuleEvent);
                return null;
            }
        }).when((Object)this.mockTemplate)).sendResponseToClient((MuleEvent)Matchers.any(MuleEvent.class), (ResponseCompletionCallback)Matchers.any(ResponseCompletionCallback.class));
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        ((NotificationHelper)Mockito.verify((Object)this.notificationHelper)).fireNotification((MuleEvent)Matchers.any(MuleEvent.class), (String)Matchers.isNull(String.class), (FlowConstruct)Matchers.any(FlowConstruct.class), Matchers.eq((int)805));
        ((NotificationHelper)Mockito.verify((Object)this.notificationHelper, (VerificationMode)Mockito.never())).fireNotification((MuleEvent)Matchers.any(MuleEvent.class), (String)Matchers.isNull(String.class), (FlowConstruct)Matchers.any(FlowConstruct.class), Matchers.eq((int)806));
    }

    @Test
    public void responseNotificationFiredNonBlocking() throws Exception {
        final SensingNullMessageProcessor sensingMessageProcessor = new SensingNullMessageProcessor();
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                ResponseCompletionCallback callback = (ResponseCompletionCallback)invocationOnMock.getArguments()[1];
                callback.responseSentWithFailure((Exception)((Object)AsyncResponseFlowProcessingPhaseTestCase.this.mockException), (MuleEvent)AsyncResponseFlowProcessingPhaseTestCase.this.mockMuleEvent);
                return null;
            }
        }).when((Object)this.mockTemplate)).sendResponseToClient((MuleEvent)Matchers.any(MuleEvent.class), (ResponseCompletionCallback)Matchers.any(ResponseCompletionCallback.class));
        Mockito.when((Object)this.mockMuleEvent.isAllowNonBlocking()).thenReturn((Object)true);
        Mockito.when((Object)this.mockTemplate.routeEvent((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new Answer<MuleEvent>(){

            public MuleEvent answer(InvocationOnMock invocation) throws Throwable {
                return sensingMessageProcessor.process((MuleEvent)invocation.getArguments()[0]);
            }
        });
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        sensingMessageProcessor.latch.await(50L, TimeUnit.MILLISECONDS);
        ((NotificationHelper)Mockito.verify((Object)this.notificationHelper)).fireNotification((MuleEvent)Matchers.any(MuleEvent.class), (String)Matchers.isNull(String.class), (FlowConstruct)Matchers.any(FlowConstruct.class), Matchers.eq((int)805));
        ((NotificationHelper)Mockito.verify((Object)this.notificationHelper, (VerificationMode)Mockito.never())).fireNotification((MuleEvent)Matchers.any(MuleEvent.class), (String)Matchers.isNull(String.class), (FlowConstruct)Matchers.any(FlowConstruct.class), Matchers.eq((int)806));
    }

    @Test
    public void errorResponseNotificationFired() throws Exception {
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                ResponseCompletionCallback callback = (ResponseCompletionCallback)invocationOnMock.getArguments()[1];
                callback.responseSentWithFailure((Exception)((Object)AsyncResponseFlowProcessingPhaseTestCase.this.mockException), (MuleEvent)AsyncResponseFlowProcessingPhaseTestCase.this.mockMuleEvent);
                return null;
            }
        }).when((Object)this.mockTemplate)).sendResponseToClient((MuleEvent)Matchers.any(MuleEvent.class), (ResponseCompletionCallback)Matchers.any(ResponseCompletionCallback.class));
        Mockito.when((Object)this.mockTemplate.routeEvent((MuleEvent)Matchers.any(MuleEvent.class))).thenThrow(new Throwable[]{this.mockMessagingException});
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        ((NotificationHelper)Mockito.verify((Object)this.notificationHelper, (VerificationMode)Mockito.never())).fireNotification((MuleEvent)Matchers.any(MuleEvent.class), (String)Matchers.isNull(String.class), (FlowConstruct)Matchers.any(FlowConstruct.class), Matchers.eq((int)805));
        ((NotificationHelper)Mockito.verify((Object)this.notificationHelper)).fireNotification((MuleEvent)Matchers.any(MuleEvent.class), (String)Matchers.isNull(String.class), (FlowConstruct)Matchers.any(FlowConstruct.class), Matchers.eq((int)806));
    }

    @Test
    public void errorResponseNotificationFiredNonBlocking() throws Exception {
        SensingNullMessageProcessor sensingMessageProcessor = new SensingNullMessageProcessor();
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                ResponseCompletionCallback callback = (ResponseCompletionCallback)invocationOnMock.getArguments()[1];
                callback.responseSentWithFailure((Exception)((Object)AsyncResponseFlowProcessingPhaseTestCase.this.mockException), (MuleEvent)AsyncResponseFlowProcessingPhaseTestCase.this.mockMuleEvent);
                return null;
            }
        }).when((Object)this.mockTemplate)).sendResponseToClient((MuleEvent)Matchers.any(MuleEvent.class), (ResponseCompletionCallback)Matchers.any(ResponseCompletionCallback.class));
        Mockito.when((Object)this.mockMuleEvent.isAllowNonBlocking()).thenReturn((Object)true);
        Mockito.when((Object)this.mockTemplate.routeEvent((MuleEvent)Matchers.any(MuleEvent.class))).thenThrow(new Throwable[]{this.mockMessagingException});
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        sensingMessageProcessor.latch.await(50L, TimeUnit.MILLISECONDS);
        ((NotificationHelper)Mockito.verify((Object)this.notificationHelper, (VerificationMode)Mockito.never())).fireNotification((MuleEvent)Matchers.any(MuleEvent.class), (String)Matchers.isNull(String.class), (FlowConstruct)Matchers.any(FlowConstruct.class), Matchers.eq((int)805));
        ((NotificationHelper)Mockito.verify((Object)this.notificationHelper)).fireNotification((MuleEvent)Matchers.any(MuleEvent.class), (String)Matchers.isNull(String.class), (FlowConstruct)Matchers.any(FlowConstruct.class), Matchers.eq((int)806));
    }

    private void verifyOnlySuccessfulWasCalled() {
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier, (VerificationMode)Mockito.never())).phaseFailure((Exception)Matchers.any(Exception.class));
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier, (VerificationMode)Mockito.never())).phaseConsumedMessage();
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier)).phaseSuccessfully();
    }

    private void verifyOnlyFailureWasCalled(Exception e) {
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier)).phaseFailure(e);
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier, (VerificationMode)Mockito.never())).phaseConsumedMessage();
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier, (VerificationMode)Mockito.never())).phaseSuccessfully();
    }
}

