/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageReceiver;
import org.mule.api.transport.PropertyScope;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.session.NullSessionHandler;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.mule.TestMessageReceiver;
import org.mule.transaction.MuleTransactionConfig;
import org.mule.transport.AbstractConnector;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class MessageReceiverTestCase
extends AbstractMuleTestCase {
    @Mock
    private MuleContext muleContext;
    @Mock
    private MuleSession muleSession;

    @Before
    public void setup() {
        Mockito.when((Object)this.muleSession.getId()).thenReturn((Object)"1");
        MuleConfiguration muleConfiguration = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);
        Mockito.when((Object)this.muleContext.getConfiguration()).thenReturn((Object)muleConfiguration);
    }

    @Test
    public void routeMessageOneWayReturnsNotNull() throws MuleException {
        MessageReceiver receiver = this.createMessageReciever(MessageExchangePattern.ONE_WAY);
        Assert.assertNotNull((Object)receiver.routeMessage(this.createRequestMessage()));
    }

    @Test
    public void routeMessageRequestResponseReturnsEvent() throws MuleException {
        MessageReceiver receiver = this.createMessageReciever(MessageExchangePattern.REQUEST_RESPONSE);
        MuleMessage request = this.createRequestMessage();
        Assert.assertEquals((Object)request, (Object)receiver.routeMessage(request).getMessage());
    }

    protected MuleMessage createRequestMessage() {
        MuleMessage request = (MuleMessage)Mockito.mock(MuleMessage.class);
        Mockito.when((Object)request.getMuleContext()).thenReturn((Object)this.muleContext);
        Mockito.when((Object)request.getProperty(Mockito.anyString(), (PropertyScope)Mockito.any(PropertyScope.class), (Object)Mockito.eq((boolean)false))).thenReturn((Object)Boolean.FALSE);
        return request;
    }

    protected MessageReceiver createMessageReciever(MessageExchangePattern mep) throws MuleException {
        AbstractConnector connector = (AbstractConnector)Mockito.mock(AbstractConnector.class);
        Mockito.when((Object)connector.getSessionHandler()).thenReturn((Object)new NullSessionHandler());
        FlowConstruct flowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        InboundEndpoint endpoint = (InboundEndpoint)Mockito.mock(InboundEndpoint.class);
        Mockito.when((Object)endpoint.getExchangePattern()).thenReturn((Object)mep);
        Mockito.when((Object)endpoint.getConnector()).thenReturn((Object)connector);
        Mockito.when((Object)endpoint.getEndpointURI()).thenReturn((Object)new MuleEndpointURI("test://test", this.muleContext));
        Mockito.when((Object)endpoint.getTransactionConfig()).thenReturn((Object)new MuleTransactionConfig());
        Mockito.when((Object)endpoint.getExchangePattern()).thenReturn((Object)mep);
        Mockito.when((Object)endpoint.getMuleContext()).thenReturn((Object)this.muleContext);
        MuleEvent responseEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        Mockito.when((Object)responseEvent.getSession()).thenReturn((Object)this.muleSession);
        MessageProcessor listener = (MessageProcessor)Mockito.mock(MessageProcessor.class);
        Mockito.when((Object)listener.process((MuleEvent)Mockito.any(MuleEvent.class))).thenAnswer((Answer)new Answer<MuleEvent>(){

            public MuleEvent answer(InvocationOnMock invocation) throws Throwable {
                return (MuleEvent)invocation.getArguments()[0];
            }
        });
        TestMessageReceiver messageReceiver = new TestMessageReceiver((Connector)connector, flowConstruct, endpoint);
        messageReceiver.setListener(listener);
        return messageReceiver;
    }
}

