/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime.resolver;

import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.module.extension.internal.runtime.resolver.ValueResolver;

public class CachingValueResolverWrapper<T>
implements ValueResolver<T> {
    private final ValueResolver<T> delegate;
    private T value;
    private CachingDelegate cacheDelegate = new FirstTimeCachingDelegate();

    public CachingValueResolverWrapper(ValueResolver<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public T resolve(MuleEvent event) throws MuleException {
        return (T)this.cacheDelegate.get(event);
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    private class FastCachingDelegate
    implements CachingDelegate {
        private FastCachingDelegate() {
        }

        @Override
        public Object get(MuleEvent event) throws MuleException {
            return CachingValueResolverWrapper.this.value;
        }
    }

    private class FirstTimeCachingDelegate
    implements CachingDelegate {
        private FirstTimeCachingDelegate() {
        }

        @Override
        public synchronized Object get(MuleEvent event) throws MuleException {
            if (CachingValueResolverWrapper.this.value == null) {
                CachingValueResolverWrapper.this.value = CachingValueResolverWrapper.this.delegate.resolve(event);
                CachingValueResolverWrapper.this.cacheDelegate = new FastCachingDelegate();
            }
            return CachingValueResolverWrapper.this.value;
        }
    }

    private static interface CachingDelegate {
        public Object get(MuleEvent var1) throws MuleException;
    }
}

