/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.xpath;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathVariableResolver;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.mule.api.MuleEvent;
import org.mule.api.MuleRuntimeException;
import org.mule.module.xml.i18n.XmlMessages;
import org.mule.module.xml.util.NamespaceManager;
import org.mule.module.xml.xpath.XPathEvaluator;
import org.mule.module.xml.xpath.XPathExpressionFactory;
import org.mule.module.xml.xpath.XPathNamespaceContext;
import org.mule.module.xml.xpath.XPathReturnType;
import org.mule.util.Preconditions;
import org.w3c.dom.Node;

public abstract class JaxpXPathEvaluator
implements XPathEvaluator,
XPathVariableResolver {
    private static final int MIN_IDLE_XPATH_EXPRESSIONS = 1;
    private static final int MAX_IDLE_XPATH_EXPRESSIONS = 32;
    private static final int MAX_ACTIVE_XPATH_EXPRESSIONS = 32;
    private final XPathFactory xpathFactory;
    private final Map<String, String> prefixToNamespaceMap = new HashMap<String, String>();
    private final ThreadLocal<MuleEvent> evaluationEvent = new ThreadLocal();
    private final LoadingCache<String, GenericObjectPool<XPathExpression>> xpathExpressionPoolCache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<String, GenericObjectPool<XPathExpression>>(){

        public void onRemoval(RemovalNotification<String, GenericObjectPool<XPathExpression>> notification) {
            ((GenericObjectPool)notification.getValue()).clear();
        }
    }).build((CacheLoader)new CacheLoader<String, GenericObjectPool<XPathExpression>>(){

        public GenericObjectPool<XPathExpression> load(String key) throws Exception {
            return JaxpXPathEvaluator.this.getXPathExpressionPool(key);
        }
    });
    private NamespaceContext namespaceContext;

    public JaxpXPathEvaluator() {
        this.xpathFactory = this.createXPathFactory();
        this.namespaceContext = this.newNamespaceContext();
    }

    protected abstract XPathFactory createXPathFactory();

    @Override
    public String evaluate(String xpathExpression, Node input, MuleEvent event) {
        return (String)this.evaluate(xpathExpression, input, XPathReturnType.STRING, event);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object evaluate(String xpathExpression, Node input, XPathReturnType returnType, MuleEvent event) {
        Object object;
        XPathExpression xpath = null;
        GenericObjectPool xpathExpressionPool = null;
        try {
            Object result;
            this.evaluationEvent.set(event);
            xpathExpressionPool = (GenericObjectPool)this.xpathExpressionPoolCache.get((Object)xpathExpression);
            xpath = (XPathExpression)xpathExpressionPool.borrowObject();
            object = result = xpath.evaluate(input, returnType.toQName());
            this.evaluationEvent.remove();
        }
        catch (Exception e) {
            try {
                throw new MuleRuntimeException(XmlMessages.failedToProcessXPath(xpathExpression), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.evaluationEvent.remove();
                try {
                    if (xpathExpressionPool == null) throw throwable;
                    if (xpath == null) throw throwable;
                    xpathExpressionPool.returnObject(xpath);
                    throw throwable;
                }
                catch (Exception e2) {
                    throw new MuleRuntimeException(XmlMessages.failedToProcessXPath(xpathExpression), (Throwable)e2);
                }
            }
        }
        try {
            if (xpathExpressionPool == null) return object;
            if (xpath == null) return object;
            xpathExpressionPool.returnObject((Object)xpath);
            return object;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(XmlMessages.failedToProcessXPath(xpathExpression), (Throwable)e);
        }
    }

    @Override
    public Object resolveVariable(QName variableName) {
        MuleEvent event = this.evaluationEvent.get();
        if (event != null) {
            return event.getFlowVariable(variableName.getLocalPart());
        }
        return null;
    }

    @Override
    public void registerNamespaces(Map<String, String> namespaces) {
        Preconditions.checkArgument((namespaces != null ? 1 : 0) != 0, (String)"cannot register null namespaces");
        this.prefixToNamespaceMap.putAll(namespaces);
        this.namespaceContext = this.newNamespaceContext();
        this.xpathExpressionPoolCache.invalidateAll();
    }

    @Override
    public void registerNamespaces(NamespaceManager namespaceManager) {
        Preconditions.checkArgument((namespaceManager != null ? 1 : 0) != 0, (String)"cannot register a null namespace manager");
        this.registerNamespaces(namespaceManager.getNamespaces());
    }

    @Override
    public Map<String, String> getRegisteredNamespaces() {
        return ImmutableMap.copyOf(this.prefixToNamespaceMap);
    }

    private GenericObjectPool<XPathExpression> getXPathExpressionPool(String expression) {
        GenericObjectPool genericPool = new GenericObjectPool((PoolableObjectFactory)new XPathExpressionFactory(this.xpathFactory, expression, this.namespaceContext, this));
        genericPool.setMaxActive(32);
        genericPool.setMaxIdle(32);
        genericPool.setMinIdle(1);
        return genericPool;
    }

    protected NamespaceContext newNamespaceContext() {
        return new XPathNamespaceContext(this.prefixToNamespaceMap);
    }
}

