/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.connection;

import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Connection;
import java.sql.SQLException;
import org.mule.module.db.internal.domain.connection.DefaultDbConnection;
import org.mule.module.db.internal.domain.connection.DefaultDbConnectionReleaser;
import org.mule.module.db.internal.domain.transaction.TransactionalAction;
import org.mule.module.db.internal.resolver.param.ParamTypeResolverFactory;

public class OracleDbConnection
extends DefaultDbConnection {
    private Method createArrayMethod;
    private boolean initialized;

    public OracleDbConnection(Connection delegate, TransactionalAction transactionalAction, DefaultDbConnectionReleaser connectionReleaseListener, ParamTypeResolverFactory paramTypeResolverFactory) {
        super(delegate, transactionalAction, connectionReleaseListener, paramTypeResolverFactory);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        if (this.getCreateArrayOfMethod(this.delegate) == null) {
            return super.createArrayOf(typeName, elements);
        }
        try {
            return (Array)this.getCreateArrayOfMethod(this.delegate).invoke((Object)this.delegate, typeName, elements);
        }
        catch (Exception e) {
            throw new SQLException("Error creating ARRAY", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method getCreateArrayOfMethod(Connection delegate) {
        if (this.createArrayMethod == null && !this.initialized) {
            OracleDbConnection oracleDbConnection = this;
            synchronized (oracleDbConnection) {
                if (this.createArrayMethod == null && !this.initialized) {
                    try {
                        this.createArrayMethod = delegate.getClass().getMethod("createARRAY", String.class, Object.class);
                        this.createArrayMethod.setAccessible(true);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    this.initialized = true;
                }
            }
        }
        return this.createArrayMethod;
    }
}

