/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.module.apikit.AbstractConfiguration;
import org.mule.module.apikit.UrlUtils;
import org.mule.module.apikit.exception.NotFoundException;
import org.mule.transport.http.components.ResourceNotFoundException;
import org.mule.transport.http.i18n.HttpMessages;
import org.mule.util.FilenameUtils;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleHandler
implements MessageProcessor {
    public static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    public static final String MIME_TYPE_JAVASCRIPT = "application/x-javascript";
    public static final String MIME_TYPE_PNG = "image/png";
    public static final String MIME_TYPE_GIF = "image/gif";
    public static final String MIME_TYPE_SVG = "image/svg+xml";
    public static final String MIME_TYPE_CSS = "text/css";
    private static final String RESOURCE_BASE = System.getProperty("apikit.console.old") != null ? "/console" : "/console2";
    private static final String CONSOLE_ELEMENT = "<raml-console-loader";
    private static final String CONSOLE_ELEMENT_OLD = "<raml-console";
    private static final String CONSOLE_ATTRIBUTES = "options=\"{disableRamlClientGenerator: true, disableThemeSwitcher: true}\"";
    private static final String CONSOLE_ATTRIBUTES_OLD = "disable-raml-client-generator=\"\" disable-theme-switcher=\"\"";
    private static final String CONSOLE_ATTRIBUTES_PLACEHOLDER = "console-attributes-placeholder";
    private static final String DEFAULT_API_RESOURCES_PATH = "api/";
    private static final String RAML_QUERY_STRING = "raml";
    private String cachedIndexHtml;
    private String embeddedConsolePath;
    private String apiResourcesRelativePath = "api/";
    private boolean standalone;
    private AbstractConfiguration configuration;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String consoleBaseUri;

    public ConsoleHandler(String consoleBaseUri, AbstractConfiguration configuration) {
        this(consoleBaseUri, "", configuration);
        this.standalone = true;
    }

    public ConsoleHandler(String consoleBaseUri, String embeddedConsolePath, AbstractConfiguration configuration) {
        this.configuration = configuration;
        this.embeddedConsolePath = this.sanitize(embeddedConsolePath);
        this.consoleBaseUri = consoleBaseUri;
    }

    public void updateRamlUri() {
        String relativeRamlUri = this.getRelativeRamlUri();
        if (relativeRamlUri != null) {
            String consoleElement = CONSOLE_ELEMENT;
            String consoleAttributes = CONSOLE_ATTRIBUTES;
            if (this.isOldConsole()) {
                consoleElement = CONSOLE_ELEMENT_OLD;
                consoleAttributes = CONSOLE_ATTRIBUTES_OLD;
            }
            InputStream indexInputStream = this.getClass().getResourceAsStream(RESOURCE_BASE + "/index.html");
            String indexHtml = IOUtils.toString((InputStream)indexInputStream);
            IOUtils.closeQuietly((InputStream)indexInputStream);
            indexHtml = indexHtml.replaceFirst(consoleElement + " src=\"[^\"]+\"", consoleElement + " src=\"" + relativeRamlUri + "\"");
            this.cachedIndexHtml = indexHtml.replaceFirst(CONSOLE_ATTRIBUTES_PLACEHOLDER, consoleAttributes);
        } else {
            this.cachedIndexHtml = "RAML Console is DISABLED.";
        }
    }

    private boolean isOldConsole() {
        return RESOURCE_BASE.equals("/console");
    }

    private String getRelativeRamlUri() {
        if (this.configuration.isParserV2()) {
            File apiResource;
            String ramlLocation = this.configuration.getRaml();
            if (ramlLocation.startsWith(DEFAULT_API_RESOURCES_PATH)) {
                ramlLocation = ramlLocation.substring(DEFAULT_API_RESOURCES_PATH.length());
            }
            if ((apiResource = new File(this.configuration.getAppHome(), "/api/" + ramlLocation)).isFile()) {
                if (ramlLocation.contains("/")) {
                    this.apiResourcesRelativePath = this.apiResourcesRelativePath + ramlLocation.substring(0, ramlLocation.lastIndexOf("/") + 1);
                }
                return this.apiResourcesRelativePath + "?" + RAML_QUERY_STRING;
            }
            ramlLocation = this.configuration.getRaml();
            int idx = ramlLocation.lastIndexOf("/");
            if (idx > 0) {
                this.apiResourcesRelativePath = ramlLocation.substring(0, idx + 1);
                return this.apiResourcesRelativePath + "?" + RAML_QUERY_STRING;
            }
            this.logger.error("RAML Console is DISABLED. RAML resources cannot be hosted in the classpath root");
            return null;
        }
        return "./?";
    }

    private String sanitize(String consolePath) {
        if (consolePath.endsWith("/")) {
            consolePath = consolePath.substring(0, consolePath.length() - 1);
        }
        if (!consolePath.isEmpty() && !consolePath.startsWith("/")) {
            consolePath = "/" + consolePath;
        }
        return consolePath;
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        DefaultMuleEvent resultEvent;
        boolean addContentEncodingHeader;
        ByteArrayOutputStream baos;
        InputStream in;
        String queryString;
        String path;
        block23: {
            String listenerPath = (String)event.getMessage().getInboundProperty("http.listener.path");
            if (listenerPath != null && !listenerPath.endsWith("/*")) {
                throw new IllegalStateException("Console path in listener must end with /*");
            }
            path = UrlUtils.getResourceRelativePath(event.getMessage());
            String contextPath = UrlUtils.getBasePath(event.getMessage());
            queryString = UrlUtils.getQueryString(event.getMessage());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Console request: " + path);
            }
            in = null;
            baos = null;
            addContentEncodingHeader = false;
            if (!path.equals(this.embeddedConsolePath) || contextPath.endsWith("/") && this.standalone) break block23;
            event.getMessage().setOutboundProperty("http.status", (Object)String.valueOf(301));
            String scheme = UrlUtils.getScheme(event.getMessage());
            String host = (String)event.getMessage().getInboundProperty("Host");
            String requestPath = (String)event.getMessage().getInboundProperty("http.request.path");
            String redirectLocation = scheme + "://" + host + requestPath + "/";
            if (StringUtils.isNotEmpty((String)queryString)) {
                redirectLocation = redirectLocation + "?" + queryString;
            }
            event.getMessage().setOutboundProperty("Location", (Object)redirectLocation);
            MuleEvent muleEvent = event;
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)baos);
            return muleEvent;
        }
        try {
            if (path.equals(this.embeddedConsolePath) || path.equals(this.embeddedConsolePath + "/") || path.equals(this.embeddedConsolePath + "/index.html")) {
                path = RESOURCE_BASE + "/index.html";
                in = new ByteArrayInputStream(this.cachedIndexHtml.getBytes());
            } else {
                String apiResourcesFullPath = this.embeddedConsolePath + "/" + this.apiResourcesRelativePath;
                if (path.startsWith(apiResourcesFullPath)) {
                    if (path.equals(apiResourcesFullPath) && queryString.equals(RAML_QUERY_STRING)) {
                        path = path + ".raml";
                        in = new ByteArrayInputStream(this.configuration.getApikitRamlConsole(event).getBytes());
                    } else {
                        String resourcePath = "/" + this.apiResourcesRelativePath + path.substring(apiResourcesFullPath.length());
                        File apiResource = new File(this.configuration.getAppHome(), resourcePath);
                        in = new FileInputStream(apiResource);
                    }
                } else if (path.startsWith(this.embeddedConsolePath + "/scripts")) {
                    String acceptEncoding = (String)event.getMessage().getInboundProperty("accept-encoding");
                    if (acceptEncoding != null && acceptEncoding.contains("gzip")) {
                        in = this.getClass().getResourceAsStream(RESOURCE_BASE + path.substring(this.embeddedConsolePath.length()) + ".gz");
                        addContentEncodingHeader = true;
                    } else {
                        in = this.getClass().getResourceAsStream(RESOURCE_BASE + path.substring(this.embeddedConsolePath.length()));
                    }
                } else if (path.startsWith(this.embeddedConsolePath)) {
                    in = this.getClass().getResourceAsStream(RESOURCE_BASE + path.substring(this.embeddedConsolePath.length()));
                }
            }
            if (in == null) {
                throw new NotFoundException(path);
            }
            baos = new ByteArrayOutputStream();
            IOUtils.copyLarge((InputStream)in, (OutputStream)baos);
            byte[] buffer = baos.toByteArray();
            String mimetype = this.getMimeType(path);
            if (mimetype == null) {
                mimetype = DEFAULT_MIME_TYPE;
            }
            resultEvent = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)buffer, event.getMuleContext()), event);
            resultEvent.getMessage().setOutboundProperty("http.status", (Object)String.valueOf(200));
            resultEvent.getMessage().setOutboundProperty("Content-Type", (Object)mimetype);
            resultEvent.getMessage().setOutboundProperty("Content-Length", (Object)buffer.length);
            resultEvent.getMessage().setOutboundProperty("Access-Control-Allow-Origin", (Object)"*");
            if (addContentEncodingHeader) {
                resultEvent.getMessage().setOutboundProperty("Content-Encoding", (Object)"gzip");
            }
            if (mimetype.equals("text/html")) {
                resultEvent.getMessage().setOutboundProperty("Expires", (Object)-1);
            }
        }
        catch (IOException e) {
            try {
                throw new ResourceNotFoundException(HttpMessages.fileNotFound((String)(RESOURCE_BASE + path)), event, (MessageProcessor)this);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(baos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)baos);
        return resultEvent;
    }

    private String getMimeType(String path) {
        String mimeType = DEFAULT_MIME_TYPE;
        if (FilenameUtils.getExtension((String)path).equals("html")) {
            mimeType = "text/html";
        } else if (FilenameUtils.getExtension((String)path).equals("js")) {
            mimeType = MIME_TYPE_JAVASCRIPT;
        } else if (FilenameUtils.getExtension((String)path).equals("png")) {
            mimeType = MIME_TYPE_PNG;
        } else if (FilenameUtils.getExtension((String)path).equals("gif")) {
            mimeType = MIME_TYPE_GIF;
        } else if (FilenameUtils.getExtension((String)path).equals("svg")) {
            mimeType = MIME_TYPE_SVG;
        } else if (FilenameUtils.getExtension((String)path).equals("css")) {
            mimeType = MIME_TYPE_CSS;
        } else if (FilenameUtils.getExtension((String)path).equals(RAML_QUERY_STRING)) {
            mimeType = "application/raml+yaml";
        }
        return mimeType;
    }

    public String getConsoleUrl() {
        String url = this.consoleBaseUri.endsWith("/") ? this.consoleBaseUri.substring(0, this.consoleBaseUri.length() - 1) : this.consoleBaseUri;
        return url + this.embeddedConsolePath;
    }
}

